/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.canal;

import com.alibaba.otter.canal.client.CanalConnector;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.load.sync.SyncChannel;
import org.apache.doris.load.sync.canal.CanalSyncChannel;
import org.apache.doris.load.sync.canal.CanalSyncDataConsumer;
import org.apache.doris.load.sync.canal.CanalSyncDataReceiver;
import org.apache.doris.load.sync.canal.CanalSyncJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncCanalClient {
    protected static Logger logger = LogManager.getLogger(SyncCanalClient.class);
    private final CanalConnector connector;
    private final CanalSyncDataReceiver receiver;
    private final CanalSyncDataConsumer consumer;
    private final Map<Long, CanalSyncChannel> idToChannels;
    protected ReentrantLock lock = new ReentrantLock(true);
    protected ReentrantLock getLock = new ReentrantLock();

    protected void lock() {
        this.lock.lock();
    }

    protected void unlock() {
        this.lock.unlock();
    }

    public SyncCanalClient(CanalSyncJob syncJob, String destination, CanalConnector connector, int batchSize, boolean debug) {
        this(syncJob, destination, connector, batchSize, debug, ".*\\..*");
    }

    public SyncCanalClient(CanalSyncJob syncJob, String destination, CanalConnector connector, int batchSize, boolean debug, String filter) {
        this.connector = connector;
        this.consumer = new CanalSyncDataConsumer(syncJob, connector, this.getLock, debug);
        this.receiver = new CanalSyncDataReceiver(syncJob, connector, destination, filter, this.consumer, batchSize, this.getLock);
        this.idToChannels = Maps.newHashMap();
    }

    public void startup() {
        Preconditions.checkNotNull((Object)this.connector, (Object)"connector is null");
        Preconditions.checkState((!this.idToChannels.isEmpty() ? 1 : 0) != 0, (Object)"no channel is registered");
        this.lock();
        try {
            this.consumer.start();
            this.receiver.start();
        }
        finally {
            this.unlock();
        }
        logger.info("canal client has been started.");
    }

    public void shutdown(boolean needCleanUp) {
        this.lock();
        try {
            this.receiver.stop();
            this.consumer.stop(needCleanUp);
        }
        finally {
            this.unlock();
        }
        logger.info("canal client has been stopped.");
    }

    public void registerChannels(List<SyncChannel> channels) {
        StringBuilder channelFilters = new StringBuilder();
        for (int i = 0; i < channels.size(); ++i) {
            CanalSyncChannel channel = (CanalSyncChannel)channels.get(i);
            String filter = channel.getSrcDataBase() + "." + channel.getSrcTable();
            String targetTable = channel.getTargetTable();
            channelFilters.append(filter);
            if (i < channels.size() - 1) {
                channelFilters.append(",");
            }
            this.idToChannels.put(channel.getId(), channel);
            logger.info("register channel, filter: {}, target table: {}", (Object)filter, (Object)targetTable);
        }
        this.receiver.setFilter(channelFilters.toString());
        this.consumer.setChannels(this.idToChannels);
    }

    public String getPositionInfo() {
        return this.consumer.getPositionInfo();
    }
}

