/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.canal;

import com.alibaba.otter.canal.common.CanalException;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.Message;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.doris.load.sync.model.Events;
import org.apache.doris.load.sync.position.EntryPosition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CanalUtils {
    private static Logger logger = LogManager.getLogger(CanalUtils.class);
    private static final String SEP = SystemUtils.LINE_SEPARATOR;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String context_format = null;
    private static String row_format = null;
    private static String transaction_format = null;

    public static void printSummary(Events<CanalEntry.Entry, EntryPosition> dataEvents) {
        List<CanalEntry.Entry> entries = dataEvents.getDatas();
        if (CollectionUtils.isEmpty(entries)) {
            return;
        }
        String startPosition = CanalUtils.buildPositionForDump(entries.get(0));
        String endPosition = CanalUtils.buildPositionForDump(entries.get(entries.size() - 1));
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        logger.info(context_format, (Object)dataEvents.getId(), (Object)entries.size(), (Object)dataEvents.getMemSize(), (Object)format.format(new Date()), (Object)startPosition, (Object)endPosition);
    }

    public static void printSummary(Message message, int size, long memsize) {
        List entries = message.getEntries();
        if (CollectionUtils.isEmpty((Collection)entries)) {
            return;
        }
        String startPosition = CanalUtils.buildPositionForDump((CanalEntry.Entry)message.getEntries().get(0));
        String endPosition = CanalUtils.buildPositionForDump((CanalEntry.Entry)message.getEntries().get(message.getEntries().size() - 1));
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        logger.info(context_format, (Object)message.getId(), (Object)size, (Object)memsize, (Object)format.format(new Date()), (Object)startPosition, (Object)endPosition);
    }

    public static String buildPositionForDump(CanalEntry.Entry entry) {
        CanalEntry.Header header = entry.getHeader();
        long time = entry.getHeader().getExecuteTime();
        Date date = new Date(time);
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        StringBuilder sb = new StringBuilder();
        sb.append(header.getLogfileName()).append(":").append(header.getLogfileOffset()).append(":").append(header.getExecuteTime()).append("(").append(format.format(date)).append(")");
        if (StringUtils.isNotEmpty((String)entry.getHeader().getGtid())) {
            sb.append(" gtid(").append(entry.getHeader().getGtid()).append(")");
        }
        return sb.toString();
    }

    public static String getFullName(String schemaName, String tableName) {
        StringBuilder sb = new StringBuilder();
        if (schemaName != null) {
            sb.append(schemaName).append(".");
        }
        sb.append(tableName);
        return sb.toString().intern();
    }

    public static void printRow(CanalEntry.RowChange rowChange, CanalEntry.Header header) {
        long executeTime = header.getExecuteTime();
        long delayTime = System.currentTimeMillis() - executeTime;
        Date date = new Date(executeTime);
        CanalEntry.EventType eventType = rowChange.getEventType();
        logger.info(row_format, (Object)header.getLogfileName(), (Object)String.valueOf(header.getLogfileOffset()), (Object)header.getSchemaName(), (Object)header.getTableName(), (Object)eventType, (Object)String.valueOf(header.getExecuteTime()), (Object)simpleDateFormat.format(date), (Object)header.getGtid(), (Object)String.valueOf(delayTime));
        if (eventType == CanalEntry.EventType.QUERY || rowChange.getIsDdl()) {
            logger.info(" sql ----> " + rowChange.getSql() + SEP);
            return;
        }
        CanalUtils.printXAInfo(rowChange.getPropsList());
        for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
            if (eventType == CanalEntry.EventType.DELETE) {
                CanalUtils.printColumn(rowData.getBeforeColumnsList());
                continue;
            }
            if (eventType == CanalEntry.EventType.INSERT) {
                CanalUtils.printColumn(rowData.getAfterColumnsList());
                continue;
            }
            CanalUtils.printColumn(rowData.getAfterColumnsList());
        }
    }

    public static void printColumn(List<CanalEntry.Column> columns) {
        StringBuilder builder = new StringBuilder();
        for (CanalEntry.Column column : columns) {
            try {
                if (StringUtils.containsIgnoreCase((String)column.getMysqlType(), (String)"BLOB") || StringUtils.containsIgnoreCase((String)column.getMysqlType(), (String)"BINARY")) {
                    builder.append(column.getName()).append(" : ").append(new String(column.getValue().getBytes("ISO-8859-1"), "UTF-8"));
                } else {
                    builder.append(column.getName()).append(" : ").append(column.getValue());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            builder.append("    type=").append(column.getMysqlType());
            if (column.getUpdated()) {
                builder.append("    update=").append(column.getUpdated());
            }
            builder.append(SEP);
        }
        logger.info(builder.toString());
    }

    public static void printXAInfo(List<CanalEntry.Pair> pairs) {
        if (pairs == null) {
            return;
        }
        String xaType = null;
        String xaXid = null;
        for (CanalEntry.Pair pair : pairs) {
            String key = pair.getKey();
            if (StringUtils.endsWithIgnoreCase((String)key, (String)"XA_TYPE")) {
                xaType = pair.getValue();
                continue;
            }
            if (!StringUtils.endsWithIgnoreCase((String)key, (String)"XA_XID")) continue;
            xaXid = pair.getValue();
        }
        if (xaType != null && xaXid != null) {
            logger.info(" ------> " + xaType + " " + xaXid);
        }
    }

    public static void transactionBegin(CanalEntry.Entry entry) {
        long executeTime = entry.getHeader().getExecuteTime();
        long delayTime = System.currentTimeMillis() - executeTime;
        Date date = new Date(executeTime);
        CanalEntry.TransactionBegin begin = null;
        try {
            begin = CanalEntry.TransactionBegin.parseFrom((ByteString)entry.getStoreValue());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CanalException("parse event has an error , data:" + entry.toString(), (Throwable)e);
        }
        logger.info(transaction_format, (Object)entry.getHeader().getLogfileName(), (Object)String.valueOf(entry.getHeader().getLogfileOffset()), (Object)String.valueOf(entry.getHeader().getExecuteTime()), (Object)simpleDateFormat.format(date), (Object)entry.getHeader().getGtid(), (Object)String.valueOf(delayTime));
        logger.info(" BEGIN ----> Thread id: {}", (Object)begin.getThreadId());
        CanalUtils.printXAInfo(begin.getPropsList());
    }

    public static void transactionEnd(CanalEntry.Entry entry) {
        long executeTime = entry.getHeader().getExecuteTime();
        long delayTime = System.currentTimeMillis() - executeTime;
        Date date = new Date(executeTime);
        CanalEntry.TransactionEnd end = null;
        try {
            end = CanalEntry.TransactionEnd.parseFrom((ByteString)entry.getStoreValue());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CanalException("parse event has an error , data:" + entry.toString(), (Throwable)e);
        }
        logger.info("----------------\n");
        logger.info(" END ----> transaction id: {}", (Object)end.getTransactionId());
        CanalUtils.printXAInfo(end.getPropsList());
        logger.info(transaction_format, (Object)entry.getHeader().getLogfileName(), (Object)String.valueOf(entry.getHeader().getLogfileOffset()), (Object)String.valueOf(entry.getHeader().getExecuteTime()), (Object)simpleDateFormat.format(date), (Object)entry.getHeader().getGtid(), (Object)String.valueOf(delayTime));
    }

    public static boolean isDML(CanalEntry.EventType eventType) {
        switch (eventType) {
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    static {
        context_format = SEP + "----------- Batch Summary ------------------------------>" + SEP;
        context_format = context_format + "| Batch Id: [{}] ,count : [{}] , Mem size : [{}] , Time : {}" + SEP;
        context_format = context_format + "| Start : [{}] " + SEP;
        context_format = context_format + "| End : [{}] " + SEP;
        context_format = context_format + "----------------------------------------------------------" + SEP;
        row_format = SEP + "----------------> binlog[{}:{}] , name[{},{}] , eventType : {} , executeTime : {}({}) , gtid : ({}) , delay : {} ms" + SEP;
        transaction_format = SEP + "================> binlog[{}:{}] , executeTime : {}({}) , gtid : ({}) , delay : {}ms" + SEP;
    }
}

