/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.canal;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalConnectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Map;
import org.apache.doris.analysis.BinlogDesc;
import org.apache.doris.analysis.ChannelDescription;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.sync.DataSyncJobType;
import org.apache.doris.load.sync.SyncFailMsg;
import org.apache.doris.load.sync.SyncJob;
import org.apache.doris.load.sync.canal.CanalDestination;
import org.apache.doris.load.sync.canal.CanalSyncChannel;
import org.apache.doris.load.sync.canal.SyncCanalClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CanalSyncJob
extends SyncJob {
    private static final Logger LOG = LogManager.getLogger(CanalSyncJob.class);
    protected static final String CANAL_SERVER_IP = "canal.server.ip";
    protected static final String CANAL_SERVER_PORT = "canal.server.port";
    protected static final String CANAL_DESTINATION = "canal.destination";
    protected static final String CANAL_USERNAME = "canal.username";
    protected static final String CANAL_PASSWORD = "canal.password";
    protected static final String CANAL_BATCH_SIZE = "canal.batchSize";
    protected static final String CANAL_DEBUG = "canal.debug";
    @SerializedName(value="remote")
    private final CanalDestination remote;
    @SerializedName(value="username")
    private String username;
    @SerializedName(value="password")
    private String password;
    @SerializedName(value="batchSize")
    private int batchSize = 8192;
    @SerializedName(value="debug")
    private boolean debug = false;
    private transient SyncCanalClient client;

    public CanalSyncJob(long id, String jobName, long dbId) {
        super(id, jobName, dbId);
        this.dataSyncJobType = DataSyncJobType.CANAL;
        this.remote = new CanalDestination("", 0, "");
    }

    private void init() throws DdlException {
        CanalConnector connector = CanalConnectors.newSingleConnector((SocketAddress)new InetSocketAddress(this.remote.getIp(), this.remote.getPort()), (String)this.remote.getDestination(), (String)this.username, (String)this.password);
        this.initChannels();
        this.client = new SyncCanalClient(this, this.remote.getDestination(), connector, this.batchSize, this.debug);
        this.client.registerChannels(this.channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initChannels() throws DdlException {
        if (this.channels == null) {
            this.channels = Lists.newArrayList();
        }
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(this.dbId);
        db.writeLock();
        try {
            for (ChannelDescription channelDescription : this.channelDescriptions) {
                String tableName = channelDescription.getTargetTable();
                OlapTable olapTable = db.getOlapTableOrDdlException(tableName);
                if (olapTable.getKeysType() != KeysType.UNIQUE_KEYS || !olapTable.hasDeleteSign()) {
                    throw new DdlException("Table[" + tableName + "] don't support batch delete.");
                }
                ArrayList colNames = channelDescription.getColNames();
                if (colNames == null) {
                    colNames = Lists.newArrayList();
                    for (Column column : olapTable.getBaseSchema(false)) {
                        colNames.add(column.getName());
                    }
                }
                CanalSyncChannel syncChannel = new CanalSyncChannel(channelDescription.getChannelId(), this, db, olapTable, colNames, channelDescription.getSrcDatabase(), channelDescription.getSrcTableName());
                if (channelDescription.getPartitionNames() != null) {
                    syncChannel.setPartitions(channelDescription.getPartitionNames());
                }
                this.channels.add(syncChannel);
            }
        }
        finally {
            db.writeUnlock();
        }
    }

    @Override
    public void checkAndSetBinlogInfo(BinlogDesc binlogDesc) throws DdlException {
        super.checkAndSetBinlogInfo(binlogDesc);
        Map<String, String> properties = binlogDesc.getProperties();
        this.remote.parse(properties);
        if (!properties.containsKey(CANAL_USERNAME)) {
            throw new DdlException("Missing canal.username property in binlog properties");
        }
        this.username = properties.get(CANAL_USERNAME);
        if (!properties.containsKey(CANAL_PASSWORD)) {
            throw new DdlException("Missing canal.password property in binlog properties");
        }
        this.password = properties.get(CANAL_PASSWORD);
        if (properties.containsKey(CANAL_BATCH_SIZE)) {
            try {
                this.batchSize = Integer.parseInt(properties.get(CANAL_BATCH_SIZE));
            }
            catch (NumberFormatException e) {
                throw new DdlException("Property canal.batchSize is not int");
            }
        }
        if (properties.containsKey(CANAL_DEBUG)) {
            this.debug = Boolean.parseBoolean(properties.get(CANAL_DEBUG));
        }
    }

    public boolean isInit() {
        return this.client != null && this.channels != null;
    }

    @Override
    public boolean isNeedReschedule() {
        return this.jobState == SyncJob.JobState.RUNNING && !this.isInit();
    }

    @Override
    public void execute() throws UserException {
        LOG.info(new LogBuilder(LogKey.SYNC_JOB, this.id).add("remote ip", this.remote.getIp()).add("remote port", this.remote.getPort()).add("msg", "Try to start canal client.").add("debug", this.debug).build());
        if (!this.isInit()) {
            this.init();
        }
        this.unprotectedStartClient();
    }

    @Override
    public void cancel(SyncFailMsg.MsgType msgType, String errMsg) {
        try {
            switch (msgType) {
                case SUBMIT_FAIL: 
                case RUN_FAIL: 
                case UNKNOWN: {
                    this.unprotectedStopClient(SyncJob.JobState.PAUSED);
                    break;
                }
                case SCHEDULE_FAIL: 
                case USER_CANCEL: {
                    this.unprotectedStopClient(SyncJob.JobState.CANCELLED);
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)("unknown msg type: " + msgType.name()));
                }
            }
            this.failMsg = new SyncFailMsg(msgType, errMsg);
            LOG.info(new LogBuilder(LogKey.SYNC_JOB, this.id).add("MsgType", msgType.name()).add("msg", "Cancel canal sync job.").add("errMsg", errMsg).build());
        }
        catch (UserException e) {
            LOG.warn(new LogBuilder(LogKey.SYNC_JOB, this.id).add("msg", "Failed to cancel canal sync job.").build(), (Throwable)e);
        }
    }

    @Override
    public void pause() throws UserException {
        this.unprotectedStopClient(SyncJob.JobState.PAUSED);
        LOG.info(new LogBuilder(LogKey.SYNC_JOB, this.id).add("remote ip", this.remote.getIp()).add("remote port", this.remote.getPort()).add("msg", "Pause canal sync job.").add("debug", this.debug).build());
    }

    @Override
    public void resume() throws UserException {
        this.updateState(SyncJob.JobState.PENDING, false);
        LOG.info(new LogBuilder(LogKey.SYNC_JOB, this.id).add("remote ip", this.remote.getIp()).add("remote port", this.remote.getPort()).add("msg", "Resume canal sync job.").add("debug", this.debug).build());
    }

    public void unprotectedStartClient() throws UserException {
        this.client.startup();
        this.updateState(SyncJob.JobState.RUNNING, false);
        LOG.info(new LogBuilder(LogKey.SYNC_JOB, this.id).add("name", this.jobName).add("msg", "Client has been started.").build());
    }

    public void unprotectedStopClient(SyncJob.JobState jobState) throws UserException {
        if (jobState != SyncJob.JobState.CANCELLED && jobState != SyncJob.JobState.PAUSED) {
            return;
        }
        if (this.client != null) {
            this.client.shutdown(true);
        }
        this.updateState(jobState, false);
        LOG.info(new LogBuilder(LogKey.SYNC_JOB, this.id).add("name", this.jobName).add("msg", "Client has been stopped.").build());
    }

    @Override
    public void replayUpdateSyncJobState(SyncJob.SyncJobUpdateStateInfo info) {
        this.lastStartTimeMs = info.getLastStartTimeMs();
        this.lastStopTimeMs = info.getLastStopTimeMs();
        this.finishTimeMs = info.getFinishTimeMs();
        this.failMsg = info.getFailMsg();
        try {
            SyncJob.JobState jobState = info.getJobState();
            switch (jobState) {
                case PENDING: {
                    this.updateState(SyncJob.JobState.PENDING, true);
                    break;
                }
                case RUNNING: {
                    this.updateState(SyncJob.JobState.RUNNING, true);
                    break;
                }
                case PAUSED: {
                    this.updateState(SyncJob.JobState.PAUSED, true);
                    break;
                }
                case CANCELLED: {
                    this.updateState(SyncJob.JobState.CANCELLED, true);
                }
            }
        }
        catch (UserException e) {
            LOG.error(new LogBuilder(LogKey.SYNC_JOB, this.id).add("desired_state", (Object)info.getJobState()).add("msg", "replay update state error.").add("reason", e.getMessage()).build(), (Throwable)e);
        }
        LOG.info(new LogBuilder(LogKey.SYNC_JOB, info.getId()).add("desired_state:", (Object)info.getJobState()).add("msg", "replay update sync job state").build());
    }

    @Override
    public String getStatus() {
        if (this.client != null) {
            return this.client.getPositionInfo();
        }
        return "\\N";
    }

    @Override
    public String getJobConfig() {
        StringBuilder sb = new StringBuilder();
        sb.append("address:").append(this.remote.getIp()).append(":").append(this.remote.getPort()).append(",").append("destination:").append(this.remote.getDestination()).append(",").append("batchSize:").append(this.batchSize);
        return sb.toString();
    }

    public CanalDestination getRemote() {
        return this.remote;
    }

    public String toString() {
        return "SyncJob [jobId=" + this.id + ", jobName=" + this.jobName + ", dbId=" + this.dbId + ", state=" + (Object)((Object)this.jobState) + ", createTimeMs=" + TimeUtils.longToTimeString(this.createTimeMs) + ", lastStartTimeMs=" + TimeUtils.longToTimeString(this.lastStartTimeMs) + ", lastStopTimeMs=" + TimeUtils.longToTimeString(this.lastStopTimeMs) + ", finishTimeMs=" + TimeUtils.longToTimeString(this.finishTimeMs) + "]";
    }
}

