/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.canal;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.protocol.Message;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.load.sync.SyncDataReceiver;
import org.apache.doris.load.sync.canal.CanalConfigs;
import org.apache.doris.load.sync.canal.CanalSyncDataConsumer;
import org.apache.doris.load.sync.canal.CanalSyncJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CanalSyncDataReceiver
extends SyncDataReceiver {
    private static Logger LOG = LogManager.getLogger(CanalSyncDataReceiver.class);
    private CanalSyncJob syncJob;
    private CanalConnector connector;
    private ReentrantLock getLock;
    private CanalSyncDataConsumer consumer;
    private String destination;
    private String filter;
    private long sleepTimeMs;

    public CanalSyncDataReceiver(CanalSyncJob syncJob, CanalConnector connector, String destination, String filter, CanalSyncDataConsumer consumer, int readBatchSize, ReentrantLock getLock) {
        super(readBatchSize);
        this.syncJob = syncJob;
        this.connector = connector;
        this.consumer = consumer;
        this.destination = destination;
        this.filter = filter;
        this.getLock = getLock;
        this.sleepTimeMs = 20L;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public void start() {
        super.start();
        LOG.info("receiver has been started. destination: {}, filter: {}, batch size: {}", (Object)this.destination, (Object)this.filter, (Object)this.readBatchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        while (this.running) {
            try {
                this.connector.connect();
                this.connector.subscribe(this.filter);
                this.connector.rollback();
                while (this.running) {
                    Message message;
                    this.holdGetLock();
                    try {
                        message = this.connector.getWithoutAck(this.readBatchSize, Long.valueOf(CanalConfigs.getWaitingTimeoutMs), TimeUnit.MILLISECONDS);
                    }
                    finally {
                        this.releaseGetLock();
                    }
                    int size = message.isRaw() ? message.getRawEntries().size() : message.getEntries().size();
                    if (message.getId() == -1L || size == 0) {
                        try {
                            Thread.sleep(this.sleepTimeMs);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.consumer.put(message, size);
                }
            }
            catch (Throwable e) {
                LOG.error("Receiver is error. {}", (Object)e.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.connector.disconnect();
            }
        }
    }

    private void holdGetLock() {
        this.getLock.lock();
    }

    private void releaseGetLock() {
        this.getLock.unlock();
    }
}

