/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.canal;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.common.CanalException;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.Message;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.common.Config;
import org.apache.doris.common.Status;
import org.apache.doris.common.UserException;
import org.apache.doris.load.sync.SyncChannelHandle;
import org.apache.doris.load.sync.SyncDataConsumer;
import org.apache.doris.load.sync.SyncFailMsg;
import org.apache.doris.load.sync.canal.CanalConfigs;
import org.apache.doris.load.sync.canal.CanalSyncChannel;
import org.apache.doris.load.sync.canal.CanalSyncJob;
import org.apache.doris.load.sync.canal.CanalUtils;
import org.apache.doris.load.sync.model.Events;
import org.apache.doris.load.sync.position.EntryPosition;
import org.apache.doris.load.sync.position.PositionMeta;
import org.apache.doris.load.sync.position.PositionRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CanalSyncDataConsumer
extends SyncDataConsumer {
    private static Logger logger = LogManager.getLogger(CanalSyncDataConsumer.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final long MIN_COMMIT_EVENT_SIZE = Config.min_sync_commit_size;
    private static final long MIN_COMMIT_MEM_SIZE = Config.min_bytes_sync_commit;
    private static final long MAX_COMMIT_MEM_SIZE = Config.max_bytes_sync_commit;
    private CanalSyncJob syncJob;
    private CanalConnector connector;
    private Map<Long, CanalSyncChannel> idToChannels;
    private Set<Long> ackBatches;
    private PositionMeta<EntryPosition> positionMeta;
    private LinkedBlockingQueue<Events<CanalEntry.Entry, EntryPosition>> dataBlockingQueue;
    private SyncChannelHandle handle;
    private ReentrantLock getLock;
    private int sleepTimeMs;
    private long commitIntervalSecond;

    public void setChannels(Map<Long, CanalSyncChannel> idToChannels) {
        for (CanalSyncChannel channel : idToChannels.values()) {
            this.positionMeta.setCommitPosition(channel.getId(), EntryPosition.MIN_POS);
            channel.setCallback(this.handle);
        }
        this.idToChannels = idToChannels;
    }

    public CanalSyncDataConsumer(CanalSyncJob syncJob, CanalConnector connector, ReentrantLock getLock, boolean debug) {
        super(debug);
        this.syncJob = syncJob;
        this.connector = connector;
        this.dataBlockingQueue = Queues.newLinkedBlockingQueue((int)1024);
        this.ackBatches = Sets.newHashSet();
        this.positionMeta = new PositionMeta();
        this.getLock = getLock;
        this.handle = new SyncChannelHandle();
        this.commitIntervalSecond = Config.sync_commit_interval_second;
        this.sleepTimeMs = 500;
    }

    public void stop(boolean needCleanUp) {
        super.stop();
        if (needCleanUp) {
            this.cleanUp();
        }
    }

    @Override
    public void beginForTxn() {
        this.handle.reset(this.idToChannels.size());
        for (CanalSyncChannel channel : this.idToChannels.values()) {
            channel.initTxn(Config.max_stream_load_timeout_second);
            this.handle.mark(channel);
        }
    }

    @Override
    public void abortForTxn(String reason) {
        this.abortForTxn(this.idToChannels.values(), reason);
    }

    public void abortForTxn(Collection<CanalSyncChannel> channels, String reason) {
        logger.info("client is aborting transactions. JobId: {}, reason: {}", (Object)this.syncJob.getId(), (Object)reason);
        for (CanalSyncChannel channel : channels) {
            if (!channel.isTxnBegin()) continue;
            try {
                channel.abortTxn(reason);
            }
            catch (Exception e) {
                logger.warn("Abort channel failed. jobId: {}\uff0cchannel: {}, target: {}, msg: {}", (Object)this.syncJob.getId(), (Object)channel.getId(), (Object)channel.getTargetTable(), (Object)e.getMessage());
            }
        }
        this.rollback();
    }

    @Override
    public void commitForTxn() {
        logger.info("client is committing transactions. JobId: {}", (Object)this.syncJob.getId());
        boolean success = true;
        EntryPosition latestPosition = this.positionMeta.getLatestPosition();
        for (CanalSyncChannel channel : this.idToChannels.values()) {
            if (!channel.isTxnBegin()) continue;
            try {
                channel.commitTxn();
                this.positionMeta.setCommitPosition(channel.getId(), latestPosition);
            }
            catch (Exception ce) {
                logger.warn("Commit channel failed. JobId: {}, channel: {}, target: {}, msg: {}", (Object)this.syncJob.getId(), (Object)channel.getId(), (Object)channel.getTargetTable(), (Object)ce.getMessage());
                try {
                    channel.abortTxn(ce.getMessage());
                }
                catch (Exception ae) {
                    logger.warn("Abort channel failed. JobId: {}\uff0cchannel: {}, target: {}, msg: {}", (Object)this.syncJob.getId(), (Object)channel.getId(), (Object)channel.getTargetTable(), (Object)ae.getMessage());
                }
                success = false;
            }
        }
        if (success) {
            this.ack();
        } else {
            this.rollback();
        }
    }

    public Status waitForTxn() {
        for (CanalSyncChannel channel : this.idToChannels.values()) {
            channel.submitEOF();
        }
        Status st = Status.CANCELLED;
        try {
            this.handle.join();
            st = this.handle.getStatus();
        }
        catch (InterruptedException e) {
            logger.warn("InterruptedException: ", (Throwable)e);
        }
        return st;
    }

    public void cleanForTxn() {
        for (CanalSyncChannel channel : this.idToChannels.values()) {
            if (!channel.isTxnInit()) continue;
            channel.clearTxn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        while (this.running) {
            try {
                int totalSize = 0;
                long totalMemSize = 0L;
                long startTime = System.currentTimeMillis();
                this.beginForTxn();
                while (this.running) {
                    Events<CanalEntry.Entry, EntryPosition> dataEvents = null;
                    try {
                        dataEvents = this.dataBlockingQueue.poll(CanalConfigs.pollWaitingTimeoutMs, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (dataEvents == null) {
                        if ((long)totalSize >= MIN_COMMIT_EVENT_SIZE || totalMemSize >= MIN_COMMIT_MEM_SIZE) break;
                        try {
                            Thread.sleep(this.sleepTimeMs);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        if (this.debug) {
                            CanalUtils.printSummary(dataEvents);
                        }
                        List<CanalEntry.Entry> entries = dataEvents.getDatas();
                        int size = entries.size();
                        this.ackBatches.add(dataEvents.getId());
                        this.positionMeta.addBatch(dataEvents.getId(), dataEvents.getPositionRange());
                        this.executeOneBatch(dataEvents);
                        totalSize += size;
                        if ((totalMemSize += dataEvents.getMemSize()) >= MAX_COMMIT_MEM_SIZE) break;
                    }
                    if (System.currentTimeMillis() - startTime < this.commitIntervalSecond * 1000L) continue;
                    break;
                }
                Status st = this.waitForTxn();
                if (!this.running) {
                    this.abortForTxn("stopping client");
                    continue;
                }
                if (st.ok()) {
                    this.commitForTxn();
                    continue;
                }
                this.abortForTxn(st.getErrorMsg());
                this.syncJob.cancel(SyncFailMsg.MsgType.RUN_FAIL, st.getErrorMsg());
            }
            catch (Exception e) {
                logger.error("Executor is error!", (Throwable)e);
                this.abortForTxn(e.getMessage());
                this.syncJob.cancel(SyncFailMsg.MsgType.SUBMIT_FAIL, e.getMessage());
            }
            finally {
                this.cleanForTxn();
            }
        }
    }

    public void put(Message message, int size) {
        EntryPosition firstPosition;
        ArrayList<CanalEntry.Entry> entries;
        if (message.isRaw()) {
            entries = new ArrayList<CanalEntry.Entry>(message.getRawEntries().size());
            for (ByteString rawEntry : message.getRawEntries()) {
                try {
                    entries.add(CanalEntry.Entry.parseFrom((ByteString)rawEntry));
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CanalException((Throwable)e);
                }
            }
        } else {
            entries = message.getEntries();
        }
        int startIndex = 0;
        EntryPosition lastAckPosition = this.positionMeta.getAckPosition();
        if (lastAckPosition != null && EntryPosition.min(firstPosition = EntryPosition.createPosition((CanalEntry.Entry)entries.get(0)), lastAckPosition).equals(firstPosition)) {
            for (int i = 0; i <= entries.size() - 1; ++i) {
                ++startIndex;
                if (EntryPosition.checkPosition((CanalEntry.Entry)entries.get(i), lastAckPosition)) break;
            }
        }
        if (startIndex <= size - 1) {
            Events dataEvents = new Events(message.getId());
            PositionRange<EntryPosition> range = new PositionRange<EntryPosition>();
            dataEvents.setPositionRange(range);
            range.setStart(EntryPosition.createPosition((CanalEntry.Entry)entries.get(startIndex)));
            range.setEnd(EntryPosition.createPosition((CanalEntry.Entry)entries.get(size - 1)));
            dataEvents.setDatas(entries);
            long memsize = 0L;
            for (CanalEntry.Entry entry : entries) {
                memsize += entry.getHeader().getEventLength();
            }
            dataEvents.setMemSize(memsize);
            try {
                this.dataBlockingQueue.put(dataEvents);
            }
            catch (InterruptedException e) {
                logger.error("put message to executor error:", (Throwable)e);
                throw new CanalException((Throwable)e);
            }
        }
    }

    private void executeOneBatch(Events<CanalEntry.Entry, EntryPosition> dataEvents) throws UserException {
        long batchId = dataEvents.getId();
        HashMap preferChannels = Maps.newHashMap();
        HashMap secondaryChannels = Maps.newHashMap();
        EntryPosition startPosition = dataEvents.getPositionRange().getStart();
        EntryPosition endPosition = dataEvents.getPositionRange().getEnd();
        for (CanalSyncChannel channel : this.idToChannels.values()) {
            String key = CanalUtils.getFullName(channel.getSrcDataBase(), channel.getSrcTable());
            EntryPosition commitPosition = this.positionMeta.getCommitPosition(channel.getId());
            if (commitPosition != null) {
                if (commitPosition.compareTo(startPosition) < 0) {
                    preferChannels.put(key, channel);
                    continue;
                }
                if (commitPosition.compareTo(endPosition) >= 0) continue;
                secondaryChannels.put(key, channel);
                continue;
            }
            preferChannels.put(key, channel);
        }
        for (CanalEntry.Entry entry : dataEvents.getDatas()) {
            CanalEntry.EntryType entryType = entry.getEntryType();
            try {
                CanalSyncChannel channel;
                CanalEntry.RowChange rowChange;
                if (entryType != CanalEntry.EntryType.ROWDATA) continue;
                try {
                    rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CanalException("parse event has an error , data:" + entry.toString(), (Throwable)e);
                }
                CanalEntry.Header header = entry.getHeader();
                CanalEntry.EventType eventType = rowChange.getEventType();
                if (!CanalUtils.isDML(eventType) || rowChange.getIsDdl()) {
                    String sql = rowChange.getSql();
                    this.processDDL(header, eventType, sql);
                    return;
                }
                String schemaTableName = CanalUtils.getFullName(header.getSchemaName(), header.getTableName());
                if (preferChannels.containsKey(schemaTableName)) {
                    channel = (CanalSyncChannel)preferChannels.get(schemaTableName);
                    channel.submit(batchId, eventType, rowChange);
                } else if (secondaryChannels.containsKey(schemaTableName)) {
                    EntryPosition commitPosition;
                    channel = (CanalSyncChannel)secondaryChannels.get(schemaTableName);
                    EntryPosition position = EntryPosition.createPosition(entry);
                    if (position.compareTo(commitPosition = this.positionMeta.getCommitPosition(channel.getId())) > 0) {
                        channel.submit(batchId, eventType, rowChange);
                    }
                }
                if (!this.debug) continue;
                CanalUtils.printRow(rowChange, header);
            }
            catch (Exception e) {
                logger.error("execute event has an error, data: {}, msg: {}", (Object)entry.toString(), (Object)e);
                throw new UserException("execute batch failed, batchId: " + batchId + " ,msg: " + e.getMessage());
            }
        }
    }

    private void processDDL(CanalEntry.Header header, CanalEntry.EventType eventType, String sql) {
        String table = header.getSchemaName() + "." + header.getTableName();
        switch (eventType) {
            case CREATE: {
                logger.warn("parse create table event, table: {}, sql: {}", (Object)table, (Object)sql);
                return;
            }
            case ALTER: {
                logger.warn("parse alter table event, table: {}, sql: {}", (Object)table, (Object)sql);
                return;
            }
            case TRUNCATE: {
                logger.warn("parse truncate table event, table: {}, sql: {}", (Object)table, (Object)sql);
                return;
            }
            case ERASE: 
            case QUERY: {
                logger.warn("parse event : {}, sql: {} . ignored!", (Object)eventType.name(), (Object)sql);
                return;
            }
            case RENAME: {
                logger.warn("parse rename table event, table: {}, sql: {}", (Object)table, (Object)sql);
                return;
            }
            case CINDEX: {
                logger.warn("parse create index event, table: {}, sql: {}", (Object)table, (Object)sql);
                return;
            }
            case DINDEX: {
                logger.warn("parse delete index event, table: {}, sql: {}", (Object)table, (Object)sql);
                return;
            }
        }
        logger.warn("parse unknown event: {}, table: {}, sql: {}", (Object)eventType.name(), (Object)table, (Object)sql);
    }

    private void ack() {
        if (!this.ackBatches.isEmpty()) {
            logger.info("client ack batches: {}", this.ackBatches);
            while (!this.ackBatches.isEmpty()) {
                long minBatchId = Collections.min(this.ackBatches);
                this.connector.ack(minBatchId);
                this.ackBatches.remove(minBatchId);
                PositionRange<EntryPosition> positionRange = this.positionMeta.removeBatch(minBatchId);
                this.positionMeta.setAckPosition(positionRange.getEnd());
                this.positionMeta.setAckTime(System.currentTimeMillis());
            }
        }
    }

    private void rollback() {
        this.holdGetLock();
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.ackBatches.isEmpty()) {
                this.connector.rollback();
            }
        }
        finally {
            this.releaseGetLock();
        }
        this.dataBlockingQueue.clear();
        this.ackBatches.clear();
        this.positionMeta.clearAllBatch();
    }

    public String getPositionInfo() {
        EntryPosition ackPosition = this.positionMeta.getAckPosition();
        long ackTime = this.positionMeta.getAckTime();
        StringBuilder sb = new StringBuilder();
        if (ackPosition != null) {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            long executeTime = ackPosition.getExecuteTime();
            long delayTime = ackTime - executeTime;
            Date date = new Date(executeTime);
            sb.append("position:").append(ackPosition).append(", executeTime:[").append(format.format(date)).append("], ").append("delay:").append(delayTime).append("ms");
            if (StringUtils.isNotEmpty((String)ackPosition.getGtid())) {
                sb.append(", gtid(").append(ackPosition.getGtid()).append(") ");
            }
        } else {
            sb.append("position:").append("N/A");
        }
        return sb.toString();
    }

    private void cleanUp() {
        this.dataBlockingQueue.clear();
        this.ackBatches.clear();
        this.positionMeta.cleanUp();
    }

    private void holdGetLock() {
        this.getLock.lock();
    }

    private void releaseGetLock() {
        this.getLock.unlock();
    }
}

