/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.canal;

import com.alibaba.otter.canal.common.CanalException;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.UserException;
import org.apache.doris.load.sync.SyncChannel;
import org.apache.doris.load.sync.SyncChannelCallback;
import org.apache.doris.load.sync.SyncJob;
import org.apache.doris.load.sync.model.Data;
import org.apache.doris.proto.InternalService;
import org.apache.doris.qe.InsertStreamTxnExecutor;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.task.SyncTask;
import org.apache.doris.task.SyncTaskPool;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.TMergeType;
import org.apache.doris.thrift.TStreamLoadPutRequest;
import org.apache.doris.thrift.TTxnParams;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.DatabaseTransactionMgr;
import org.apache.doris.transaction.GlobalTransactionMgr;
import org.apache.doris.transaction.TransactionEntry;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class CanalSyncChannel
extends SyncChannel {
    private static final Logger LOG = LogManager.getLogger(CanalSyncChannel.class);
    private static final String DELETE_COLUMN = "_delete_sign_";
    private static final String DELETE_CONDITION = "_delete_sign_=1";
    private static final String NULL_VALUE_FOR_LOAD = "\\N";
    private final int index = SyncTaskPool.getNextIndex();
    private long timeoutSecond = -1L;
    private long lastBatchId = -1L;
    private Data<InternalService.PDataRow> batchBuffer = new Data();
    private InsertStreamTxnExecutor txnExecutor;

    public CanalSyncChannel(long id, SyncJob syncJob, Database db, OlapTable table, List<String> columns, String srcDataBase, String srcTable) {
        super(id, syncJob, db, table, columns, srcDataBase, srcTable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beginTxn(long batchId) throws UserException, TException, TimeoutException, InterruptedException, ExecutionException {
        if (this.isTxnBegin()) return;
        long currentTime = System.currentTimeMillis();
        String label = "label_job" + this.jobId + "_channel" + this.id + "_db" + this.db.getId() + "_tbl" + this.tbl.getId() + "_batch" + batchId + "_" + currentTime;
        String targetColumn = Joiner.on((String)",").join((Iterable)this.columns) + "," + DELETE_COLUMN;
        GlobalTransactionMgr globalTransactionMgr = Catalog.getCurrentGlobalTransactionMgr();
        DatabaseTransactionMgr databaseTransactionMgr = globalTransactionMgr.getDatabaseTransactionMgr(this.db.getId());
        if (databaseTransactionMgr.getRunningTxnNums() < Config.max_running_txn_num_per_db) {
            long txnId;
            TransactionEntry txnEntry = this.txnExecutor.getTxnEntry();
            TTxnParams txnConf = txnEntry.getTxnConf();
            TransactionState.LoadJobSourceType sourceType = TransactionState.LoadJobSourceType.INSERT_STREAMING;
            TStreamLoadPutRequest request = null;
            try {
                txnId = globalTransactionMgr.beginTransaction(this.db.getId(), Lists.newArrayList((Object[])new Long[]{this.tbl.getId()}), label, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), sourceType, this.timeoutSecond);
                String authCodeUuid = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(this.db.getId(), txnId).getAuthCode();
                request = new TStreamLoadPutRequest().setTxnId(txnId).setDb(txnConf.getDb()).setTbl(txnConf.getTbl()).setFileType(TFileType.FILE_STREAM).setFormatType(TFileFormatType.FORMAT_CSV_PLAIN).setThriftRpcTimeoutMs(5000L).setLoadId(this.txnExecutor.getLoadId()).setMergeType(TMergeType.MERGE).setDeleteCondition(DELETE_CONDITION).setColumns(targetColumn);
                txnConf.setTxnId(txnId).setAuthCodeUuid(authCodeUuid);
                txnEntry.setLabel(label);
                this.txnExecutor.setTxnId(txnId);
            }
            catch (DuplicatedRequestException e) {
                LOG.warn("duplicate request for sync channel. channel: {}, request id: {}, txn: {}, table: {}", (Object)this.id, (Object)e.getDuplicatedRequestId(), (Object)e.getTxnId(), (Object)this.targetTable);
                this.txnExecutor.setTxnId(e.getTxnId());
            }
            catch (LabelAlreadyUsedException e) {
                LOG.warn("Label already used in channel {}, label: {}, table: {}, batch: {}", (Object)this.id, (Object)label, (Object)this.targetTable, (Object)batchId);
                return;
            }
            catch (AnalysisException | BeginTransactionException e) {
                LOG.warn("encounter an error when beginning txn in channel {}, table: {}", (Object)this.id, (Object)this.targetTable);
                throw e;
            }
            catch (UserException e) {
                LOG.warn("encounter an error when creating plan in channel {}, table: {}", (Object)this.id, (Object)this.targetTable);
                throw e;
            }
            try {
                txnId = this.txnExecutor.getTxnId();
                if (txnId == -1L) return;
                this.txnExecutor.beginTransaction(request);
                LOG.info("begin txn in channel {}, table: {}, label:{}, txn id: {}", (Object)this.id, (Object)this.targetTable, (Object)label, (Object)this.txnExecutor.getTxnId());
                return;
            }
            catch (TException e) {
                LOG.warn("Failed to begin txn in channel {}, table: {}, txn: {}, msg:{}", (Object)this.id, (Object)this.targetTable, (Object)this.txnExecutor.getTxnId(), (Object)e.getMessage());
                throw e;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.warn("Error occur while waiting begin txn response in channel {}, table: {}, txn: {}, msg:{}", (Object)this.id, (Object)this.targetTable, (Object)this.txnExecutor.getTxnId(), (Object)e.getMessage());
                throw e;
            }
        }
        String failMsg = "current running txns on db " + this.db.getId() + " is " + databaseTransactionMgr.getRunningTxnNums() + ", larger than limit " + Config.max_running_txn_num_per_db;
        LOG.warn(failMsg);
        throw new BeginTransactionException(failMsg);
    }

    @Override
    public void abortTxn(String reason) throws TException, TimeoutException, InterruptedException, ExecutionException {
        if (!this.isTxnBegin()) {
            LOG.warn("No transaction to abort in channel {}, table: {}", (Object)this.id, (Object)this.targetTable);
            return;
        }
        try {
            this.txnExecutor.abortTransaction();
            LOG.info("abort txn in channel {}, table: {}, txn id: {}, last batch: {}, reason: {}", (Object)this.id, (Object)this.targetTable, (Object)this.txnExecutor.getTxnId(), (Object)this.lastBatchId, (Object)reason);
        }
        catch (TException e) {
            LOG.warn("Failed to abort txn in channel {}, table: {}, txn: {}, msg:{}", (Object)this.id, (Object)this.targetTable, (Object)this.txnExecutor.getTxnId(), (Object)e.getMessage());
            throw e;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn("Error occur while waiting abort txn response in channel {}, table: {}, txn: {}, msg:{}", (Object)this.id, (Object)this.targetTable, (Object)this.txnExecutor.getTxnId(), (Object)e.getMessage());
            throw e;
        }
        finally {
            this.batchBuffer = new Data();
            this.updateBatchId(-1L);
        }
    }

    @Override
    public void commitTxn() throws TException, TimeoutException, InterruptedException, ExecutionException {
        if (!this.isTxnBegin()) {
            LOG.warn("No transaction to commit in channel {}, table: {}", (Object)this.id, (Object)this.targetTable);
            return;
        }
        try {
            this.flushData();
            this.txnExecutor.commitTransaction();
            LOG.info("commit txn in channel {}, table: {}, txn id: {}, last batch: {}", (Object)this.id, (Object)this.targetTable, (Object)this.txnExecutor.getTxnId(), (Object)this.lastBatchId);
        }
        catch (TException e) {
            LOG.warn("Failed to commit txn in channel {}, table: {}, txn: {}, msg:{}", (Object)this.id, (Object)this.targetTable, (Object)this.txnExecutor.getTxnId(), (Object)e.getMessage());
            throw e;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn("Error occur while waiting commit txn return in channel {}, table: {}, txn: {}, msg:{}", (Object)this.id, (Object)this.targetTable, (Object)this.txnExecutor.getTxnId(), (Object)e.getMessage());
            throw e;
        }
        finally {
            this.batchBuffer = new Data();
            this.updateBatchId(-1L);
        }
    }

    @Override
    public void initTxn(long timeoutSecond) {
        if (!this.isTxnInit()) {
            UUID uuid = UUID.randomUUID();
            TUniqueId loadId = new TUniqueId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            this.timeoutSecond = timeoutSecond;
            TTxnParams txnConf = new TTxnParams().setNeedTxn(true).setThriftRpcTimeoutMs(5000L).setTxnId(-1L).setDb(this.db.getFullName()).setTbl(this.tbl.getName()).setDbId(this.db.getId());
            this.txnExecutor = new InsertStreamTxnExecutor(new TransactionEntry(txnConf, this.db, this.tbl));
            this.txnExecutor.setTxnId(-1L);
            this.txnExecutor.setLoadId(loadId);
        }
    }

    public void clearTxn() {
        this.txnExecutor = null;
    }

    public void submit(long batchId, CanalEntry.EventType eventType, CanalEntry.RowChange rowChange) {
        for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
            List<InternalService.PDataRow> rows = this.parseRow(eventType, rowData);
            try {
                Preconditions.checkState((boolean)this.isTxnInit());
                if (batchId > this.lastBatchId) {
                    if (!this.isTxnBegin()) {
                        this.beginTxn(batchId);
                    } else {
                        SendTask task = new SendTask(this.id, this.index, this.callback, this.batchBuffer, this.txnExecutor);
                        SyncTaskPool.submit(task);
                        this.batchBuffer = new Data();
                    }
                    this.updateBatchId(batchId);
                }
            }
            catch (Exception e) {
                String errMsg = "encounter exception when submit in channel " + this.id + ", table: " + this.targetTable + ", batch: " + batchId;
                LOG.error(errMsg, (Throwable)e);
                throw new CanalException(errMsg, (Throwable)e);
            }
            this.batchBuffer.addRows(rows);
        }
    }

    public void submitEOF() {
        EOFTask task = new EOFTask(this.id, this.index, this.callback);
        SyncTaskPool.submit(task);
    }

    private List<InternalService.PDataRow> parseRow(CanalEntry.EventType eventType, CanalEntry.RowData rowData) {
        ArrayList rows = Lists.newArrayList();
        switch (eventType) {
            case DELETE: {
                rows.add(this.parseRow(CanalEntry.EventType.DELETE, rowData.getBeforeColumnsList()));
                break;
            }
            case INSERT: {
                rows.add(this.parseRow(CanalEntry.EventType.INSERT, rowData.getAfterColumnsList()));
                break;
            }
            case UPDATE: {
                rows.add(this.parseRow(CanalEntry.EventType.DELETE, rowData.getBeforeColumnsList()));
                rows.add(this.parseRow(CanalEntry.EventType.INSERT, rowData.getAfterColumnsList()));
                break;
            }
            default: {
                LOG.warn("ignore event, channel: {}, schema: {}, table: {}", (Object)this.id, (Object)this.srcDataBase, (Object)this.srcTable);
            }
        }
        return rows;
    }

    private InternalService.PDataRow parseRow(CanalEntry.EventType eventType, List<CanalEntry.Column> columns) {
        InternalService.PDataRow.Builder row = InternalService.PDataRow.newBuilder();
        for (CanalEntry.Column column : columns) {
            if (column.getIsNull()) {
                row.addColBuilder().setValue(NULL_VALUE_FOR_LOAD);
                continue;
            }
            row.addColBuilder().setValue(column.getValue());
        }
        if (eventType == CanalEntry.EventType.DELETE) {
            row.addColBuilder().setValue("1");
        } else {
            row.addColBuilder().setValue("0");
        }
        return row.build();
    }

    public void flushData() throws TException, TimeoutException, InterruptedException, ExecutionException {
        if (this.batchBuffer.isNotEmpty()) {
            TransactionEntry txnEntry = this.txnExecutor.getTxnEntry();
            txnEntry.setDataToSend(this.batchBuffer.getDatas());
            this.txnExecutor.sendData();
            this.batchBuffer = new Data();
        }
    }

    public boolean isTxnBegin() {
        return this.isTxnInit() && this.txnExecutor.getTxnId() != -1L;
    }

    public boolean isTxnInit() {
        return this.txnExecutor != null;
    }

    private void updateBatchId(long batchId) {
        this.lastBatchId = batchId;
    }

    @Override
    public String getInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.srcDataBase).append(".").append(this.srcTable);
        stringBuilder.append("->");
        stringBuilder.append(this.targetTable);
        return stringBuilder.toString();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getSrcTable() {
        return this.srcTable;
    }

    @Override
    public String getSrcDataBase() {
        return this.srcDataBase;
    }

    @Override
    public String getTargetTable() {
        return this.targetTable;
    }

    @Override
    public void setCallback(SyncChannelCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setPartitions(PartitionNames partitionNames) {
        this.partitionNames = partitionNames;
    }

    private static final class EOFTask
    extends SyncTask {
        public EOFTask(long signature, int index, SyncChannelCallback callback) {
            super(signature, index, callback);
        }

        @Override
        public void exec() throws Exception {
            this.callback.onFinished(this.signature);
        }
    }

    private static final class SendTask
    extends SyncTask {
        private final InsertStreamTxnExecutor executor;
        private final Data<InternalService.PDataRow> rows;

        public SendTask(long signature, int index, SyncChannelCallback callback, Data<InternalService.PDataRow> rows, InsertStreamTxnExecutor executor) {
            super(signature, index, callback);
            this.executor = executor;
            this.rows = rows;
        }

        @Override
        public void exec() throws Exception {
            TransactionEntry txnEntry = this.executor.getTxnEntry();
            txnEntry.setDataToSend(this.rows.getDatas());
            this.executor.sendData();
        }
    }
}

