/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync.canal;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class CanalDestination
implements Writable {
    @SerializedName(value="ip")
    private String ip;
    @SerializedName(value="port")
    private int port;
    @SerializedName(value="destination")
    private String destination;

    public void parse(Map<String, String> properties) throws DdlException {
        if (!properties.containsKey("canal.server.ip")) {
            throw new DdlException("Missing canal.server.ip property in binlog properties");
        }
        this.ip = properties.get("canal.server.ip");
        if (!properties.containsKey("canal.server.port")) {
            throw new DdlException("Missing canal.server.port property in binlog properties");
        }
        try {
            this.port = Integer.parseInt(properties.get("canal.server.port"));
        }
        catch (NumberFormatException e) {
            throw new DdlException("canal port is not int");
        }
        if (!properties.containsKey("canal.destination")) {
            throw new DdlException("Missing canal.destination property in binlog properties");
        }
        this.destination = properties.get("canal.destination");
    }

    public CanalDestination(String ip, int port, String destination) {
        this.ip = ip;
        this.port = port;
        this.destination = destination;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port, this.destination);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CanalDestination)) {
            return false;
        }
        CanalDestination otherDestination = (CanalDestination)other;
        return this.ip.equalsIgnoreCase(otherDestination.getIp()) && this.port == otherDestination.getPort() && this.destination.equalsIgnoreCase(otherDestination.getDestination());
    }

    public String toString() {
        return "CanalDestination [ip=" + this.ip + ", port=" + this.port + ", destination=" + this.destination + "]";
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static CanalDestination read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (CanalDestination)GsonUtils.GSON.fromJson(json, CanalDestination.class);
    }
}

