/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SyncLifeCycle {
    private Logger logger = LogManager.getLogger(SyncLifeCycle.class);
    protected volatile boolean running = false;
    public Thread thread;
    protected Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            SyncLifeCycle.this.logger.error("process thread has an error", e);
        }
    };

    public abstract void process();

    public boolean isStart() {
        return this.running;
    }

    public void start() {
        if (this.isStart()) {
            throw new RuntimeException(this.getClass().getName() + " has startup , don't repeat start");
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SyncLifeCycle.this.process();
            }
        });
        this.thread.setUncaughtExceptionHandler(this.handler);
        this.thread.start();
        this.running = true;
    }

    public void stop() {
        if (!this.isStart()) {
            return;
        }
        this.running = false;
        if (this.thread != null) {
            if (this.thread == Thread.currentThread()) {
                return;
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

