/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.doris.analysis.CreateDataSyncJobStmt;
import org.apache.doris.analysis.PauseSyncJobStmt;
import org.apache.doris.analysis.ResumeSyncJobStmt;
import org.apache.doris.analysis.StopSyncJobStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.load.sync.DataSyncJobType;
import org.apache.doris.load.sync.SyncFailMsg;
import org.apache.doris.load.sync.SyncJob;
import org.apache.doris.load.sync.canal.CanalDestination;
import org.apache.doris.load.sync.canal.CanalSyncJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncJobManager
implements Writable {
    private static final Logger LOG = LogManager.getLogger(SyncJobManager.class);
    private Map<Long, SyncJob> idToSyncJob = Maps.newConcurrentMap();
    private Map<Long, Map<String, List<SyncJob>>> dbIdToJobNameToSyncJobs = Maps.newConcurrentMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSyncJob(CreateDataSyncJobStmt stmt) throws DdlException {
        long jobId = Catalog.getCurrentCatalog().getNextId();
        SyncJob syncJob = SyncJob.fromStmt(jobId, stmt);
        this.writeLock();
        try {
            this.checkDuplicateRemote(syncJob);
            this.unprotectedAddSyncJob(syncJob);
            Catalog.getCurrentCatalog().getEditLog().logCreateSyncJob(syncJob);
        }
        finally {
            this.writeUnlock();
        }
        LOG.info(new LogBuilder(LogKey.SYNC_JOB, syncJob.getId()).add("name", syncJob.getJobName()).add("type", (Object)syncJob.getJobType()).add("config", syncJob.getJobConfig()).add("msg", "add sync job.").build());
    }

    private void checkDuplicateRemote(SyncJob syncJob) throws DdlException {
        if (syncJob.getJobType() == DataSyncJobType.CANAL) {
            CanalDestination remote = ((CanalSyncJob)syncJob).getRemote();
            List unCompletedJobs = this.idToSyncJob.values().stream().filter(job -> !job.isCompleted()).collect(Collectors.toList());
            for (SyncJob job2 : unCompletedJobs) {
                if (!(job2 instanceof CanalSyncJob) || !((CanalSyncJob)job2).getRemote().equals(remote)) continue;
                throw new DdlException("Remote Canal instance already exists. conflict destination: " + remote);
            }
        }
    }

    private void unprotectedAddSyncJob(SyncJob syncJob) {
        Map<String, List<SyncJob>> map;
        this.idToSyncJob.put(syncJob.getId(), syncJob);
        long dbId = syncJob.getDbId();
        if (!this.dbIdToJobNameToSyncJobs.containsKey(dbId)) {
            this.dbIdToJobNameToSyncJobs.put(syncJob.getDbId(), Maps.newConcurrentMap());
        }
        if (!(map = this.dbIdToJobNameToSyncJobs.get(dbId)).containsKey(syncJob.getJobName())) {
            map.put(syncJob.getJobName(), Lists.newArrayList());
        }
        map.get(syncJob.getJobName()).add(syncJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSyncJob(PauseSyncJobStmt stmt) throws UserException {
        String dbName = stmt.getDbFullName();
        String jobName = stmt.getJobName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        ArrayList syncJobs = Lists.newArrayList();
        this.readLock();
        try {
            List<SyncJob> matchJobs = this.getSyncJobsByDbAndJobName(db.getId(), jobName);
            if (matchJobs.isEmpty()) {
                throw new DdlException("Load job does not exist");
            }
            List runningSyncJob = matchJobs.stream().filter(SyncJob::isRunning).collect(Collectors.toList());
            if (runningSyncJob.isEmpty()) {
                throw new DdlException("There is no running job with jobName `" + stmt.getJobName() + "` to pause");
            }
            syncJobs.addAll(runningSyncJob);
        }
        finally {
            this.readUnlock();
        }
        for (SyncJob syncJob : syncJobs) {
            syncJob.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSyncJob(ResumeSyncJobStmt stmt) throws UserException {
        String dbName = stmt.getDbFullName();
        String jobName = stmt.getJobName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        ArrayList syncJobs = Lists.newArrayList();
        this.readLock();
        try {
            List<SyncJob> matchJobs = this.getSyncJobsByDbAndJobName(db.getId(), jobName);
            if (matchJobs.isEmpty()) {
                throw new DdlException("Load job does not exist");
            }
            List pausedSyncJob = matchJobs.stream().filter(SyncJob::isPaused).collect(Collectors.toList());
            if (pausedSyncJob.isEmpty()) {
                throw new DdlException("There is no paused job with jobName `" + stmt.getJobName() + "` to resume");
            }
            syncJobs.addAll(pausedSyncJob);
        }
        finally {
            this.readUnlock();
        }
        for (SyncJob syncJob : syncJobs) {
            syncJob.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSyncJob(StopSyncJobStmt stmt) throws UserException {
        String dbName = stmt.getDbFullName();
        String jobName = stmt.getJobName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        ArrayList syncJobs = Lists.newArrayList();
        this.readLock();
        try {
            List<SyncJob> matchJobs = this.getSyncJobsByDbAndJobName(db.getId(), jobName);
            if (matchJobs.isEmpty()) {
                throw new DdlException("Load job does not exist");
            }
            List uncompletedSyncJob = matchJobs.stream().filter(entity -> !entity.isCompleted()).collect(Collectors.toList());
            if (uncompletedSyncJob.isEmpty()) {
                throw new DdlException("There is no uncompleted job with jobName `" + stmt.getJobName() + "`");
            }
            syncJobs.addAll(uncompletedSyncJob);
        }
        finally {
            this.readUnlock();
        }
        for (SyncJob syncJob : syncJobs) {
            syncJob.cancel(SyncFailMsg.MsgType.USER_CANCEL, "user cancel");
        }
    }

    private List<SyncJob> getSyncJobsByDbAndJobName(long dbId, String jobName) {
        ArrayList syncJobs = Lists.newArrayList();
        Map<String, List<SyncJob>> jobNameToSyncJobs = this.dbIdToJobNameToSyncJobs.get(dbId);
        if (jobNameToSyncJobs != null && jobNameToSyncJobs.containsKey(jobName)) {
            syncJobs.addAll((Collection)jobNameToSyncJobs.get(jobName));
        }
        return syncJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Comparable>> getSyncJobsInfoByDbId(long dbId) {
        LinkedList<List<Comparable>> syncJobInfos = new LinkedList<List<Comparable>>();
        this.readLock();
        try {
            if (!this.dbIdToJobNameToSyncJobs.containsKey(dbId)) {
                LinkedList<List<Comparable>> linkedList = syncJobInfos;
                return linkedList;
            }
            Map<String, List<SyncJob>> jobNameToLoadJobs = this.dbIdToJobNameToSyncJobs.get(dbId);
            ArrayList syncJobs = Lists.newArrayList();
            syncJobs.addAll(jobNameToLoadJobs.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            for (SyncJob syncJob : syncJobs) {
                syncJobInfos.add(syncJob.getShowInfo());
            }
            LinkedList<List<Comparable>> linkedList = syncJobInfos;
            return linkedList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SyncJob> getSyncJobs(SyncJob.JobState state) {
        ArrayList result = Lists.newArrayList();
        this.readLock();
        try {
            for (SyncJob job : this.idToSyncJob.values()) {
                if (job.getJobState() != state) continue;
                result.add(job);
            }
        }
        finally {
            this.readUnlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJobNameExist(String dbName, String jobName) throws DdlException {
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        boolean result = false;
        this.readLock();
        try {
            Map<String, List<SyncJob>> jobNameToSyncJobs = this.dbIdToJobNameToSyncJobs.get(db.getId());
            if (jobNameToSyncJobs != null && jobNameToSyncJobs.containsKey(jobName)) {
                List<SyncJob> matchJobs = jobNameToSyncJobs.get(jobName);
                for (SyncJob syncJob : matchJobs) {
                    if (syncJob.isCancelled()) continue;
                    result = true;
                }
            }
        }
        finally {
            this.readUnlock();
        }
        return result;
    }

    public void updateNeedSchedule() throws UserException {
        for (SyncJob syncJob : this.idToSyncJob.values()) {
            if (syncJob.isCompleted()) continue;
            syncJob.checkAndDoUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanOldSyncJobs() {
        LOG.debug("begin to clean old sync jobs ");
        long currentTimeMs = System.currentTimeMillis();
        this.writeLock();
        try {
            Iterator<Map.Entry<Long, SyncJob>> iterator = this.idToSyncJob.entrySet().iterator();
            while (iterator.hasNext()) {
                SyncJob syncJob = iterator.next().getValue();
                if (!syncJob.isExpired(currentTimeMs) || !this.dbIdToJobNameToSyncJobs.containsKey(syncJob.getDbId())) continue;
                Map<String, List<SyncJob>> map = this.dbIdToJobNameToSyncJobs.get(syncJob.getDbId());
                List<SyncJob> list = map.get(syncJob.getJobName());
                list.remove(syncJob);
                if (list.isEmpty()) {
                    map.remove(syncJob.getJobName());
                }
                if (map.isEmpty()) {
                    this.dbIdToJobNameToSyncJobs.remove(syncJob.getDbId());
                }
                iterator.remove();
                LOG.info((Object)new LogBuilder(LogKey.SYNC_JOB, syncJob.getId()).add("finishTimeMs", syncJob.getFinishTimeMs()).add("currentTimeMs", currentTimeMs).add("jobState", (Object)syncJob.getJobState()).add("msg", "old sync job has been cleaned"));
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public SyncJob getSyncJobById(long jobId) {
        return this.idToSyncJob.get(jobId);
    }

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public void write(DataOutput out) throws IOException {
        Collection<SyncJob> syncJobs = this.idToSyncJob.values();
        out.writeInt(syncJobs.size());
        for (SyncJob syncJob : syncJobs) {
            syncJob.write(out);
        }
    }

    public void readField(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            SyncJob syncJob = SyncJob.read(in);
            this.unprotectedAddSyncJob(syncJob);
        }
    }

    public void replayAddSyncJob(SyncJob syncJob) {
        this.writeLock();
        try {
            this.unprotectedAddSyncJob(syncJob);
            LOG.info(new LogBuilder(LogKey.SYNC_JOB, syncJob.getId()).add("msg", "replay create sync job.").build());
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayUpdateSyncJobState(SyncJob.SyncJobUpdateStateInfo info) {
        this.writeLock();
        try {
            long jobId = info.getId();
            SyncJob job = this.idToSyncJob.get(jobId);
            if (job == null) {
                LOG.warn(new LogBuilder(LogKey.SYNC_JOB, jobId).add("msg", "replay update sync job state failed. Job was not found.").build());
                return;
            }
            job.replayUpdateSyncJobState(info);
        }
        finally {
            this.writeUnlock();
        }
    }
}

