/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync;

import java.util.List;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.load.sync.SyncFailMsg;
import org.apache.doris.load.sync.SyncJob;
import org.apache.doris.load.sync.SyncJobManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncChecker
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(SyncChecker.class);
    private final SyncJobManager syncJobManager;

    public SyncChecker(SyncJobManager syncJobManager) {
        super("sync checker", (long)Config.sync_checker_interval_second * 1000L);
        this.syncJobManager = syncJobManager;
    }

    @Override
    protected void runAfterCatalogReady() {
        LOG.debug("start check sync jobs.");
        try {
            this.process();
            this.cleanOldSyncJobs();
        }
        catch (Throwable e) {
            LOG.warn("Failed to process one round of SyncChecker", e);
        }
    }

    private void process() throws UserException {
        this.syncJobManager.updateNeedSchedule();
        List<SyncJob> needScheduleJobs = this.syncJobManager.getSyncJobs(SyncJob.JobState.PENDING);
        for (SyncJob job : needScheduleJobs) {
            SyncFailMsg.MsgType msgType = null;
            UserException exception = null;
            try {
                job.execute();
            }
            catch (DdlException | MetaNotFoundException e) {
                msgType = SyncFailMsg.MsgType.SCHEDULE_FAIL;
                exception = e;
                LOG.warn(e.getMessage());
            }
            catch (UserException e) {
                msgType = SyncFailMsg.MsgType.UNKNOWN;
                exception = e;
                LOG.warn(e.getMessage());
            }
            if (exception == null) continue;
            job.cancel(msgType, exception.getMessage());
        }
    }

    private void cleanOldSyncJobs() {
        this.syncJobManager.cleanOldSyncJobs();
    }
}

