/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync;

import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.Status;
import org.apache.doris.load.sync.SyncChannel;
import org.apache.doris.load.sync.SyncChannelCallback;
import org.apache.doris.thrift.TStatusCode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncChannelHandle
implements SyncChannelCallback {
    private Logger LOG = LogManager.getLogger(SyncChannelHandle.class);
    private MarkedCountDownLatch<Long, Long> latch;

    public void reset(int size) {
        this.latch = new MarkedCountDownLatch(size);
    }

    public void mark(SyncChannel channel) {
        this.latch.addMark(channel.getId(), -1L);
    }

    @Override
    public void onFinished(long channelId) {
        this.latch.markedCountDown(channelId, -1L);
    }

    @Override
    public void onFailed(String errMsg) {
        this.latch.countDownToZero(new Status(TStatusCode.CANCELLED, errMsg));
    }

    public void join() throws InterruptedException {
        this.latch.await();
    }

    public Status getStatus() {
        return this.latch.getStatus();
    }
}

