/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.sync;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.UserException;
import org.apache.doris.load.sync.SyncChannelCallback;
import org.apache.doris.load.sync.SyncJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class SyncChannel {
    private static final Logger LOG = LogManager.getLogger(SyncChannel.class);
    protected long id;
    protected long jobId;
    protected Database db;
    protected OlapTable tbl;
    protected List<String> columns;
    protected PartitionNames partitionNames;
    protected String targetTable;
    protected String srcDataBase;
    protected String srcTable;
    protected SyncChannelCallback callback;

    public SyncChannel(long id, SyncJob syncJob, Database db, OlapTable table, List<String> columns, String srcDataBase, String srcTable) {
        this.id = id;
        this.jobId = syncJob.getId();
        this.db = db;
        this.tbl = table;
        this.columns = columns;
        this.targetTable = table.getName().toLowerCase();
        this.srcDataBase = srcDataBase.toLowerCase();
        this.srcTable = srcTable.toLowerCase();
    }

    public void beginTxn(long batchId) throws UserException, TException, TimeoutException, InterruptedException, ExecutionException {
    }

    public void abortTxn(String reason) throws TException, TimeoutException, InterruptedException, ExecutionException {
    }

    public void commitTxn() throws TException, TimeoutException, InterruptedException, ExecutionException {
    }

    public void initTxn(long timeoutSecond) {
    }

    public String getInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.srcDataBase).append(".").append(this.srcTable);
        stringBuilder.append("->");
        stringBuilder.append(this.targetTable);
        return stringBuilder.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getSrcTable() {
        return this.srcTable;
    }

    public String getSrcDataBase() {
        return this.srcDataBase;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setCallback(SyncChannelCallback callback) {
        this.callback = callback;
    }

    public void setPartitions(PartitionNames partitionNames) {
        this.partitionNames = partitionNames;
    }
}

