/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.InternalErrorCode;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduleRule {
    private static final Logger LOG = LogManager.getLogger(ScheduleRule.class);

    private static int deadBeCount(String clusterName) {
        SystemInfoService systemInfoService = Catalog.getCurrentSystemInfo();
        int total = systemInfoService.getClusterBackendIds(clusterName, false).size();
        int alive = systemInfoService.getClusterBackendIds(clusterName, true).size();
        return total - alive;
    }

    public static boolean isNeedAutoSchedule(RoutineLoadJob jobRoutine) {
        if (jobRoutine.state != RoutineLoadJob.JobState.PAUSED) {
            return false;
        }
        if (jobRoutine.autoResumeLock) {
            LOG.debug("routine load job {}'s autoResumeLock is true, skip", (Object)jobRoutine.id);
            return false;
        }
        LOG.debug("try to auto reschedule routine load {}, firstResumeTimestamp: {}, autoResumeCount: {}, pause reason: {}", (Object)jobRoutine.id, (Object)jobRoutine.firstResumeTimestamp, (Object)jobRoutine.autoResumeCount, (Object)(jobRoutine.pauseReason == null ? "null" : jobRoutine.pauseReason.getCode().name()));
        if (jobRoutine.pauseReason != null && jobRoutine.pauseReason.getCode() == InternalErrorCode.REPLICA_FEW_ERR) {
            int dead = ScheduleRule.deadBeCount(jobRoutine.clusterName);
            if (dead > Config.max_tolerable_backend_down_num) {
                LOG.debug("dead backend num {} is larger than config {}, routine load job {} can not be auto rescheduled", (Object)dead, (Object)Config.max_tolerable_backend_down_num, (Object)jobRoutine.id);
                return false;
            }
            if (jobRoutine.firstResumeTimestamp == 0L) {
                jobRoutine.firstResumeTimestamp = System.currentTimeMillis();
                jobRoutine.autoResumeCount = 1L;
                return true;
            }
            long current = System.currentTimeMillis();
            if (current - jobRoutine.firstResumeTimestamp < (long)(Config.period_of_auto_resume_min * 60000)) {
                if (jobRoutine.autoResumeCount >= 3L) {
                    jobRoutine.autoResumeLock = true;
                    return false;
                }
                ++jobRoutine.autoResumeCount;
                return true;
            }
            jobRoutine.firstResumeTimestamp = current;
            jobRoutine.autoResumeCount = 1L;
            return true;
        }
        return false;
    }
}

