/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.QuotaExceedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.routineload.RoutineLoadManager;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TRoutineLoadTask;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RoutineLoadTaskInfo {
    private static final Logger LOG = LogManager.getLogger(RoutineLoadTaskInfo.class);
    private RoutineLoadManager routineLoadManager = Catalog.getCurrentCatalog().getRoutineLoadManager();
    protected UUID id;
    protected long txnId = -1L;
    protected long jobId;
    protected String clusterName;
    private long createTimeMs;
    private long executeStartTimeMs = -1L;
    protected long previousBeId = -1L;
    protected long beId = -1L;
    protected long lastScheduledTime = -1L;
    protected long timeoutMs = -1L;
    protected TransactionStatus txnStatus = TransactionStatus.UNKNOWN;

    public RoutineLoadTaskInfo(UUID id, long jobId, String clusterName, long timeoutMs) {
        this.id = id;
        this.jobId = jobId;
        this.clusterName = clusterName;
        this.createTimeMs = System.currentTimeMillis();
        this.timeoutMs = timeoutMs;
    }

    public RoutineLoadTaskInfo(UUID id, long jobId, String clusterName, long timeoutMs, long previousBeId) {
        this(id, jobId, clusterName, timeoutMs);
        this.previousBeId = previousBeId;
    }

    public UUID getId() {
        return this.id;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setExecuteStartTimeMs(long executeStartTimeMs) {
        this.executeStartTimeMs = executeStartTimeMs;
    }

    public long getPreviousBeId() {
        return this.previousBeId;
    }

    public void setBeId(long beId) {
        this.beId = beId;
    }

    public long getBeId() {
        return this.beId;
    }

    public long getTxnId() {
        return this.txnId;
    }

    public boolean isRunning() {
        return this.executeStartTimeMs > 0L;
    }

    public long getLastScheduledTime() {
        return this.lastScheduledTime;
    }

    public void setLastScheduledTime(long lastScheduledTime) {
        this.lastScheduledTime = lastScheduledTime;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTxnStatus(TransactionStatus txnStatus) {
        this.txnStatus = txnStatus;
    }

    public TransactionStatus getTxnStatus() {
        return this.txnStatus;
    }

    public boolean isTimeout() {
        if (this.txnStatus == TransactionStatus.COMMITTED || this.txnStatus == TransactionStatus.VISIBLE) {
            return false;
        }
        if (this.isRunning() && System.currentTimeMillis() - this.executeStartTimeMs > this.timeoutMs) {
            LOG.info("task {} is timeout. start: {}, timeout: {}", (Object)DebugUtil.printId(this.id), (Object)this.executeStartTimeMs, (Object)this.timeoutMs);
            return true;
        }
        return false;
    }

    abstract TRoutineLoadTask createRoutineLoadTask() throws UserException;

    public boolean beginTxn() throws UserException {
        RoutineLoadJob routineLoadJob = this.routineLoadManager.getJob(this.jobId);
        try {
            MetricRepo.COUNTER_LOAD_ADD.increase(1L);
            this.txnId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(routineLoadJob.getDbId(), Lists.newArrayList((Object[])new Long[]{routineLoadJob.getTableId()}), DebugUtil.printId(this.id), null, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), TransactionState.LoadJobSourceType.ROUTINE_LOAD_TASK, routineLoadJob.getId(), this.timeoutMs / 1000L);
        }
        catch (DuplicatedRequestException e) {
            LOG.warn("failed to begin txn for routine load task: {}, {}", (Object)DebugUtil.printId(this.id), (Object)e.getMessage());
            return false;
        }
        catch (LabelAlreadyUsedException e) {
            throw e;
        }
        catch (AnalysisException | BeginTransactionException e) {
            LOG.debug("begin txn failed for routine load task: {}, {}", (Object)DebugUtil.printId(this.id), (Object)e.getMessage());
            return false;
        }
        catch (MetaNotFoundException | QuotaExceedException e) {
            LOG.warn("failed to begin txn for routine load task: {}, job id: {}", (Object)DebugUtil.printId(this.id), (Object)this.jobId, (Object)e);
            throw e;
        }
        routineLoadJob.jobStatistic.runningTxnIds.add(this.txnId);
        return true;
    }

    public List<String> getTaskShowInfo() {
        ArrayList row = Lists.newArrayList();
        row.add(DebugUtil.printId(this.id));
        row.add(String.valueOf(this.txnId));
        row.add(this.txnStatus.name());
        row.add(String.valueOf(this.jobId));
        row.add(String.valueOf(TimeUtils.longToTimeString(this.createTimeMs)));
        row.add(String.valueOf(TimeUtils.longToTimeString(this.executeStartTimeMs)));
        row.add(String.valueOf(this.timeoutMs / 1000L));
        row.add(String.valueOf(this.beId));
        row.add(this.getTaskDataSourceProperties());
        return row;
    }

    abstract String getTaskDataSourceProperties();

    abstract boolean hasMoreDataToConsume();

    public boolean equals(Object obj) {
        if (obj instanceof RoutineLoadTaskInfo) {
            RoutineLoadTaskInfo routineLoadTaskInfo = (RoutineLoadTaskInfo)obj;
            return this.id.toString().equals(routineLoadTaskInfo.getId().toString());
        }
        return false;
    }
}

