/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class RoutineLoadStatistic
implements Writable {
    @SerializedName(value="currentErrorRows")
    public long currentErrorRows = 0L;
    @SerializedName(value="currentTotalRows")
    public long currentTotalRows = 0L;
    @SerializedName(value="errorRows")
    public long errorRows = 0L;
    @SerializedName(value="totalRows")
    public long totalRows = 0L;
    @SerializedName(value="errorRowsAfterResumed")
    public long errorRowsAfterResumed = 0L;
    @SerializedName(value="unselectedRows")
    public long unselectedRows = 0L;
    @SerializedName(value="receivedBytes")
    public long receivedBytes = 0L;
    @SerializedName(value="totalTaskExcutionTimeMs")
    public long totalTaskExcutionTimeMs = 1L;
    @SerializedName(value="committedTaskNum")
    public long committedTaskNum = 0L;
    @SerializedName(value="abortedTaskNum")
    public long abortedTaskNum = 0L;
    public Set<Long> runningTxnIds = Sets.newHashSet();

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static RoutineLoadStatistic read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (RoutineLoadStatistic)GsonUtils.GSON.fromJson(json, RoutineLoadStatistic.class);
    }

    public Map<String, Object> summary() {
        HashMap summary = Maps.newHashMap();
        summary.put("totalRows", this.totalRows);
        summary.put("loadedRows", this.totalRows - this.errorRows - this.unselectedRows);
        summary.put("errorRows", this.errorRows);
        summary.put("errorRowsAfterResumed", this.errorRowsAfterResumed);
        summary.put("unselectedRows", this.unselectedRows);
        summary.put("receivedBytes", this.receivedBytes);
        summary.put("taskExecuteTimeMs", this.totalTaskExcutionTimeMs);
        summary.put("receivedBytesRate", this.receivedBytes / this.totalTaskExcutionTimeMs * 1000L);
        summary.put("loadRowsRate", (this.totalRows - this.errorRows - this.unselectedRows) / this.totalTaskExcutionTimeMs * 1000L);
        summary.put("committedTaskNum", this.committedTaskNum);
        summary.put("abortedTaskNum", this.abortedTaskNum);
        summary.put("runningTxns", this.runningTxnIds);
        return summary;
    }
}

