/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.load.routineload.ErrorReason;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.routineload.RoutineLoadManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoutineLoadScheduler
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(RoutineLoadScheduler.class);
    private RoutineLoadManager routineLoadManager;

    @VisibleForTesting
    public RoutineLoadScheduler() {
        this.routineLoadManager = Catalog.getCurrentCatalog().getRoutineLoadManager();
    }

    public RoutineLoadScheduler(RoutineLoadManager routineLoadManager) {
        super("Routine load scheduler", FeConstants.default_scheduler_interval_millisecond);
        this.routineLoadManager = routineLoadManager;
    }

    @Override
    protected void runAfterCatalogReady() {
        try {
            this.process();
        }
        catch (Throwable e) {
            LOG.warn("Failed to process one round of RoutineLoadScheduler", e);
        }
    }

    private void process() throws UserException {
        this.routineLoadManager.updateRoutineLoadJob();
        List<RoutineLoadJob> routineLoadJobList = null;
        try {
            routineLoadJobList = this.getNeedScheduleRoutineJobs();
        }
        catch (LoadException e) {
            LOG.warn("failed to get need schedule routine jobs", (Throwable)e);
        }
        if (!routineLoadJobList.isEmpty()) {
            LOG.info("there are {} job need schedule", (Object)routineLoadJobList.size());
        }
        for (RoutineLoadJob routineLoadJob : routineLoadJobList) {
            RoutineLoadJob.JobState errorJobState = null;
            UserException userException = null;
            try {
                routineLoadJob.prepare();
                int desiredConcurrentTaskNum = routineLoadJob.calculateCurrentConcurrentTaskNum();
                if (desiredConcurrentTaskNum <= 0) {
                    LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("msg", "the current concurrent num is less than or equal to zero, job will be rescheduled later").build());
                    continue;
                }
                routineLoadJob.divideRoutineLoadJob(desiredConcurrentTaskNum);
            }
            catch (MetaNotFoundException e) {
                errorJobState = RoutineLoadJob.JobState.CANCELLED;
                userException = e;
                LOG.warn(userException.getMessage());
            }
            catch (UserException e) {
                errorJobState = RoutineLoadJob.JobState.PAUSED;
                userException = e;
                LOG.warn(userException.getMessage());
            }
            if (errorJobState == null) continue;
            LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("current_state", (Object)routineLoadJob.getState()).add("desired_state", (Object)errorJobState).add("warn_msg", "failed to scheduler job, change job state to desired_state with error reason " + userException.getMessage()).build(), (Throwable)userException);
            try {
                ErrorReason reason = new ErrorReason(userException.getErrorCode(), userException.getMessage());
                routineLoadJob.updateState(errorJobState, reason, false);
            }
            catch (UserException e) {
                LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("current_state", (Object)routineLoadJob.getState()).add("desired_state", (Object)errorJobState).add("warn_msg", "failed to change state to desired state").build(), (Throwable)e);
            }
        }
        this.routineLoadManager.processTimeoutTasks();
        this.routineLoadManager.cleanOldRoutineLoadJobs();
    }

    private List<RoutineLoadJob> getNeedScheduleRoutineJobs() throws LoadException {
        return this.routineLoadManager.getRoutineLoadJobByState(Sets.newHashSet((Object[])new RoutineLoadJob.JobState[]{RoutineLoadJob.JobState.NEED_SCHEDULE}));
    }
}

