/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.routineload.KafkaProgress;
import org.apache.doris.load.routineload.LoadDataSourceType;
import org.apache.doris.load.routineload.RLTaskTxnCommitAttachment;

public abstract class RoutineLoadProgress
implements Writable {
    protected LoadDataSourceType loadDataSourceType;
    protected boolean isTypeRead = false;

    public void setTypeRead(boolean isTypeRead) {
        this.isTypeRead = isTypeRead;
    }

    public RoutineLoadProgress(LoadDataSourceType loadDataSourceType) {
        this.loadDataSourceType = loadDataSourceType;
    }

    abstract void update(RLTaskTxnCommitAttachment var1);

    abstract String toJsonString();

    public static RoutineLoadProgress read(DataInput in) throws IOException {
        KafkaProgress progress = null;
        LoadDataSourceType type = LoadDataSourceType.valueOf(Text.readString((DataInput)in));
        if (type != LoadDataSourceType.KAFKA) {
            throw new IOException("Unknown load data source type: " + type.name());
        }
        progress = new KafkaProgress();
        progress.setTypeRead(true);
        ((RoutineLoadProgress)progress).readFields(in);
        return progress;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.loadDataSourceType.name());
    }

    public void readFields(DataInput in) throws IOException {
        if (!this.isTypeRead) {
            this.loadDataSourceType = LoadDataSourceType.valueOf(Text.readString((DataInput)in));
            this.isTypeRead = true;
        }
    }
}

