/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.doris.analysis.AlterRoutineLoadStmt;
import org.apache.doris.analysis.CreateRoutineLoadStmt;
import org.apache.doris.analysis.PauseRoutineLoadStmt;
import org.apache.doris.analysis.ResumeRoutineLoadStmt;
import org.apache.doris.analysis.StopRoutineLoadStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.InternalErrorCode;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.load.routineload.ErrorReason;
import org.apache.doris.load.routineload.KafkaRoutineLoadJob;
import org.apache.doris.load.routineload.LoadDataSourceType;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.routineload.RoutineLoadTaskInfo;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.mysql.privilege.UserProperty;
import org.apache.doris.persist.AlterRoutineLoadJobOperationLog;
import org.apache.doris.persist.RoutineLoadOperation;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;
import org.apache.doris.system.BeSelectionPolicy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoutineLoadManager
implements Writable {
    private static final Logger LOG = LogManager.getLogger(RoutineLoadManager.class);
    private Map<Long, Integer> beIdToMaxConcurrentTasks = Maps.newHashMap();
    private Map<Long, RoutineLoadJob> idToRoutineLoadJob = Maps.newConcurrentMap();
    private Map<Long, Map<String, List<RoutineLoadJob>>> dbToNameToRoutineLoadJob = Maps.newConcurrentMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public void updateBeIdToMaxConcurrentTasks() {
        this.beIdToMaxConcurrentTasks = Catalog.getCurrentSystemInfo().getBackendIds(true).stream().collect(Collectors.toMap(beId -> beId, beId -> Config.max_routine_load_task_num_per_be));
    }

    public int getTotalMaxConcurrentTaskNum() {
        return this.beIdToMaxConcurrentTasks.values().stream().mapToInt(i -> i).sum();
    }

    private Map<Long, Integer> getBeCurrentTasksNumMap() {
        HashMap beCurrentTaskNumMap = Maps.newHashMap();
        for (RoutineLoadJob routineLoadJob : this.getRoutineLoadJobByState(Sets.newHashSet((Object[])new RoutineLoadJob.JobState[]{RoutineLoadJob.JobState.RUNNING}))) {
            Map<Long, Integer> jobBeCurrentTasksNumMap = routineLoadJob.getBeCurrentTasksNumMap();
            for (Map.Entry<Long, Integer> entry : jobBeCurrentTasksNumMap.entrySet()) {
                if (beCurrentTaskNumMap.containsKey(entry.getKey())) {
                    beCurrentTaskNumMap.put(entry.getKey(), (Integer)beCurrentTaskNumMap.get(entry.getKey()) + entry.getValue());
                    continue;
                }
                beCurrentTaskNumMap.put(entry.getKey(), entry.getValue());
            }
        }
        return beCurrentTaskNumMap;
    }

    public void createRoutineLoadJob(CreateRoutineLoadStmt createRoutineLoadStmt) throws UserException {
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), createRoutineLoadStmt.getDBName(), createRoutineLoadStmt.getTableName(), PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), createRoutineLoadStmt.getDBName(), createRoutineLoadStmt.getDBName() + ": " + createRoutineLoadStmt.getTableName());
        }
        KafkaRoutineLoadJob routineLoadJob = null;
        LoadDataSourceType type = LoadDataSourceType.valueOf(createRoutineLoadStmt.getTypeName());
        switch (type) {
            case KAFKA: {
                routineLoadJob = KafkaRoutineLoadJob.fromCreateStmt(createRoutineLoadStmt);
                break;
            }
            default: {
                throw new UserException("Unknown data source type: " + (Object)((Object)type));
            }
        }
        routineLoadJob.setOrigStmt(createRoutineLoadStmt.getOrigStmt());
        this.addRoutineLoadJob(routineLoadJob, createRoutineLoadStmt.getDBName());
    }

    public void addRoutineLoadJob(RoutineLoadJob routineLoadJob, String dbName) throws DdlException {
        this.writeLock();
        try {
            if (this.isNameUsed(routineLoadJob.getDbId(), routineLoadJob.getName())) {
                throw new DdlException("Name " + routineLoadJob.getName() + " already used in db " + dbName);
            }
            if (this.getRoutineLoadJobByState(Sets.newHashSet((Object[])new RoutineLoadJob.JobState[]{RoutineLoadJob.JobState.NEED_SCHEDULE, RoutineLoadJob.JobState.RUNNING, RoutineLoadJob.JobState.PAUSED})).size() > Config.max_routine_load_job_num) {
                throw new DdlException("There are more than " + Config.max_routine_load_job_num + " routine load jobs are running. exceed limit.");
            }
            this.unprotectedAddJob(routineLoadJob);
            Catalog.getCurrentCatalog().getEditLog().logCreateRoutineLoadJob(routineLoadJob);
            LOG.info("create routine load job: id: {}, name: {}", (Object)routineLoadJob.getId(), (Object)routineLoadJob.getName());
        }
        finally {
            this.writeUnlock();
        }
    }

    private void unprotectedAddJob(RoutineLoadJob routineLoadJob) {
        List routineLoadJobList;
        this.idToRoutineLoadJob.put(routineLoadJob.getId(), routineLoadJob);
        ConcurrentMap nameToRoutineLoadJob = this.dbToNameToRoutineLoadJob.get(routineLoadJob.getDbId());
        if (nameToRoutineLoadJob == null) {
            nameToRoutineLoadJob = Maps.newConcurrentMap();
            this.dbToNameToRoutineLoadJob.put(routineLoadJob.getDbId(), nameToRoutineLoadJob);
        }
        if ((routineLoadJobList = (List)nameToRoutineLoadJob.get(routineLoadJob.getName())) == null) {
            routineLoadJobList = Lists.newArrayList();
            nameToRoutineLoadJob.put(routineLoadJob.getName(), routineLoadJobList);
        }
        routineLoadJobList.add(routineLoadJob);
        Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().addCallback(routineLoadJob);
    }

    private boolean isNameUsed(Long dbId, String name) {
        List<RoutineLoadJob> routineLoadJobList;
        Optional<RoutineLoadJob> optional;
        Map<String, List<RoutineLoadJob>> labelToRoutineLoadJob;
        return this.dbToNameToRoutineLoadJob.containsKey(dbId) && (labelToRoutineLoadJob = this.dbToNameToRoutineLoadJob.get(dbId)).containsKey(name) && (optional = (routineLoadJobList = labelToRoutineLoadJob.get(name)).parallelStream().filter(entity -> entity.getName().equals(name)).filter(entity -> !entity.getState().isFinalState()).findFirst()).isPresent();
    }

    public RoutineLoadJob checkPrivAndGetJob(String dbName, String jobName) throws MetaNotFoundException, DdlException, AnalysisException {
        String tableName;
        String dbFullName;
        RoutineLoadJob routineLoadJob = this.getJob(dbName, jobName);
        if (routineLoadJob == null) {
            throw new DdlException("There is not operable routine load job with name " + jobName);
        }
        try {
            dbFullName = routineLoadJob.getDbFullName();
            tableName = routineLoadJob.getTableName();
        }
        catch (MetaNotFoundException e) {
            throw new DdlException("The metadata of job has been changed. The job will be cancelled automatically", e);
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbFullName, tableName, PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbFullName + ": " + tableName);
        }
        return routineLoadJob;
    }

    public List<RoutineLoadJob> checkPrivAndGetAllJobs(String dbName) throws MetaNotFoundException, DdlException, AnalysisException {
        ArrayList result = Lists.newArrayList();
        Database database = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        long dbId = database.getId();
        Map<String, List<RoutineLoadJob>> jobMap = this.dbToNameToRoutineLoadJob.get(dbId);
        if (jobMap == null) {
            return result;
        }
        for (List<RoutineLoadJob> jobs : jobMap.values()) {
            for (RoutineLoadJob job : jobs) {
                if (job.getState().isFinalState()) continue;
                String tableName = job.getTableName();
                if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tableName, PrivPredicate.LOAD)) continue;
                result.add(job);
            }
        }
        return result;
    }

    public void pauseRoutineLoadJob(PauseRoutineLoadStmt pauseRoutineLoadStmt) throws UserException {
        List<Object> jobs = Lists.newArrayList();
        if (pauseRoutineLoadStmt.isAll()) {
            jobs = this.checkPrivAndGetAllJobs(pauseRoutineLoadStmt.getDbFullName());
        } else {
            RoutineLoadJob routineLoadJob = this.checkPrivAndGetJob(pauseRoutineLoadStmt.getDbFullName(), pauseRoutineLoadStmt.getName());
            jobs.add(routineLoadJob);
        }
        for (RoutineLoadJob routineLoadJob : jobs) {
            try {
                routineLoadJob.updateState(RoutineLoadJob.JobState.PAUSED, new ErrorReason(InternalErrorCode.MANUAL_PAUSE_ERR, "User " + ConnectContext.get().getQualifiedUser() + " pauses routine load job"), false);
                LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("current_state", (Object)routineLoadJob.getState()).add("user", ConnectContext.get().getQualifiedUser()).add("msg", "routine load job has been paused by user").build());
            }
            catch (UserException e) {
                LOG.warn("failed to pause routine load job {}", (Object)routineLoadJob.getName(), (Object)e);
                if (pauseRoutineLoadStmt.isAll()) continue;
                throw e;
            }
        }
    }

    public void resumeRoutineLoadJob(ResumeRoutineLoadStmt resumeRoutineLoadStmt) throws UserException {
        List<Object> jobs = Lists.newArrayList();
        if (resumeRoutineLoadStmt.isAll()) {
            jobs = this.checkPrivAndGetAllJobs(resumeRoutineLoadStmt.getDbFullName());
        } else {
            RoutineLoadJob routineLoadJob = this.checkPrivAndGetJob(resumeRoutineLoadStmt.getDbFullName(), resumeRoutineLoadStmt.getName());
            jobs.add(routineLoadJob);
        }
        for (RoutineLoadJob routineLoadJob : jobs) {
            try {
                routineLoadJob.jobStatistic.errorRowsAfterResumed = 0L;
                routineLoadJob.autoResumeCount = 0L;
                routineLoadJob.firstResumeTimestamp = 0L;
                routineLoadJob.autoResumeLock = false;
                routineLoadJob.updateState(RoutineLoadJob.JobState.NEED_SCHEDULE, null, false);
                LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("current_state", (Object)routineLoadJob.getState()).add("user", ConnectContext.get().getQualifiedUser()).add("msg", "routine load job has been resumed by user").build());
            }
            catch (UserException e) {
                LOG.warn("failed to resume routine load job {}", (Object)routineLoadJob.getName(), (Object)e);
                if (resumeRoutineLoadStmt.isAll()) continue;
                throw e;
            }
        }
    }

    public void stopRoutineLoadJob(StopRoutineLoadStmt stopRoutineLoadStmt) throws UserException {
        RoutineLoadJob routineLoadJob = this.checkPrivAndGetJob(stopRoutineLoadStmt.getDbFullName(), stopRoutineLoadStmt.getName());
        routineLoadJob.updateState(RoutineLoadJob.JobState.STOPPED, new ErrorReason(InternalErrorCode.MANUAL_STOP_ERR, "User  " + ConnectContext.get().getQualifiedUser() + " stop routine load job"), false);
        LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("current_state", (Object)routineLoadJob.getState()).add("user", ConnectContext.get().getQualifiedUser()).add("msg", "routine load job has been stopped by user").build());
    }

    public int getSizeOfIdToRoutineLoadTask() {
        int sizeOfTasks = 0;
        for (RoutineLoadJob routineLoadJob : this.idToRoutineLoadJob.values()) {
            sizeOfTasks += routineLoadJob.getSizeOfRoutineLoadTaskInfoList();
        }
        return sizeOfTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterIdleSlotNum() {
        this.readLock();
        try {
            int result = 0;
            Map<Long, Integer> beIdToConcurrentTasks = this.getBeCurrentTasksNumMap();
            for (Map.Entry<Long, Integer> entry : this.beIdToMaxConcurrentTasks.entrySet()) {
                if (beIdToConcurrentTasks.containsKey(entry.getKey())) {
                    result += entry.getValue() - beIdToConcurrentTasks.get(entry.getKey());
                    continue;
                }
                result += entry.getValue().intValue();
            }
            int n = result;
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinTaskBeId(String clusterName) throws LoadException {
        List<Long> beIdsInCluster = Catalog.getCurrentSystemInfo().getClusterBackendIds(clusterName, true);
        if (beIdsInCluster == null) {
            throw new LoadException("The " + clusterName + " has been deleted");
        }
        this.readLock();
        try {
            long result = -1L;
            int maxIdleSlotNum = 0;
            this.updateBeIdToMaxConcurrentTasks();
            Map<Long, Integer> beIdToConcurrentTasks = this.getBeCurrentTasksNumMap();
            for (Long beId : beIdsInCluster) {
                if (!this.beIdToMaxConcurrentTasks.containsKey(beId)) continue;
                int idleTaskNum = 0;
                idleTaskNum = beIdToConcurrentTasks.containsKey(beId) ? this.beIdToMaxConcurrentTasks.get(beId) - beIdToConcurrentTasks.get(beId) : Config.max_routine_load_task_num_per_be;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("be {} has idle {}, concurrent task {}, max concurrent task {}", (Object)beId, (Object)idleTaskNum, (Object)beIdToConcurrentTasks.get(beId), (Object)this.beIdToMaxConcurrentTasks.get(beId));
                }
                result = maxIdleSlotNum < idleTaskNum ? beId : result;
                maxIdleSlotNum = Math.max(maxIdleSlotNum, idleTaskNum);
            }
            long l = result;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAvailableBeForTask(long jobId, long previousBeId, String clusterName) throws LoadException {
        List<Long> availableBeIds = this.getAvailableBackendIds(jobId, clusterName);
        this.readLock();
        try {
            Backend previousBackend;
            Map<Long, Integer> beIdToConcurrentTasks = this.getBeCurrentTasksNumMap();
            if (previousBeId != -1L && availableBeIds.contains(previousBeId) && (previousBackend = Catalog.getCurrentSystemInfo().getBackend(previousBeId)) != null && previousBackend.isLoadAvailable()) {
                int idleTaskNum = 0;
                idleTaskNum = !this.beIdToMaxConcurrentTasks.containsKey(previousBeId) ? 0 : (beIdToConcurrentTasks.containsKey(previousBeId) ? this.beIdToMaxConcurrentTasks.get(previousBeId) - beIdToConcurrentTasks.get(previousBeId) : this.beIdToMaxConcurrentTasks.get(previousBeId));
                if (idleTaskNum > 0) {
                    long l = previousBeId;
                    return l;
                }
            }
            int idleTaskNum = 0;
            long resultBeId = -1L;
            int maxIdleSlotNum = 0;
            for (Long beId : availableBeIds) {
                if (!this.beIdToMaxConcurrentTasks.containsKey(beId)) continue;
                idleTaskNum = beIdToConcurrentTasks.containsKey(beId) ? this.beIdToMaxConcurrentTasks.get(beId) - beIdToConcurrentTasks.get(beId) : Config.max_routine_load_task_num_per_be;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("be {} has idle {}, concurrent task {}, max concurrent task {}", (Object)beId, (Object)idleTaskNum, (Object)beIdToConcurrentTasks.get(beId), (Object)this.beIdToMaxConcurrentTasks.get(beId));
                }
                resultBeId = maxIdleSlotNum < idleTaskNum ? beId : resultBeId;
                maxIdleSlotNum = Math.max(maxIdleSlotNum, idleTaskNum);
            }
            long l = resultBeId;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    private List<Long> getAvailableBackendIds(long jobId, String cluster) throws LoadException {
        Set<Tag> tags;
        RoutineLoadJob job = this.getJob(jobId);
        if (job == null) {
            throw new LoadException("job " + jobId + " does not exist");
        }
        if (job.getUserIdentity() == null) {
            tags = this.getTagsFromReplicaAllocation(job.getDbId(), job.getTableId());
        } else {
            tags = Catalog.getCurrentCatalog().getAuth().getResourceTags(job.getUserIdentity().getQualifiedUser());
            if (tags == UserProperty.INVALID_RESOURCE_TAGS) {
                tags = this.getTagsFromReplicaAllocation(job.getDbId(), job.getTableId());
            }
        }
        BeSelectionPolicy policy = new BeSelectionPolicy.Builder().needLoadAvailable().setCluster(cluster).addTags(tags).build();
        return Catalog.getCurrentSystemInfo().selectBackendIdsByPolicy(policy, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<Tag> getTagsFromReplicaAllocation(long dbId, long tblId) throws LoadException {
        try {
            Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbId);
            OlapTable tbl = (OlapTable)db.getTableOrMetaException(tblId, Table.TableType.OLAP);
            tbl.readLock();
            try {
                PartitionInfo partitionInfo = tbl.getPartitionInfo();
                Object object = tbl.getPartitions().iterator();
                if (object.hasNext()) {
                    Partition partition = object.next();
                    ReplicaAllocation replicaAlloc = partitionInfo.getReplicaAllocation(partition.getId());
                    Set<Tag> set = replicaAlloc.getAllocMap().keySet();
                    return set;
                }
                object = Sets.newHashSet();
                return object;
            }
            finally {
                tbl.readUnlock();
            }
        }
        catch (MetaNotFoundException e) {
            throw new LoadException(e.getMessage());
        }
    }

    public RoutineLoadJob getJob(long jobId) {
        return this.idToRoutineLoadJob.get(jobId);
    }

    public RoutineLoadJob getJob(String dbFullName, String jobName) throws MetaNotFoundException {
        List<RoutineLoadJob> routineLoadJobList = this.getJob(dbFullName, jobName, false, null);
        if (routineLoadJobList == null || routineLoadJobList.size() == 0) {
            return null;
        }
        return routineLoadJobList.get(0);
    }

    public List<RoutineLoadJob> getJob(String dbFullName, String jobName, boolean includeHistory, PatternMatcher matcher) throws MetaNotFoundException {
        ArrayList<RoutineLoadJob> result;
        Preconditions.checkArgument((jobName == null || matcher == null ? 1 : 0) != 0, (Object)"jobName and matcher cannot be not null at the same time");
        if (dbFullName == null) {
            result = new ArrayList<RoutineLoadJob>(this.idToRoutineLoadJob.values());
            this.sortRoutineLoadJob(result);
        } else {
            Database database = Catalog.getCurrentCatalog().getDbOrMetaException(dbFullName);
            long dbId = database.getId();
            if (!this.dbToNameToRoutineLoadJob.containsKey(dbId)) {
                result = new ArrayList();
            } else if (jobName == null) {
                result = Lists.newArrayList();
                for (List<RoutineLoadJob> nameToRoutineLoadJob : this.dbToNameToRoutineLoadJob.get(dbId).values()) {
                    ArrayList<RoutineLoadJob> routineLoadJobList = new ArrayList<RoutineLoadJob>(nameToRoutineLoadJob);
                    this.sortRoutineLoadJob(routineLoadJobList);
                    result.addAll(routineLoadJobList);
                }
            } else if (this.dbToNameToRoutineLoadJob.get(dbId).containsKey(jobName)) {
                result = new ArrayList<RoutineLoadJob>((Collection)this.dbToNameToRoutineLoadJob.get(dbId).get(jobName));
                this.sortRoutineLoadJob(result);
            } else {
                return null;
            }
        }
        if (!includeHistory) {
            result = result.stream().filter(entity -> !entity.getState().isFinalState()).collect(Collectors.toList());
        }
        if (matcher != null) {
            result = result.stream().filter(entity -> matcher.match(entity.getName())).collect(Collectors.toList());
        }
        return result;
    }

    public List<RoutineLoadJob> getJobByName(String jobName) {
        ArrayList result = Lists.newArrayList();
        for (Map<String, List<RoutineLoadJob>> nameToRoutineLoadJob : this.dbToNameToRoutineLoadJob.values()) {
            if (!nameToRoutineLoadJob.containsKey(jobName)) continue;
            ArrayList<RoutineLoadJob> routineLoadJobList = new ArrayList<RoutineLoadJob>((Collection)nameToRoutineLoadJob.get(jobName));
            this.sortRoutineLoadJob(routineLoadJobList);
            result.addAll(routineLoadJobList);
        }
        return result;
    }

    private void sortRoutineLoadJob(List<RoutineLoadJob> routineLoadJobList) {
        if (routineLoadJobList == null) {
            return;
        }
        int i = 0;
        int j = routineLoadJobList.size() - 1;
        while (i < j) {
            while (!routineLoadJobList.get(i).isFinal() && i < j) {
                ++i;
            }
            while (routineLoadJobList.get(j).isFinal() && i < j) {
                --j;
            }
            if (i >= j) continue;
            RoutineLoadJob routineLoadJob = routineLoadJobList.get(i);
            routineLoadJobList.set(i, routineLoadJobList.get(j));
            routineLoadJobList.set(j, routineLoadJob);
        }
    }

    public boolean checkTaskInJob(RoutineLoadTaskInfo task) {
        RoutineLoadJob routineLoadJob = this.idToRoutineLoadJob.get(task.getJobId());
        if (routineLoadJob == null) {
            return false;
        }
        return routineLoadJob.containsTask(task.getId());
    }

    public List<RoutineLoadJob> getRoutineLoadJobByState(Set<RoutineLoadJob.JobState> desiredStates) {
        List<RoutineLoadJob> stateJobs = this.idToRoutineLoadJob.values().stream().filter(entity -> desiredStates.contains((Object)entity.getState())).collect(Collectors.toList());
        return stateJobs;
    }

    public void processTimeoutTasks() {
        for (RoutineLoadJob routineLoadJob : this.idToRoutineLoadJob.values()) {
            routineLoadJob.processTimeoutTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanOldRoutineLoadJobs() {
        LOG.debug("begin to clean old routine load jobs ");
        this.writeLock();
        try {
            Iterator<Map.Entry<Long, RoutineLoadJob>> iterator = this.idToRoutineLoadJob.entrySet().iterator();
            long currentTimestamp = System.currentTimeMillis();
            while (iterator.hasNext()) {
                RoutineLoadJob routineLoadJob = iterator.next().getValue();
                if (!routineLoadJob.needRemove()) continue;
                this.unprotectedRemoveJobFromDb(routineLoadJob);
                iterator.remove();
                RoutineLoadOperation operation = new RoutineLoadOperation(routineLoadJob.getId(), routineLoadJob.getState());
                Catalog.getCurrentCatalog().getEditLog().logRemoveRoutineLoadJob(operation);
                LOG.info((Object)new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("end_timestamp", routineLoadJob.getEndTimestamp()).add("current_timestamp", currentTimestamp).add("job_state", (Object)routineLoadJob.getState()).add("msg", "old job has been cleaned"));
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void replayRemoveOldRoutineLoad(RoutineLoadOperation operation) {
        this.writeLock();
        try {
            RoutineLoadJob job = this.idToRoutineLoadJob.remove(operation.getId());
            if (job != null) {
                this.unprotectedRemoveJobFromDb(job);
            }
            LOG.info("replay remove routine load job: {}", (Object)operation.getId());
        }
        finally {
            this.writeUnlock();
        }
    }

    private void unprotectedRemoveJobFromDb(RoutineLoadJob routineLoadJob) {
        this.dbToNameToRoutineLoadJob.get(routineLoadJob.getDbId()).get(routineLoadJob.getName()).remove(routineLoadJob);
        if (this.dbToNameToRoutineLoadJob.get(routineLoadJob.getDbId()).get(routineLoadJob.getName()).isEmpty()) {
            this.dbToNameToRoutineLoadJob.get(routineLoadJob.getDbId()).remove(routineLoadJob.getName());
        }
        if (this.dbToNameToRoutineLoadJob.get(routineLoadJob.getDbId()).isEmpty()) {
            this.dbToNameToRoutineLoadJob.remove(routineLoadJob.getDbId());
        }
    }

    public void updateRoutineLoadJob() throws UserException {
        for (RoutineLoadJob routineLoadJob : this.idToRoutineLoadJob.values()) {
            if (routineLoadJob.state.isFinalState()) continue;
            routineLoadJob.update();
        }
    }

    public void replayCreateRoutineLoadJob(RoutineLoadJob routineLoadJob) {
        this.unprotectedAddJob(routineLoadJob);
        LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("msg", "replay create routine load job").build());
    }

    public void replayChangeRoutineLoadJob(RoutineLoadOperation operation) {
        RoutineLoadJob job = this.getJob(operation.getId());
        try {
            job.updateState(operation.getJobState(), null, true);
        }
        catch (UserException e) {
            LOG.error("should not happened", (Throwable)e);
        }
        LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, operation.getId()).add("current_state", (Object)operation.getJobState()).add("msg", "replay change routine load job").build());
    }

    public void alterRoutineLoadJob(AlterRoutineLoadStmt stmt) throws UserException {
        RoutineLoadJob job = this.checkPrivAndGetJob(stmt.getDbName(), stmt.getLabel());
        if (stmt.hasDataSourceProperty() && !stmt.getDataSourceProperties().getType().equalsIgnoreCase(job.dataSourceType.name())) {
            throw new DdlException("The specified job type is not: " + stmt.getDataSourceProperties().getType());
        }
        job.modifyProperties(stmt);
    }

    public void replayAlterRoutineLoadJob(AlterRoutineLoadJobOperationLog log) {
        RoutineLoadJob job = this.getJob(log.getJobId());
        Preconditions.checkNotNull((Object)job, (Object)log.getJobId());
        job.replayModifyProperties(log);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.idToRoutineLoadJob.size());
        for (RoutineLoadJob routineLoadJob : this.idToRoutineLoadJob.values()) {
            routineLoadJob.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            List jobs;
            RoutineLoadJob routineLoadJob = RoutineLoadJob.read(in);
            this.idToRoutineLoadJob.put(routineLoadJob.getId(), routineLoadJob);
            ConcurrentMap map = this.dbToNameToRoutineLoadJob.get(routineLoadJob.getDbId());
            if (map == null) {
                map = Maps.newConcurrentMap();
                this.dbToNameToRoutineLoadJob.put(routineLoadJob.getDbId(), map);
            }
            if ((jobs = (List)map.get(routineLoadJob.getName())) == null) {
                jobs = Lists.newArrayList();
                map.put(routineLoadJob.getName(), jobs);
            }
            jobs.add(routineLoadJob);
            if (routineLoadJob.getState().isFinalState()) continue;
            Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().addCallback(routineLoadJob);
        }
    }
}

