/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.analysis.AlterRoutineLoadStmt;
import org.apache.doris.analysis.CreateRoutineLoadStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ImportColumnDesc;
import org.apache.doris.analysis.ImportColumnsStmt;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Separator;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.InternalErrorCode;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.RoutineLoadDesc;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.load.routineload.ErrorReason;
import org.apache.doris.load.routineload.KafkaProgress;
import org.apache.doris.load.routineload.KafkaRoutineLoadJob;
import org.apache.doris.load.routineload.LoadDataSourceType;
import org.apache.doris.load.routineload.RLTaskTxnCommitAttachment;
import org.apache.doris.load.routineload.RoutineLoadProgress;
import org.apache.doris.load.routineload.RoutineLoadStatistic;
import org.apache.doris.load.routineload.RoutineLoadTaskInfo;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.persist.AlterRoutineLoadJobOperationLog;
import org.apache.doris.persist.RoutineLoadOperation;
import org.apache.doris.planner.StreamLoadPlanner;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.qe.SessionVariable;
import org.apache.doris.task.LoadTaskInfo;
import org.apache.doris.thrift.TExecPlanFragmentParams;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.AbstractTxnStateChangeCallback;
import org.apache.doris.transaction.TransactionException;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RoutineLoadJob
extends AbstractTxnStateChangeCallback
implements Writable,
LoadTaskInfo {
    private static final Logger LOG = LogManager.getLogger(RoutineLoadJob.class);
    public static final long DEFAULT_MAX_ERROR_NUM = 0L;
    public static final long DEFAULT_MAX_INTERVAL_SECOND = 10L;
    public static final long DEFAULT_MAX_BATCH_ROWS = 200000L;
    public static final long DEFAULT_MAX_BATCH_SIZE = 0x6400000L;
    public static final long DEFAULT_EXEC_MEM_LIMIT = 0x80000000L;
    public static final boolean DEFAULT_STRICT_MODE = false;
    public static final int DEFAULT_SEND_BATCH_PARALLELISM = 1;
    public static final boolean DEFAULT_LOAD_TO_SINGLE_TABLET = false;
    protected static final String STAR_STRING = "*";
    protected long id;
    protected String name;
    protected String clusterName;
    protected long dbId;
    protected long tableId;
    protected long authCode;
    protected PartitionNames partitions;
    protected LoadTaskInfo.ImportColumnDescs columnDescs;
    protected Expr precedingFilter;
    protected Expr whereExpr;
    protected Separator columnSeparator;
    protected Separator lineDelimiter;
    protected int desireTaskConcurrentNum;
    protected JobState state = JobState.NEED_SCHEDULE;
    protected LoadDataSourceType dataSourceType;
    protected long maxErrorNum = 0L;
    protected long execMemLimit = 0x80000000L;
    protected int sendBatchParallelism = 1;
    protected boolean loadToSingleTablet = false;
    protected Map<String, String> jobProperties = Maps.newHashMap();
    protected Map<String, String> sessionVariables = Maps.newHashMap();
    protected long maxBatchIntervalS = 10L;
    protected long maxBatchRows = 200000L;
    protected long maxBatchSizeBytes = 0x6400000L;
    protected String sequenceCol;
    private static final String PROPS_FORMAT = "format";
    private static final String PROPS_STRIP_OUTER_ARRAY = "strip_outer_array";
    private static final String PROPS_NUM_AS_STRING = "num_as_string";
    private static final String PROPS_JSONPATHS = "jsonpaths";
    private static final String PROPS_JSONROOT = "json_root";
    private static final String PROPS_FUZZY_PARSE = "fuzzy_parse";
    protected int currentTaskConcurrentNum;
    protected RoutineLoadProgress progress;
    protected long firstResumeTimestamp;
    protected long autoResumeCount;
    protected boolean autoResumeLock = false;
    protected String otherMsg = "";
    protected ErrorReason pauseReason;
    protected ErrorReason cancelReason;
    protected long createTimestamp = System.currentTimeMillis();
    protected long pauseTimestamp = -1L;
    protected long endTimestamp = -1L;
    protected RoutineLoadStatistic jobStatistic = new RoutineLoadStatistic();
    protected List<RoutineLoadTaskInfo> routineLoadTaskInfoList = Lists.newArrayList();
    protected StreamLoadPlanner planner;
    protected OriginStatement origStmt;
    protected UserIdentity userIdentity;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    protected LoadTask.MergeType mergeType = LoadTask.MergeType.APPEND;
    protected Expr deleteCondition;
    private Queue<String> errorLogUrls = EvictingQueue.create((int)3);
    protected boolean isTypeRead = false;

    public void setTypeRead(boolean isTypeRead) {
        this.isTypeRead = isTypeRead;
    }

    public RoutineLoadJob(long id, LoadDataSourceType type) {
        this.id = id;
        this.dataSourceType = type;
    }

    public RoutineLoadJob(Long id, String name, String clusterName, long dbId, long tableId, LoadDataSourceType dataSourceType, UserIdentity userIdentity) {
        this(id, dataSourceType);
        this.name = name;
        this.clusterName = clusterName;
        this.dbId = dbId;
        this.tableId = tableId;
        this.authCode = 0L;
        this.userIdentity = userIdentity;
        if (ConnectContext.get() != null) {
            SessionVariable var = ConnectContext.get().getSessionVariable();
            this.sessionVariables.put("sql_mode", Long.toString(var.getSqlMode()));
        } else {
            this.sessionVariables.put("sql_mode", String.valueOf(0L));
        }
    }

    protected void setOptional(CreateRoutineLoadStmt stmt) throws UserException {
        this.setRoutineLoadDesc(stmt.getRoutineLoadDesc());
        if (stmt.getDesiredConcurrentNum() != -1) {
            this.desireTaskConcurrentNum = stmt.getDesiredConcurrentNum();
        }
        if (stmt.getMaxErrorNum() != -1L) {
            this.maxErrorNum = stmt.getMaxErrorNum();
        }
        if (stmt.getMaxBatchIntervalS() != -1L) {
            this.maxBatchIntervalS = stmt.getMaxBatchIntervalS();
        }
        if (stmt.getMaxBatchRows() != -1L) {
            this.maxBatchRows = stmt.getMaxBatchRows();
        }
        if (stmt.getMaxBatchSize() != -1L) {
            this.maxBatchSizeBytes = stmt.getMaxBatchSize();
        }
        if (stmt.getExecMemLimit() != -1L) {
            this.execMemLimit = stmt.getExecMemLimit();
        }
        if (stmt.getSendBatchParallelism() > 0) {
            this.sendBatchParallelism = stmt.getSendBatchParallelism();
        }
        if (stmt.isLoadToSingleTablet()) {
            this.loadToSingleTablet = stmt.isLoadToSingleTablet();
        }
        this.jobProperties.put("timezone", stmt.getTimezone());
        this.jobProperties.put("strict_mode", String.valueOf(stmt.isStrictMode()));
        this.jobProperties.put("exec_mem_limit", String.valueOf(this.execMemLimit));
        this.jobProperties.put("send_batch_parallelism", String.valueOf(this.sendBatchParallelism));
        this.jobProperties.put("load_to_single_tablet", String.valueOf(this.loadToSingleTablet));
        if (Strings.isNullOrEmpty((String)stmt.getFormat()) || stmt.getFormat().equals("csv")) {
            this.jobProperties.put(PROPS_FORMAT, "csv");
            this.jobProperties.put(PROPS_STRIP_OUTER_ARRAY, "false");
            this.jobProperties.put(PROPS_NUM_AS_STRING, "false");
            this.jobProperties.put(PROPS_JSONPATHS, "");
            this.jobProperties.put(PROPS_JSONROOT, "");
            this.jobProperties.put(PROPS_FUZZY_PARSE, "false");
        } else if (stmt.getFormat().equals("json")) {
            this.jobProperties.put(PROPS_FORMAT, "json");
            if (!Strings.isNullOrEmpty((String)stmt.getJsonPaths())) {
                this.jobProperties.put(PROPS_JSONPATHS, stmt.getJsonPaths());
            } else {
                this.jobProperties.put(PROPS_JSONPATHS, "");
            }
            if (!Strings.isNullOrEmpty((String)stmt.getJsonRoot())) {
                this.jobProperties.put(PROPS_JSONROOT, stmt.getJsonRoot());
            } else {
                this.jobProperties.put(PROPS_JSONROOT, "");
            }
            if (stmt.isStripOuterArray()) {
                this.jobProperties.put(PROPS_STRIP_OUTER_ARRAY, "true");
            } else {
                this.jobProperties.put(PROPS_STRIP_OUTER_ARRAY, "false");
            }
            if (stmt.isNumAsString()) {
                this.jobProperties.put(PROPS_NUM_AS_STRING, "true");
            } else {
                this.jobProperties.put(PROPS_NUM_AS_STRING, "false");
            }
            if (stmt.isFuzzyParse()) {
                this.jobProperties.put(PROPS_FUZZY_PARSE, "true");
            } else {
                this.jobProperties.put(PROPS_FUZZY_PARSE, "false");
            }
        } else {
            throw new UserException("Invalid format type.");
        }
    }

    private void setRoutineLoadDesc(RoutineLoadDesc routineLoadDesc) {
        if (routineLoadDesc != null) {
            ImportColumnsStmt columnsStmt;
            this.columnDescs = new LoadTaskInfo.ImportColumnDescs();
            if (routineLoadDesc.getColumnsInfo() != null && ((columnsStmt = routineLoadDesc.getColumnsInfo()).getColumns() != null || columnsStmt.getColumns().size() != 0)) {
                for (ImportColumnDesc columnDesc : columnsStmt.getColumns()) {
                    this.columnDescs.descs.add(columnDesc);
                }
            }
            if (routineLoadDesc.getPrecedingFilter() != null) {
                this.precedingFilter = routineLoadDesc.getPrecedingFilter().getExpr();
            }
            if (routineLoadDesc.getWherePredicate() != null) {
                this.whereExpr = routineLoadDesc.getWherePredicate().getExpr();
            }
            if (routineLoadDesc.getColumnSeparator() != null) {
                this.columnSeparator = routineLoadDesc.getColumnSeparator();
            }
            if (routineLoadDesc.getLineDelimiter() != null) {
                this.lineDelimiter = routineLoadDesc.getLineDelimiter();
            }
            if (routineLoadDesc.getPartitionNames() != null) {
                this.partitions = routineLoadDesc.getPartitionNames();
            }
            if (routineLoadDesc.getDeleteCondition() != null) {
                this.deleteCondition = routineLoadDesc.getDeleteCondition();
            }
            this.mergeType = routineLoadDesc.getMergeType();
            if (routineLoadDesc.hasSequenceCol()) {
                this.sequenceCol = routineLoadDesc.getSequenceColName();
            }
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    protected void readLock() {
        this.lock.readLock().lock();
    }

    protected void readUnlock() {
        this.lock.readLock().unlock();
    }

    protected void writeLock() {
        this.lock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public String getName() {
        return this.name;
    }

    public long getDbId() {
        return this.dbId;
    }

    public void setOtherMsg(String otherMsg) {
        this.otherMsg = TimeUtils.getCurrentFormatTime() + ":" + Strings.nullToEmpty((String)otherMsg);
    }

    public String getDbFullName() throws MetaNotFoundException {
        return Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId).getFullName();
    }

    public long getTableId() {
        return this.tableId;
    }

    public String getTableName() throws MetaNotFoundException {
        Database database = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        return database.getTableOrMetaException(this.tableId).getName();
    }

    public JobState getState() {
        return this.state;
    }

    public long getAuthCode() {
        return this.authCode;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public PartitionNames getPartitions() {
        return this.partitions;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    @Override
    public LoadTask.MergeType getMergeType() {
        return this.mergeType;
    }

    @Override
    public Expr getDeleteCondition() {
        return this.deleteCondition;
    }

    @Override
    public TFileType getFileType() {
        return TFileType.FILE_STREAM;
    }

    @Override
    public TFileFormatType getFormatType() {
        TFileFormatType fileFormatType = TFileFormatType.FORMAT_CSV_PLAIN;
        if (this.getFormat().equals("json")) {
            fileFormatType = TFileFormatType.FORMAT_JSON;
        }
        return fileFormatType;
    }

    @Override
    public Expr getPrecedingFilter() {
        return this.precedingFilter;
    }

    @Override
    public Expr getWhereExpr() {
        return this.whereExpr;
    }

    @Override
    public Separator getColumnSeparator() {
        return this.columnSeparator;
    }

    @Override
    public Separator getLineDelimiter() {
        return this.lineDelimiter;
    }

    @Override
    public boolean isStrictMode() {
        String value = this.jobProperties.get("strict_mode");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public boolean getNegative() {
        return false;
    }

    @Override
    public long getTxnId() {
        return -1L;
    }

    @Override
    public int getTimeout() {
        return (int)this.getMaxBatchIntervalS();
    }

    @Override
    public long getMemLimit() {
        return this.execMemLimit;
    }

    @Override
    public String getTimezone() {
        String value = this.jobProperties.get("timezone");
        if (value == null) {
            return "Asia/Shanghai";
        }
        return value;
    }

    public RoutineLoadProgress getProgress() {
        return this.progress;
    }

    public long getMaxBatchIntervalS() {
        return this.maxBatchIntervalS;
    }

    public long getMaxBatchRows() {
        return this.maxBatchRows;
    }

    public long getMaxBatchSizeBytes() {
        return this.maxBatchSizeBytes;
    }

    public String getFormat() {
        String value = this.jobProperties.get(PROPS_FORMAT);
        if (value == null) {
            return "csv";
        }
        return value;
    }

    @Override
    public boolean isStripOuterArray() {
        return Boolean.valueOf(this.jobProperties.get(PROPS_STRIP_OUTER_ARRAY));
    }

    @Override
    public boolean isNumAsString() {
        return Boolean.valueOf(this.jobProperties.get(PROPS_NUM_AS_STRING));
    }

    @Override
    public boolean isFuzzyParse() {
        return Boolean.valueOf(this.jobProperties.get(PROPS_FUZZY_PARSE));
    }

    @Override
    public int getSendBatchParallelism() {
        return this.sendBatchParallelism;
    }

    @Override
    public boolean isLoadToSingleTablet() {
        return this.loadToSingleTablet;
    }

    @Override
    public boolean isReadJsonByLine() {
        return false;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public LoadTaskInfo.ImportColumnDescs getColumnExprDescs() {
        if (this.columnDescs == null) {
            return new LoadTaskInfo.ImportColumnDescs();
        }
        return this.columnDescs;
    }

    @Override
    public String getJsonPaths() {
        String value = this.jobProperties.get(PROPS_JSONPATHS);
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public String getJsonRoot() {
        String value = this.jobProperties.get(PROPS_JSONROOT);
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public String getSequenceCol() {
        return this.sequenceCol;
    }

    @Override
    public boolean hasSequenceCol() {
        return !Strings.isNullOrEmpty((String)this.sequenceCol);
    }

    public int getSizeOfRoutineLoadTaskInfoList() {
        this.readLock();
        try {
            int n = this.routineLoadTaskInfoList.size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimeoutTasks() {
        this.writeLock();
        try {
            ArrayList<RoutineLoadTaskInfo> runningTasks = new ArrayList<RoutineLoadTaskInfo>(this.routineLoadTaskInfoList);
            for (RoutineLoadTaskInfo routineLoadTaskInfo : runningTasks) {
                if (!routineLoadTaskInfo.isTimeout()) continue;
                RoutineLoadTaskInfo newTask = this.unprotectRenewTask(routineLoadTaskInfo);
                Catalog.getCurrentCatalog().getRoutineLoadTaskScheduler().addTaskInQueue(newTask);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    abstract void divideRoutineLoadJob(int var1) throws UserException;

    public int calculateCurrentConcurrentTaskNum() throws MetaNotFoundException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Integer> getBeCurrentTasksNumMap() {
        HashMap beIdConcurrentTasksNum = Maps.newHashMap();
        this.readLock();
        try {
            for (RoutineLoadTaskInfo routineLoadTaskInfo : this.routineLoadTaskInfoList) {
                if (routineLoadTaskInfo.getBeId() == -1L) continue;
                long beId = routineLoadTaskInfo.getBeId();
                beIdConcurrentTasksNum.put(beId, beIdConcurrentTasksNum.getOrDefault(beId, 0) + 1);
            }
            HashMap hashMap = beIdConcurrentTasksNum;
            return hashMap;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean containsTask(UUID taskId) {
        this.readLock();
        try {
            boolean bl = this.routineLoadTaskInfoList.stream().anyMatch(entity -> entity.getId().equals(taskId));
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    private void checkStateTransform(JobState desireState) throws UserException {
        switch (this.state) {
            case RUNNING: {
                if (desireState != JobState.NEED_SCHEDULE) break;
                throw new DdlException("Could not transform " + (Object)((Object)this.state) + " to " + (Object)((Object)desireState));
            }
            case PAUSED: {
                if (desireState != JobState.PAUSED) break;
                throw new DdlException("Could not transform " + (Object)((Object)this.state) + " to " + (Object)((Object)desireState));
            }
            case STOPPED: 
            case CANCELLED: {
                throw new DdlException("Could not transform " + (Object)((Object)this.state) + " to " + (Object)((Object)desireState));
            }
        }
    }

    protected void updateProgress(RLTaskTxnCommitAttachment attachment) throws UserException {
        this.updateNumOfData(attachment.getTotalRows(), attachment.getFilteredRows(), attachment.getUnselectedRows(), attachment.getReceivedBytes(), attachment.getTaskExecutionTimeMs(), false);
    }

    private void updateNumOfData(long numOfTotalRows, long numOfErrorRows, long unselectedRows, long receivedBytes, long taskExecutionTime, boolean isReplay) throws UserException {
        this.jobStatistic.totalRows += numOfTotalRows;
        this.jobStatistic.errorRows += numOfErrorRows;
        this.jobStatistic.unselectedRows += unselectedRows;
        this.jobStatistic.receivedBytes += receivedBytes;
        this.jobStatistic.totalTaskExcutionTimeMs += taskExecutionTime;
        if (MetricRepo.isInit && !isReplay) {
            MetricRepo.COUNTER_ROUTINE_LOAD_ROWS.increase(numOfTotalRows);
            MetricRepo.COUNTER_ROUTINE_LOAD_ERROR_ROWS.increase(numOfErrorRows);
            MetricRepo.COUNTER_ROUTINE_LOAD_RECEIVED_BYTES.increase(receivedBytes);
        }
        this.jobStatistic.currentErrorRows += numOfErrorRows;
        this.jobStatistic.currentTotalRows += numOfTotalRows;
        this.jobStatistic.errorRowsAfterResumed = this.jobStatistic.currentErrorRows;
        if (this.jobStatistic.currentTotalRows > this.maxBatchRows * 10L) {
            if (this.jobStatistic.currentErrorRows > this.maxErrorNum) {
                LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("current_total_rows", this.jobStatistic.currentTotalRows).add("current_error_rows", this.jobStatistic.currentErrorRows).add("max_error_num", this.maxErrorNum).add("msg", "current error rows is more than max error num, begin to pause job").build());
                if (!isReplay) {
                    this.updateState(JobState.PAUSED, new ErrorReason(InternalErrorCode.TOO_MANY_FAILURE_ROWS_ERR, "current error rows of job is more than max error num"), isReplay);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("current_total_rows", this.jobStatistic.currentTotalRows).add("current_error_rows", this.jobStatistic.currentErrorRows).add("max_error_num", this.maxErrorNum).add("msg", "reset current total rows and current error rows when current total rows is more than base").build());
            }
            this.jobStatistic.currentErrorRows = 0L;
            this.jobStatistic.currentTotalRows = 0L;
        } else if (this.jobStatistic.currentErrorRows > this.maxErrorNum) {
            LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("current_total_rows", this.jobStatistic.currentTotalRows).add("current_error_rows", this.jobStatistic.currentErrorRows).add("max_error_num", this.maxErrorNum).add("msg", "current error rows is more than max error rows, begin to pause job").build());
            if (!isReplay) {
                this.updateState(JobState.PAUSED, new ErrorReason(InternalErrorCode.TOO_MANY_FAILURE_ROWS_ERR, "current error rows is more than max error num"), isReplay);
            }
            this.jobStatistic.currentErrorRows = 0L;
            this.jobStatistic.currentTotalRows = 0L;
        }
    }

    protected void replayUpdateProgress(RLTaskTxnCommitAttachment attachment) {
        try {
            this.updateNumOfData(attachment.getTotalRows(), attachment.getFilteredRows(), attachment.getUnselectedRows(), attachment.getReceivedBytes(), attachment.getTaskExecutionTimeMs(), true);
        }
        catch (UserException e) {
            LOG.error("should not happen", (Throwable)e);
        }
    }

    abstract RoutineLoadTaskInfo unprotectRenewTask(RoutineLoadTaskInfo var1);

    public void prepare() throws UserException {
        this.initPlanner();
    }

    private void initPlanner() throws UserException {
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        this.planner = new StreamLoadPlanner(db, (OlapTable)db.getTableOrMetaException(this.tableId, Table.TableType.OLAP), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TExecPlanFragmentParams plan(TUniqueId loadId, long txnId) throws UserException {
        Preconditions.checkNotNull((Object)this.planner);
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        Object table = db.getTableOrMetaException(this.tableId, Table.TableType.OLAP);
        ((Table)table).readLock();
        try {
            TExecPlanFragmentParams planParams = this.planner.plan(loadId);
            TransactionState txnState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(db.getId(), txnId);
            if (txnState == null) {
                throw new MetaNotFoundException("txn does not exist: " + txnId);
            }
            txnState.addTableIndexes(this.planner.getDestTable());
            TExecPlanFragmentParams tExecPlanFragmentParams = planParams;
            return tExecPlanFragmentParams;
        }
        finally {
            ((Table)table).readUnlock();
        }
    }

    @Override
    public void beforeAborted(TransactionState txnState) throws TransactionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(new LogBuilder(LogKey.ROUTINE_LOAD_TASK, txnState.getLabel()).add("txn_state", txnState).add("msg", "task before aborted").build());
        }
        this.executeBeforeCheck(txnState, TransactionStatus.ABORTED);
    }

    @Override
    public void beforeCommitted(TransactionState txnState) throws TransactionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(new LogBuilder(LogKey.ROUTINE_LOAD_TASK, txnState.getLabel()).add("txn_state", txnState).add("msg", "task before committed").build());
        }
        this.executeBeforeCheck(txnState, TransactionStatus.COMMITTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBeforeCheck(TransactionState txnState, TransactionStatus transactionStatus) throws TransactionException {
        this.writeLock();
        boolean passCheck = false;
        try {
            Optional<RoutineLoadTaskInfo> routineLoadTaskInfoOptional = this.routineLoadTaskInfoList.stream().filter(entity -> entity.getTxnId() == txnState.getTransactionId()).findFirst();
            if (!routineLoadTaskInfoOptional.isPresent()) {
                switch (transactionStatus) {
                    case COMMITTED: {
                        throw new TransactionException("txn " + txnState.getTransactionId() + " could not be " + (Object)((Object)transactionStatus) + " while task " + txnState.getLabel() + " has been aborted.");
                    }
                }
            }
            passCheck = true;
        }
        finally {
            if (!passCheck) {
                this.writeUnlock();
                LOG.debug("unlock write lock of routine load job before check: {}", (Object)this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCommitted(TransactionState txnState, boolean txnOperated) throws UserException {
        long taskBeId = -1L;
        try {
            if (txnOperated) {
                Optional<RoutineLoadTaskInfo> routineLoadTaskInfoOptional = this.routineLoadTaskInfoList.stream().filter(entity -> entity.getTxnId() == txnState.getTransactionId()).findFirst();
                RoutineLoadTaskInfo routineLoadTaskInfo = routineLoadTaskInfoOptional.get();
                taskBeId = routineLoadTaskInfo.getBeId();
                this.executeTaskOnTxnStatusChanged(routineLoadTaskInfo, txnState, TransactionStatus.COMMITTED, null);
                ++this.jobStatistic.committedTaskNum;
                LOG.debug("routine load task committed. task id: {}, job id: {}", (Object)txnState.getLabel(), (Object)this.id);
            }
        }
        catch (Throwable e) {
            LOG.warn("after committed failed", e);
            String errmsg = "be " + taskBeId + " commit task failed " + txnState.getLabel() + " with error " + e.getMessage() + " while transaction " + txnState.getTransactionId() + " has been committed";
            this.updateState(JobState.PAUSED, new ErrorReason(InternalErrorCode.INTERNAL_ERR, errmsg), false);
        }
        finally {
            this.writeUnlock();
            LOG.debug("unlock write lock of routine load job after committed: {}", (Object)this.id);
        }
    }

    @Override
    public void replayOnCommitted(TransactionState txnState) {
        Preconditions.checkNotNull((Object)txnState.getTxnCommitAttachment(), (Object)txnState);
        this.replayUpdateProgress((RLTaskTxnCommitAttachment)txnState.getTxnCommitAttachment());
        ++this.jobStatistic.committedTaskNum;
        LOG.debug("replay on committed: {}", (Object)txnState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterVisible(TransactionState txnState, boolean txnOperated) {
        if (!txnOperated) {
            String msg = String.format("should not happen, we find that txnOperated if false when handling afterVisble. job id: %d, txn id: %d", this.id, txnState.getTransactionId());
            LOG.warn(msg);
            return;
        }
        this.writeLock();
        try {
            this.jobStatistic.runningTxnIds.remove(txnState.getTransactionId());
            if (this.state != JobState.RUNNING) {
                return;
            }
            Optional<RoutineLoadTaskInfo> routineLoadTaskInfoOptional = this.routineLoadTaskInfoList.stream().filter(entity -> entity.getTxnId() == txnState.getTransactionId()).findFirst();
            if (!routineLoadTaskInfoOptional.isPresent()) {
                LOG.info("Can not find task with transaction {} after visible, job: {}", (Object)txnState.getTransactionId(), (Object)this.id);
                return;
            }
            RoutineLoadTaskInfo routineLoadTaskInfo = routineLoadTaskInfoOptional.get();
            if (routineLoadTaskInfo.getTxnStatus() != TransactionStatus.COMMITTED) {
                String msg = String.format("should not happen, we find that task %s is not COMMITTED when handling afterVisble. job id: %d, txn id: %d, txn status: %s", DebugUtil.printId(routineLoadTaskInfo.getId()), this.id, txnState.getTransactionId(), routineLoadTaskInfo.getTxnStatus().name());
                LOG.warn(msg);
                try {
                    this.updateState(JobState.PAUSED, new ErrorReason(InternalErrorCode.IMPOSSIBLE_ERROR_ERR, msg), false);
                }
                catch (UserException e) {
                    LOG.warn("failed to pause the job {}. this should not happen", (Object)this.id, (Object)e);
                }
                return;
            }
            RoutineLoadTaskInfo newRoutineLoadTaskInfo = this.unprotectRenewTask(routineLoadTaskInfo);
            Catalog.getCurrentCatalog().getRoutineLoadTaskScheduler().addTaskInQueue(newRoutineLoadTaskInfo);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterAborted(TransactionState txnState, boolean txnOperated, String txnStatusChangeReasonString) throws UserException {
        long taskBeId = -1L;
        try {
            this.jobStatistic.runningTxnIds.remove(txnState.getTransactionId());
            if (txnOperated) {
                Optional<RoutineLoadTaskInfo> routineLoadTaskInfoOptional = this.routineLoadTaskInfoList.stream().filter(entity -> entity.getTxnId() == txnState.getTransactionId()).findFirst();
                if (!routineLoadTaskInfoOptional.isPresent()) {
                    return;
                }
                RoutineLoadTaskInfo routineLoadTaskInfo = routineLoadTaskInfoOptional.get();
                taskBeId = routineLoadTaskInfo.getBeId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(new LogBuilder(LogKey.ROUTINE_LOAD_TASK, txnState.getLabel()).add("txn_id", txnState.getTransactionId()).add("msg", "txn abort with reason " + txnStatusChangeReasonString).build());
                }
                ++this.jobStatistic.abortedTaskNum;
                TransactionState.TxnStatusChangeReason txnStatusChangeReason = null;
                if (txnStatusChangeReasonString != null && (txnStatusChangeReason = TransactionState.TxnStatusChangeReason.fromString(txnStatusChangeReasonString)) != null) {
                    switch (txnStatusChangeReason) {
                        case OFFSET_OUT_OF_RANGE: 
                        case PAUSE: {
                            String msg = "be " + taskBeId + " abort task with reason: " + txnStatusChangeReasonString;
                            this.updateState(JobState.PAUSED, new ErrorReason(InternalErrorCode.TASKS_ABORT_ERR, msg), false);
                            return;
                        }
                    }
                }
                this.executeTaskOnTxnStatusChanged(routineLoadTaskInfo, txnState, TransactionStatus.ABORTED, txnStatusChangeReason);
            }
        }
        catch (Exception e) {
            String msg = "be " + taskBeId + " abort task " + txnState.getLabel() + " failed with error " + e.getMessage();
            this.updateState(JobState.PAUSED, new ErrorReason(InternalErrorCode.TASKS_ABORT_ERR, msg), false);
            LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("task_id", txnState.getLabel()).add("error_msg", "change job state to paused when task has been aborted with error " + e.getMessage()).build(), (Throwable)e);
        }
        finally {
            this.writeUnlock();
            LOG.debug("unlock write lock of routine load job after aborted: {}", (Object)this.id);
        }
    }

    @Override
    public void replayOnAborted(TransactionState txnState) {
        if (txnState.getTxnCommitAttachment() != null) {
            this.replayUpdateProgress((RLTaskTxnCommitAttachment)txnState.getTxnCommitAttachment());
        }
        ++this.jobStatistic.abortedTaskNum;
        LOG.debug("replay on aborted: {}, has attachment: {}", (Object)txnState, (Object)(txnState.getTxnCommitAttachment() == null ? 1 : 0));
    }

    private void executeTaskOnTxnStatusChanged(RoutineLoadTaskInfo routineLoadTaskInfo, TransactionState txnState, TransactionStatus txnStatus, TransactionState.TxnStatusChangeReason txnStatusChangeReason) throws UserException {
        RLTaskTxnCommitAttachment rlTaskTxnCommitAttachment = (RLTaskTxnCommitAttachment)txnState.getTxnCommitAttachment();
        if (rlTaskTxnCommitAttachment == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(new LogBuilder(LogKey.ROUTINE_LOAD_TASK, routineLoadTaskInfo.getId()).add("job_id", routineLoadTaskInfo.getJobId()).add("txn_id", routineLoadTaskInfo.getTxnId()).add("msg", "commit task will be ignore when attachment txn of task is null, maybe task was aborted by master when timeout").build());
            }
        } else if (this.checkCommitInfo(rlTaskTxnCommitAttachment, txnState, txnStatusChangeReason)) {
            this.updateProgress(rlTaskTxnCommitAttachment);
        }
        if (rlTaskTxnCommitAttachment != null && !Strings.isNullOrEmpty((String)rlTaskTxnCommitAttachment.getErrorLogUrl())) {
            this.errorLogUrls.add(rlTaskTxnCommitAttachment.getErrorLogUrl());
        }
        routineLoadTaskInfo.setTxnStatus(txnStatus);
        if (this.state == JobState.RUNNING) {
            if (txnStatus == TransactionStatus.ABORTED) {
                RoutineLoadTaskInfo newRoutineLoadTaskInfo = this.unprotectRenewTask(routineLoadTaskInfo);
                Catalog.getCurrentCatalog().getRoutineLoadTaskScheduler().addTaskInQueue(newRoutineLoadTaskInfo);
            } else if (txnStatus == TransactionStatus.COMMITTED) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkMeta(OlapTable olapTable, RoutineLoadDesc routineLoadDesc) throws UserException {
        if (routineLoadDesc == null) {
            return;
        }
        PartitionNames partitionNames = routineLoadDesc.getPartitionNames();
        if (partitionNames == null) {
            return;
        }
        olapTable.readLock();
        try {
            for (String partName : partitionNames.getPartitionNames()) {
                if (olapTable.getPartition(partName, partitionNames.isTemp()) != null) continue;
                throw new DdlException("Partition " + partName + " does not exist");
            }
        }
        finally {
            olapTable.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(JobState jobState, ErrorReason reason, boolean isReplay) throws UserException {
        this.writeLock();
        try {
            this.unprotectUpdateState(jobState, reason, isReplay);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void unprotectUpdateState(JobState jobState, ErrorReason reason, boolean isReplay) throws UserException {
        LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("current_job_state", (Object)this.getState()).add("desire_job_state", (Object)jobState).add("msg", reason).build());
        this.checkStateTransform(jobState);
        switch (jobState) {
            case RUNNING: {
                this.executeRunning();
                break;
            }
            case PAUSED: {
                this.executePause(reason);
                break;
            }
            case NEED_SCHEDULE: {
                this.executeNeedSchedule();
                break;
            }
            case STOPPED: {
                this.executeStop();
                break;
            }
            case CANCELLED: {
                this.executeCancel(reason);
                break;
            }
        }
        if (this.state.isFinalState()) {
            Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().removeCallback(this.id);
        }
        if (!isReplay && jobState != JobState.RUNNING) {
            Catalog.getCurrentCatalog().getEditLog().logOpRoutineLoadJob(new RoutineLoadOperation(this.id, jobState));
        }
        LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("current_job_state", (Object)this.getState()).add("msg", "job state has been changed").add("is replay", String.valueOf(isReplay)).build());
    }

    private void executeRunning() {
        this.state = JobState.RUNNING;
    }

    private void executePause(ErrorReason reason) {
        this.pauseReason = reason;
        this.state = JobState.PAUSED;
        this.pauseTimestamp = System.currentTimeMillis();
        this.routineLoadTaskInfoList.clear();
    }

    private void executeNeedSchedule() {
        this.state = JobState.NEED_SCHEDULE;
        this.pauseTimestamp = -1L;
        this.routineLoadTaskInfoList.clear();
    }

    private void executeStop() {
        this.state = JobState.STOPPED;
        this.routineLoadTaskInfoList.clear();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void executeCancel(ErrorReason reason) {
        this.cancelReason = reason;
        this.state = JobState.CANCELLED;
        this.routineLoadTaskInfoList.clear();
        this.endTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws UserException {
        Database database = Catalog.getCurrentCatalog().getDbNullable(this.dbId);
        if (database == null) {
            LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("db_id", this.dbId).add("msg", "The database has been deleted. Change job state to cancelled").build());
            this.writeLock();
            try {
                if (!this.state.isFinalState()) {
                    this.unprotectUpdateState(JobState.CANCELLED, new ErrorReason(InternalErrorCode.DB_ERR, "db " + this.dbId + "not exist"), false);
                }
                return;
            }
            finally {
                this.writeUnlock();
            }
        }
        Table table = database.getTableNullable(this.tableId);
        if (table == null) {
            LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("db_id", this.dbId).add("table_id", this.tableId).add("msg", "The table has been deleted change job state to cancelled").build());
            this.writeLock();
            try {
                if (!this.state.isFinalState()) {
                    this.unprotectUpdateState(JobState.CANCELLED, new ErrorReason(InternalErrorCode.TABLE_ERR, "table does not exist"), false);
                }
                return;
            }
            finally {
                this.writeUnlock();
            }
        }
        this.preCheckNeedSchedule();
        this.writeLock();
        try {
            if (this.unprotectNeedReschedule()) {
                LOG.info(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("msg", "Job need to be rescheduled").build());
                this.unprotectUpdateProgress();
                this.executeNeedSchedule();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void preCheckNeedSchedule() throws UserException {
    }

    protected void unprotectUpdateProgress() throws UserException {
    }

    protected boolean unprotectNeedReschedule() throws UserException {
        return false;
    }

    public void setOrigStmt(OriginStatement origStmt) {
        this.origStmt = origStmt;
    }

    protected abstract boolean checkCommitInfo(RLTaskTxnCommitAttachment var1, TransactionState var2, TransactionState.TxnStatusChangeReason var3);

    protected abstract String getStatistic();

    protected abstract String getLag();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getShowInfo() {
        Optional<Database> database = Catalog.getCurrentCatalog().getDb(this.dbId);
        Optional<String> table = database.flatMap(db -> db.getTable(this.tableId));
        this.readLock();
        try {
            ArrayList row = Lists.newArrayList();
            row.add(String.valueOf(this.id));
            row.add(this.name);
            row.add(TimeUtils.longToTimeString(this.createTimestamp));
            row.add(TimeUtils.longToTimeString(this.pauseTimestamp));
            row.add(TimeUtils.longToTimeString(this.endTimestamp));
            row.add(database.map(Database::getFullName).orElse(String.valueOf(this.dbId)));
            row.add(table.map(Table::getName).orElse(String.valueOf(this.tableId)));
            row.add(this.getState().name());
            row.add(this.dataSourceType.name());
            row.add(String.valueOf(this.getSizeOfRoutineLoadTaskInfoList()));
            row.add(this.jobPropertiesToJsonString());
            row.add(this.dataSourcePropertiesJsonToString());
            row.add(this.customPropertiesJsonToString());
            row.add(this.getStatistic());
            row.add(this.getProgress().toJsonString());
            row.add(this.getLag());
            switch (this.state) {
                case PAUSED: {
                    row.add(this.pauseReason == null ? "" : this.pauseReason.toString());
                    break;
                }
                case CANCELLED: {
                    row.add(this.cancelReason == null ? "" : this.cancelReason.toString());
                    break;
                }
                default: {
                    row.add("");
                }
            }
            row.add(Joiner.on((String)", ").join(this.errorLogUrls));
            row.add(this.otherMsg);
            ArrayList arrayList = row;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<List<String>> getTasksShowInfo() {
        ArrayList rows = Lists.newArrayList();
        this.routineLoadTaskInfoList.stream().forEach(entity -> {
            try {
                entity.setTxnStatus(Catalog.getCurrentCatalog().getGlobalTransactionMgr().getDatabaseTransactionMgr(this.dbId).getTransactionState(entity.getTxnId()).getTransactionStatus());
                rows.add(entity.getTaskShowInfo());
            }
            catch (AnalysisException e) {
                LOG.warn("failed to setTxnStatus db: {}, txnId: {}, err: {}", (Object)this.dbId, (Object)entity.getTxnId(), (Object)e.getMessage());
            }
        });
        return rows;
    }

    public String getShowCreateInfo() {
        Optional<Database> database = Catalog.getCurrentCatalog().getDb(this.dbId);
        Optional<String> table = database.flatMap(db -> db.getTable(this.tableId));
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE ROUTINE LOAD ").append(this.name);
        sb.append(" ON ").append(table.map(Table::getName).orElse(String.valueOf(this.tableId))).append("\n");
        sb.append("WITH ").append(this.mergeType.name()).append("\n");
        if (this.columnSeparator != null) {
            sb.append("COLUMNS TERMINATED BY \"").append(this.columnSeparator.getOriSeparator()).append("\",\n");
        }
        if (this.columnDescs != null && !this.columnDescs.descs.isEmpty()) {
            sb.append("COLUMNS(").append(Joiner.on((String)",").join(this.columnDescs.descs)).append("),\n");
        }
        if (this.whereExpr != null) {
            sb.append("WHERE ").append(this.whereExpr.toSql()).append(",\n");
        }
        if (this.partitions != null) {
            sb.append("PARTITION(").append(Joiner.on((String)",").join(this.partitions.getPartitionNames())).append("),\n");
        }
        if (this.deleteCondition != null) {
            sb.append("DELETE ON ").append(this.deleteCondition.toSql()).append(",\n");
        }
        if (this.sequenceCol != null) {
            sb.append("ORDER BY ").append(this.sequenceCol).append(",\n");
        }
        if (this.precedingFilter != null) {
            sb.append("PRECEDING FILTER ").append(this.precedingFilter.toSql()).append(",\n");
        }
        if (sb.charAt(sb.length() - 2) == ',') {
            sb.replace(sb.length() - 2, sb.length() - 1, "");
        }
        sb.append("PROPERTIES\n(\n");
        RoutineLoadJob.appendProperties(sb, "desired_concurrent_number", this.desireTaskConcurrentNum, false);
        RoutineLoadJob.appendProperties(sb, "max_error_number", this.maxErrorNum, false);
        RoutineLoadJob.appendProperties(sb, "max_batch_interval", this.maxBatchIntervalS, false);
        RoutineLoadJob.appendProperties(sb, "max_batch_rows", this.maxBatchRows, false);
        RoutineLoadJob.appendProperties(sb, "max_batch_size", this.maxBatchSizeBytes, false);
        RoutineLoadJob.appendProperties(sb, PROPS_FORMAT, this.getFormat(), false);
        RoutineLoadJob.appendProperties(sb, PROPS_JSONPATHS, this.getJsonPaths(), false);
        RoutineLoadJob.appendProperties(sb, PROPS_STRIP_OUTER_ARRAY, this.isStripOuterArray(), false);
        RoutineLoadJob.appendProperties(sb, PROPS_NUM_AS_STRING, this.isNumAsString(), false);
        RoutineLoadJob.appendProperties(sb, PROPS_FUZZY_PARSE, this.isFuzzyParse(), false);
        RoutineLoadJob.appendProperties(sb, PROPS_JSONROOT, this.getJsonRoot(), true);
        RoutineLoadJob.appendProperties(sb, "strict_mode", this.isStrictMode(), false);
        RoutineLoadJob.appendProperties(sb, "timezone", this.getTimezone(), false);
        RoutineLoadJob.appendProperties(sb, "exec_mem_limit", this.getMemLimit(), true);
        sb.append(")\n");
        sb.append("FROM ").append((Object)this.dataSourceType).append("\n");
        sb.append("(\n");
        this.getDataSourceProperties().forEach((k, v) -> RoutineLoadJob.appendProperties(sb, k, v, false));
        this.getCustomProperties().forEach((k, v) -> RoutineLoadJob.appendProperties(sb, k, v, false));
        if (this.progress instanceof KafkaProgress) {
            List<Pair<Integer, String>> pairs = ((KafkaProgress)this.progress).getPartitionOffsetPairs(false);
            RoutineLoadJob.appendProperties(sb, "kafka_partitions", Joiner.on((String)", ").join(pairs.stream().map(p -> (Integer)p.first).toArray()), false);
            RoutineLoadJob.appendProperties(sb, "kafka_offsets", Joiner.on((String)", ").join(pairs.stream().map(p -> (String)p.second).toArray()), false);
        }
        sb.replace(sb.length() - 2, sb.length() - 1, "");
        sb.append(");");
        return sb.toString();
    }

    private static void appendProperties(StringBuilder sb, String key, Object value, boolean end) {
        if (value == null || Strings.isNullOrEmpty((String)value.toString())) {
            return;
        }
        sb.append("\"").append(key).append("\"").append(" = ").append("\"").append(value).append("\"");
        if (!end) {
            sb.append(",\n");
        } else {
            sb.append("\n");
        }
    }

    public List<String> getShowStatistic() {
        Optional<Database> database = Catalog.getCurrentCatalog().getDb(this.dbId);
        ArrayList row = Lists.newArrayList();
        row.add(this.name);
        row.add(String.valueOf(this.id));
        row.add(database.map(Database::getFullName).orElse(String.valueOf(this.dbId)));
        row.add(this.getStatistic());
        row.add(this.getTaskStatistic());
        return row;
    }

    private String getTaskStatistic() {
        HashMap result = Maps.newHashMap();
        result.put("running_task", String.valueOf(this.routineLoadTaskInfoList.stream().filter(entity -> entity.isRunning()).count()));
        result.put("waiting_task", String.valueOf(this.routineLoadTaskInfoList.stream().filter(entity -> !entity.isRunning()).count()));
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson((Object)result);
    }

    private String jobPropertiesToJsonString() {
        HashMap jobProperties = Maps.newHashMap();
        jobProperties.put("partitions", this.partitions == null ? STAR_STRING : Joiner.on((String)",").join(this.partitions.getPartitionNames()));
        jobProperties.put("columnToColumnExpr", this.columnDescs == null ? STAR_STRING : Joiner.on((String)",").join(this.columnDescs.descs));
        jobProperties.put("precedingFilter", this.precedingFilter == null ? STAR_STRING : this.precedingFilter.toSql());
        jobProperties.put("whereExpr", this.whereExpr == null ? STAR_STRING : this.whereExpr.toSql());
        if (this.getFormat().equalsIgnoreCase("json")) {
            jobProperties.put("dataFormat", "json");
        } else {
            jobProperties.put("columnSeparator", this.columnSeparator == null ? "\t" : this.columnSeparator.toString());
            jobProperties.put("lineDelimiter", this.lineDelimiter == null ? "\n" : this.lineDelimiter.toString());
        }
        jobProperties.put("maxErrorNum", String.valueOf(this.maxErrorNum));
        jobProperties.put("maxBatchIntervalS", String.valueOf(this.maxBatchIntervalS));
        jobProperties.put("maxBatchRows", String.valueOf(this.maxBatchRows));
        jobProperties.put("maxBatchSizeBytes", String.valueOf(this.maxBatchSizeBytes));
        jobProperties.put("currentTaskConcurrentNum", String.valueOf(this.currentTaskConcurrentNum));
        jobProperties.put("desireTaskConcurrentNum", String.valueOf(this.desireTaskConcurrentNum));
        jobProperties.put("execMemLimit", String.valueOf(this.execMemLimit));
        jobProperties.put("mergeType", this.mergeType.toString());
        jobProperties.put("deleteCondition", this.deleteCondition == null ? STAR_STRING : this.deleteCondition.toSql());
        jobProperties.putAll(this.jobProperties);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson((Object)jobProperties);
    }

    abstract String dataSourcePropertiesJsonToString();

    abstract String customPropertiesJsonToString();

    abstract Map<String, String> getDataSourceProperties();

    abstract Map<String, String> getCustomProperties();

    public boolean needRemove() {
        if (!this.isFinal()) {
            return false;
        }
        Preconditions.checkState((this.endTimestamp != -1L ? 1 : 0) != 0, (Object)this.endTimestamp);
        return System.currentTimeMillis() - this.endTimestamp > (long)(Config.label_keep_max_second * 1000);
    }

    public boolean isFinal() {
        return this.state.isFinalState();
    }

    public static RoutineLoadJob read(DataInput in) throws IOException {
        KafkaRoutineLoadJob job = null;
        LoadDataSourceType type = LoadDataSourceType.valueOf(Text.readString((DataInput)in));
        if (type != LoadDataSourceType.KAFKA) {
            throw new IOException("Unknown load data source type: " + type.name());
        }
        job = new KafkaRoutineLoadJob();
        job.setTypeRead(true);
        ((RoutineLoadJob)job).readFields(in);
        return job;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.dataSourceType.name());
        out.writeLong(this.id);
        Text.writeString((DataOutput)out, (String)this.name);
        Text.writeString((DataOutput)out, (String)this.clusterName);
        out.writeLong(this.dbId);
        out.writeLong(this.tableId);
        out.writeInt(this.desireTaskConcurrentNum);
        Text.writeString((DataOutput)out, (String)this.state.name());
        out.writeLong(this.maxErrorNum);
        out.writeLong(this.maxBatchIntervalS);
        out.writeLong(this.maxBatchRows);
        out.writeLong(this.maxBatchSizeBytes);
        this.progress.write(out);
        out.writeLong(this.createTimestamp);
        out.writeLong(this.pauseTimestamp);
        out.writeLong(this.endTimestamp);
        this.jobStatistic.write(out);
        this.origStmt.write(out);
        out.writeInt(this.jobProperties.size());
        for (Map.Entry<String, String> entry : this.jobProperties.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
        out.writeInt(this.sessionVariables.size());
        for (Map.Entry<String, String> entry : this.sessionVariables.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        String value;
        String key;
        int i;
        if (!this.isTypeRead) {
            this.dataSourceType = LoadDataSourceType.valueOf(Text.readString((DataInput)in));
            this.isTypeRead = true;
        }
        this.id = in.readLong();
        this.name = Text.readString((DataInput)in);
        this.clusterName = Text.readString((DataInput)in);
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.desireTaskConcurrentNum = in.readInt();
        this.state = JobState.valueOf(Text.readString((DataInput)in));
        this.maxErrorNum = in.readLong();
        this.maxBatchIntervalS = in.readLong();
        this.maxBatchRows = in.readLong();
        this.maxBatchSizeBytes = in.readLong();
        switch (this.dataSourceType) {
            case KAFKA: {
                this.progress = new KafkaProgress();
                this.progress.readFields(in);
                break;
            }
            default: {
                throw new IOException("unknown data source type: " + (Object)((Object)this.dataSourceType));
            }
        }
        this.createTimestamp = in.readLong();
        this.pauseTimestamp = in.readLong();
        this.endTimestamp = in.readLong();
        if (Catalog.getCurrentCatalogJournalVersion() < 101) {
            this.jobStatistic.currentErrorRows = in.readLong();
            this.jobStatistic.currentTotalRows = in.readLong();
            this.jobStatistic.errorRows = in.readLong();
            this.jobStatistic.totalRows = in.readLong();
            this.jobStatistic.errorRowsAfterResumed = 0L;
            this.jobStatistic.unselectedRows = in.readLong();
            this.jobStatistic.receivedBytes = in.readLong();
            this.jobStatistic.totalTaskExcutionTimeMs = in.readLong();
            this.jobStatistic.committedTaskNum = in.readLong();
            this.jobStatistic.abortedTaskNum = in.readLong();
        } else {
            this.jobStatistic = RoutineLoadStatistic.read(in);
        }
        this.origStmt = OriginStatement.read(in);
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            key = Text.readString((DataInput)in);
            value = Text.readString((DataInput)in);
            this.jobProperties.put(key, value);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            key = Text.readString((DataInput)in);
            value = Text.readString((DataInput)in);
            this.sessionVariables.put(key, value);
        }
        SqlParser parser = new SqlParser(new SqlScanner(new StringReader(this.origStmt.originStmt), Long.valueOf(this.sessionVariables.get("sql_mode"))));
        CreateRoutineLoadStmt stmt = null;
        try {
            stmt = (CreateRoutineLoadStmt)SqlParserUtils.getStmt(parser, this.origStmt.idx);
            stmt.checkLoadProperties();
            this.setRoutineLoadDesc(stmt.getRoutineLoadDesc());
        }
        catch (Exception e) {
            throw new IOException("error happens when parsing create routine load stmt: " + this.origStmt.originStmt, e);
        }
        this.userIdentity = null;
    }

    public abstract void modifyProperties(AlterRoutineLoadStmt var1) throws UserException;

    public abstract void replayModifyProperties(AlterRoutineLoadJobOperationLog var1);

    protected void modifyCommonJobProperties(Map<String, String> jobProperties) {
        if (jobProperties.containsKey("desired_concurrent_number")) {
            this.desireTaskConcurrentNum = Integer.valueOf(jobProperties.remove("desired_concurrent_number"));
        }
        if (jobProperties.containsKey("max_error_number")) {
            this.maxErrorNum = Long.valueOf(jobProperties.remove("max_error_number"));
        }
        if (jobProperties.containsKey("max_batch_interval")) {
            this.maxBatchIntervalS = Long.valueOf(jobProperties.remove("max_batch_interval"));
        }
        if (jobProperties.containsKey("max_batch_rows")) {
            this.maxBatchRows = Long.valueOf(jobProperties.remove("max_batch_rows"));
        }
        if (jobProperties.containsKey("max_batch_size")) {
            this.maxBatchSizeBytes = Long.valueOf(jobProperties.remove("max_batch_size"));
        }
    }

    public static enum JobState {
        NEED_SCHEDULE,
        RUNNING,
        PAUSED,
        STOPPED,
        CANCELLED;


        public boolean isFinalState() {
            return this == STOPPED || this == CANCELLED;
        }
    }
}

