/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.load.routineload.KafkaProgress;
import org.apache.doris.load.routineload.RoutineLoadProgress;
import org.apache.doris.thrift.TRLTaskTxnCommitAttachment;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TxnCommitAttachment;

public class RLTaskTxnCommitAttachment
extends TxnCommitAttachment {
    private long jobId;
    private TUniqueId taskId;
    private long filteredRows;
    private long loadedRows;
    private long unselectedRows;
    private long receivedBytes;
    private long taskExecutionTimeMs;
    private RoutineLoadProgress progress;
    private String errorLogUrl;

    public RLTaskTxnCommitAttachment() {
        super(TransactionState.LoadJobSourceType.ROUTINE_LOAD_TASK);
    }

    public RLTaskTxnCommitAttachment(TRLTaskTxnCommitAttachment rlTaskTxnCommitAttachment) {
        super(TransactionState.LoadJobSourceType.ROUTINE_LOAD_TASK);
        this.jobId = rlTaskTxnCommitAttachment.getJobId();
        this.taskId = rlTaskTxnCommitAttachment.getId();
        this.filteredRows = rlTaskTxnCommitAttachment.getFilteredRows();
        this.loadedRows = rlTaskTxnCommitAttachment.getLoadedRows();
        this.unselectedRows = rlTaskTxnCommitAttachment.getUnselectedRows();
        this.receivedBytes = rlTaskTxnCommitAttachment.getReceivedBytes();
        this.taskExecutionTimeMs = rlTaskTxnCommitAttachment.getLoadCostMs();
        switch (rlTaskTxnCommitAttachment.getLoadSourceType()) {
            case KAFKA: {
                this.progress = new KafkaProgress(rlTaskTxnCommitAttachment.getKafkaRLTaskProgress());
                break;
            }
        }
        if (rlTaskTxnCommitAttachment.isSetErrorLogUrl()) {
            this.errorLogUrl = rlTaskTxnCommitAttachment.getErrorLogUrl();
        }
    }

    public long getJobId() {
        return this.jobId;
    }

    public TUniqueId getTaskId() {
        return this.taskId;
    }

    public long getFilteredRows() {
        return this.filteredRows;
    }

    public long getLoadedRows() {
        return this.loadedRows;
    }

    public long getUnselectedRows() {
        return this.unselectedRows;
    }

    public long getTotalRows() {
        return this.filteredRows + this.loadedRows + this.unselectedRows;
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public long getTaskExecutionTimeMs() {
        return this.taskExecutionTimeMs;
    }

    public RoutineLoadProgress getProgress() {
        return this.progress;
    }

    public String getErrorLogUrl() {
        return this.errorLogUrl;
    }

    public String toString() {
        return "RLTaskTxnCommitAttachment [filteredRows=" + this.filteredRows + ", loadedRows=" + this.loadedRows + ", unselectedRows=" + this.unselectedRows + ", receivedBytes=" + this.receivedBytes + ", taskExecutionTimeMs=" + this.taskExecutionTimeMs + ", taskId=" + this.taskId + ", jobId=" + this.jobId + ", progress=" + this.progress.toString() + "]";
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.filteredRows);
        out.writeLong(this.loadedRows);
        out.writeLong(this.unselectedRows);
        out.writeLong(this.receivedBytes);
        out.writeLong(this.taskExecutionTimeMs);
        this.progress.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.filteredRows = in.readLong();
        this.loadedRows = in.readLong();
        this.unselectedRows = in.readLong();
        this.receivedBytes = in.readLong();
        this.taskExecutionTimeMs = in.readLong();
        this.progress = RoutineLoadProgress.read(in);
    }
}

