/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.doris.analysis.AlterRoutineLoadStmt;
import org.apache.doris.analysis.CreateRoutineLoadStmt;
import org.apache.doris.analysis.RoutineLoadDataSourceProperties;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.InternalErrorCode;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.KafkaUtil;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.SmallFileMgr;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.routineload.ErrorReason;
import org.apache.doris.load.routineload.KafkaProgress;
import org.apache.doris.load.routineload.KafkaTaskInfo;
import org.apache.doris.load.routineload.LoadDataSourceType;
import org.apache.doris.load.routineload.RLTaskTxnCommitAttachment;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.routineload.RoutineLoadTaskInfo;
import org.apache.doris.load.routineload.ScheduleRule;
import org.apache.doris.persist.AlterRoutineLoadJobOperationLog;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.parquet.Strings;

public class KafkaRoutineLoadJob
extends RoutineLoadJob {
    private static final Logger LOG = LogManager.getLogger(KafkaRoutineLoadJob.class);
    public static final String KAFKA_FILE_CATALOG = "kafka";
    public static final String PROP_GROUP_ID = "group.id";
    private String brokerList;
    private String topic;
    private List<Integer> customKafkaPartitions = Lists.newArrayList();
    private List<Integer> currentKafkaPartitions = Lists.newArrayList();
    private String kafkaDefaultOffSet = "";
    private Map<String, String> customProperties = Maps.newHashMap();
    private Map<String, String> convertedCustomProperties = Maps.newHashMap();
    private Map<Integer, Long> cachedPartitionWithLatestOffsets = Maps.newConcurrentMap();
    private List<Integer> newCurrentKafkaPartition = Lists.newArrayList();

    public KafkaRoutineLoadJob() {
        super(-1L, LoadDataSourceType.KAFKA);
    }

    public KafkaRoutineLoadJob(Long id, String name, String clusterName, long dbId, long tableId, String brokerList, String topic, UserIdentity userIdentity) {
        super(id, name, clusterName, dbId, tableId, LoadDataSourceType.KAFKA, userIdentity);
        this.brokerList = brokerList;
        this.topic = topic;
        this.progress = new KafkaProgress();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    public Map<String, String> getConvertedCustomProperties() {
        return this.convertedCustomProperties;
    }

    private boolean isOffsetForTimes() {
        long offset = TimeUtils.timeStringToLong(this.kafkaDefaultOffSet);
        return offset != -1L;
    }

    private long convertedDefaultOffsetToTimestamp() {
        TimeZone timeZone = TimeUtils.getOrSystemTimeZone(this.getTimezone());
        return TimeUtils.timeStringToLong(this.kafkaDefaultOffSet, timeZone);
    }

    private long convertedDefaultOffsetToLong() {
        if (this.kafkaDefaultOffSet.isEmpty()) {
            return -1L;
        }
        if (this.isOffsetForTimes()) {
            return this.convertedDefaultOffsetToTimestamp();
        }
        if (this.kafkaDefaultOffSet.equalsIgnoreCase("OFFSET_BEGINNING")) {
            return -2L;
        }
        if (this.kafkaDefaultOffSet.equalsIgnoreCase("OFFSET_END")) {
            return -1L;
        }
        return -1L;
    }

    @Override
    public void prepare() throws UserException {
        super.prepare();
        this.convertCustomProperties(true);
    }

    private void convertCustomProperties(boolean rebuild) throws DdlException {
        if (this.customProperties.isEmpty()) {
            return;
        }
        if (!rebuild && !this.convertedCustomProperties.isEmpty()) {
            return;
        }
        if (rebuild) {
            this.convertedCustomProperties.clear();
        }
        SmallFileMgr smallFileMgr = Catalog.getCurrentCatalog().getSmallFileMgr();
        for (Map.Entry<String, String> entry : this.customProperties.entrySet()) {
            if (entry.getValue().startsWith("FILE:")) {
                String file = entry.getValue().substring(entry.getValue().indexOf(":") + 1);
                SmallFileMgr.SmallFile smallFile = smallFileMgr.getSmallFile(this.dbId, KAFKA_FILE_CATALOG, file, true);
                this.convertedCustomProperties.put(entry.getKey(), "FILE:" + smallFile.id + ":" + smallFile.md5);
                continue;
            }
            this.convertedCustomProperties.put(entry.getKey(), entry.getValue());
        }
        if (this.convertedCustomProperties.containsKey("kafka_origin_default_offsets")) {
            this.kafkaDefaultOffSet = this.convertedCustomProperties.remove("kafka_origin_default_offsets");
        } else if (this.convertedCustomProperties.containsKey("kafka_default_offsets")) {
            this.kafkaDefaultOffSet = this.convertedCustomProperties.remove("kafka_default_offsets");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void divideRoutineLoadJob(int currentConcurrentTaskNum) throws UserException {
        ArrayList<RoutineLoadTaskInfo> result = new ArrayList<RoutineLoadTaskInfo>();
        this.writeLock();
        try {
            if (this.state == RoutineLoadJob.JobState.NEED_SCHEDULE) {
                for (int i = 0; i < currentConcurrentTaskNum; ++i) {
                    HashMap taskKafkaProgress = Maps.newHashMap();
                    for (int j = i; j < this.currentKafkaPartitions.size(); j += currentConcurrentTaskNum) {
                        int kafkaPartition = this.currentKafkaPartitions.get(j);
                        taskKafkaProgress.put(kafkaPartition, ((KafkaProgress)this.progress).getOffsetByPartition(kafkaPartition));
                    }
                    KafkaTaskInfo kafkaTaskInfo = new KafkaTaskInfo(UUID.randomUUID(), this.id, this.clusterName, this.maxBatchIntervalS * 2L * 1000L, taskKafkaProgress);
                    this.routineLoadTaskInfoList.add(kafkaTaskInfo);
                    result.add(kafkaTaskInfo);
                }
                if (result.size() != 0) {
                    this.unprotectUpdateState(RoutineLoadJob.JobState.RUNNING, null, false);
                }
            } else {
                LOG.debug("Ignore to divide routine load job while job state {}", (Object)this.state);
            }
            Catalog.getCurrentCatalog().getRoutineLoadTaskScheduler().addTasksInQueue(result);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public int calculateCurrentConcurrentTaskNum() {
        SystemInfoService systemInfoService = Catalog.getCurrentSystemInfo();
        int partitionNum = this.currentKafkaPartitions.size();
        if (this.desireTaskConcurrentNum == 0) {
            this.desireTaskConcurrentNum = Config.max_routine_load_task_concurrent_num;
        }
        LOG.debug("current concurrent task number is min(partition num: {}, desire task concurrent num: {} config: {})", (Object)partitionNum, (Object)this.desireTaskConcurrentNum, (Object)Config.max_routine_load_task_concurrent_num);
        this.currentTaskConcurrentNum = Math.min(partitionNum, Math.min(this.desireTaskConcurrentNum, Config.max_routine_load_task_concurrent_num));
        return this.currentTaskConcurrentNum;
    }

    @Override
    protected boolean checkCommitInfo(RLTaskTxnCommitAttachment rlTaskTxnCommitAttachment, TransactionState txnState, TransactionState.TxnStatusChangeReason txnStatusChangeReason) {
        if (txnState.getTransactionStatus() == TransactionStatus.COMMITTED) {
            return true;
        }
        LOG.debug("no need to update the progress of kafka routine load. txn status: {}, txnStatusChangeReason: {}, task: {}, job: {}", (Object)txnState.getTransactionStatus(), (Object)txnStatusChangeReason, (Object)DebugUtil.printId(rlTaskTxnCommitAttachment.getTaskId()), (Object)this.id);
        return false;
    }

    @Override
    protected void updateProgress(RLTaskTxnCommitAttachment attachment) throws UserException {
        super.updateProgress(attachment);
        this.progress.update(attachment);
    }

    @Override
    protected void replayUpdateProgress(RLTaskTxnCommitAttachment attachment) {
        super.replayUpdateProgress(attachment);
        this.progress.update(attachment);
    }

    @Override
    protected RoutineLoadTaskInfo unprotectRenewTask(RoutineLoadTaskInfo routineLoadTaskInfo) {
        KafkaTaskInfo oldKafkaTaskInfo = (KafkaTaskInfo)routineLoadTaskInfo;
        KafkaTaskInfo kafkaTaskInfo = new KafkaTaskInfo(oldKafkaTaskInfo, ((KafkaProgress)this.progress).getPartitionIdToOffset(oldKafkaTaskInfo.getPartitions()));
        this.routineLoadTaskInfoList.remove(routineLoadTaskInfo);
        this.routineLoadTaskInfoList.add(kafkaTaskInfo);
        return kafkaTaskInfo;
    }

    @Override
    protected void unprotectUpdateProgress() throws UserException {
        this.updateNewPartitionProgress();
    }

    @Override
    protected void preCheckNeedSchedule() throws UserException {
        if (this.state == RoutineLoadJob.JobState.RUNNING || this.state == RoutineLoadJob.JobState.NEED_SCHEDULE) {
            if (this.customKafkaPartitions != null && !this.customKafkaPartitions.isEmpty()) {
                return;
            }
            this.updateKafkaPartitions();
        }
    }

    private void updateKafkaPartitions() throws UserException {
        block2: {
            try {
                this.newCurrentKafkaPartition = this.getAllKafkaPartitions();
            }
            catch (Exception e) {
                LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("error_msg", "Job failed to fetch all current partition with error " + e.getMessage()).build(), (Throwable)e);
                if (this.state != RoutineLoadJob.JobState.NEED_SCHEDULE) break block2;
                this.unprotectUpdateState(RoutineLoadJob.JobState.PAUSED, new ErrorReason(InternalErrorCode.PARTITIONS_ERR, "Job failed to fetch all current partition with error " + e.getMessage()), false);
            }
        }
    }

    @Override
    protected boolean unprotectNeedReschedule() throws UserException {
        if (this.state == RoutineLoadJob.JobState.RUNNING || this.state == RoutineLoadJob.JobState.NEED_SCHEDULE) {
            if (this.customKafkaPartitions != null && this.customKafkaPartitions.size() != 0) {
                this.currentKafkaPartitions = this.customKafkaPartitions;
                return false;
            }
            Preconditions.checkNotNull(this.newCurrentKafkaPartition);
            if (this.currentKafkaPartitions.containsAll(this.newCurrentKafkaPartition)) {
                if (this.currentKafkaPartitions.size() > this.newCurrentKafkaPartition.size()) {
                    this.currentKafkaPartitions = this.newCurrentKafkaPartition;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("current_kafka_partitions", Joiner.on((String)",").join(this.currentKafkaPartitions)).add("msg", "current kafka partitions has been change").build());
                    }
                    return true;
                }
                for (Integer kafkaPartition : this.currentKafkaPartitions) {
                    if (((KafkaProgress)this.progress).containsPartition(kafkaPartition)) continue;
                    return true;
                }
                return false;
            }
            this.currentKafkaPartitions = this.newCurrentKafkaPartition;
            if (LOG.isDebugEnabled()) {
                LOG.debug(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("current_kafka_partitions", Joiner.on((String)",").join(this.currentKafkaPartitions)).add("msg", "current kafka partitions has been change").build());
            }
            return true;
        }
        if (this.state == RoutineLoadJob.JobState.PAUSED) {
            return ScheduleRule.isNeedAutoSchedule(this);
        }
        return false;
    }

    @Override
    protected String getStatistic() {
        Map<String, Object> summary = this.jobStatistic.summary();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson(summary);
    }

    private List<Integer> getAllKafkaPartitions() throws UserException {
        this.convertCustomProperties(false);
        return KafkaUtil.getAllKafkaPartitions(this.brokerList, this.topic, this.convertedCustomProperties);
    }

    public static KafkaRoutineLoadJob fromCreateStmt(CreateRoutineLoadStmt stmt) throws UserException {
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(stmt.getDBName());
        OlapTable olapTable = db.getOlapTableOrDdlException(stmt.getTableName());
        KafkaRoutineLoadJob.checkMeta(olapTable, stmt.getRoutineLoadDesc());
        long tableId = olapTable.getId();
        long id = Catalog.getCurrentCatalog().getNextId();
        KafkaRoutineLoadJob kafkaRoutineLoadJob = new KafkaRoutineLoadJob(id, stmt.getName(), db.getClusterName(), db.getId(), tableId, stmt.getKafkaBrokerList(), stmt.getKafkaTopic(), stmt.getUserInfo());
        kafkaRoutineLoadJob.setOptional(stmt);
        kafkaRoutineLoadJob.checkCustomProperties();
        kafkaRoutineLoadJob.checkCustomPartition();
        return kafkaRoutineLoadJob;
    }

    private void checkCustomPartition() throws UserException {
        if (this.customKafkaPartitions.isEmpty()) {
            return;
        }
        List<Integer> allKafkaPartitions = this.getAllKafkaPartitions();
        for (Integer customPartition : this.customKafkaPartitions) {
            if (allKafkaPartitions.contains(customPartition)) continue;
            throw new LoadException("there is a custom kafka partition " + customPartition + " which is invalid for topic " + this.topic);
        }
    }

    private void checkCustomProperties() throws DdlException {
        SmallFileMgr smallFileMgr = Catalog.getCurrentCatalog().getSmallFileMgr();
        for (Map.Entry<String, String> entry : this.customProperties.entrySet()) {
            String file;
            if (!entry.getValue().startsWith("FILE:") || smallFileMgr.containsFile(this.dbId, KAFKA_FILE_CATALOG, file = entry.getValue().substring(entry.getValue().indexOf(":") + 1))) continue;
            throw new DdlException("File " + file + " does not exist in db " + this.dbId + " with catalog: " + KAFKA_FILE_CATALOG);
        }
    }

    private void updateNewPartitionProgress() throws UserException {
        try {
            for (Integer kafkaPartition : this.currentKafkaPartitions) {
                if (((KafkaProgress)this.progress).containsPartition(kafkaPartition)) continue;
                ArrayList newPartitions = Lists.newArrayList();
                newPartitions.add(kafkaPartition);
                List<Pair<Integer, Long>> newPartitionsOffsets = this.getNewPartitionOffsetsFromDefaultOffset(newPartitions);
                Preconditions.checkState((newPartitionsOffsets.size() == 1 ? 1 : 0) != 0);
                for (Pair<Integer, Long> partitionOffset : newPartitionsOffsets) {
                    ((KafkaProgress)this.progress).addPartitionOffset(partitionOffset);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("kafka_partition_id", partitionOffset.first).add("begin_offset", partitionOffset.second).add("msg", "The new partition has been added in job"));
                }
            }
        }
        catch (UserException e) {
            this.unprotectUpdateState(RoutineLoadJob.JobState.PAUSED, new ErrorReason(InternalErrorCode.PARTITIONS_ERR, e.getMessage()), false);
            throw e;
        }
    }

    private List<Pair<Integer, Long>> getNewPartitionOffsetsFromDefaultOffset(List<Integer> newPartitions) throws UserException {
        List<Object> partitionOffsets = Lists.newArrayList();
        long beginOffset = this.convertedDefaultOffsetToLong();
        for (Integer kafkaPartition : newPartitions) {
            partitionOffsets.add(Pair.create(kafkaPartition, beginOffset));
        }
        if (this.isOffsetForTimes()) {
            try {
                partitionOffsets = KafkaUtil.getOffsetsForTimes(this.brokerList, this.topic, this.convertedCustomProperties, partitionOffsets);
            }
            catch (LoadException e) {
                LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, this.id).add("partition:timestamp", Joiner.on((String)",").join((Iterable)partitionOffsets)).add("error_msg", "Job failed to fetch current offsets from times with error " + e.getMessage()).build(), (Throwable)e);
                throw new UserException(e);
            }
        }
        return partitionOffsets;
    }

    @Override
    protected void setOptional(CreateRoutineLoadStmt stmt) throws UserException {
        super.setOptional(stmt);
        if (!stmt.getKafkaPartitionOffsets().isEmpty()) {
            this.setCustomKafkaPartitions(stmt);
        }
        if (!stmt.getCustomKafkaProperties().isEmpty()) {
            this.setCustomKafkaProperties(stmt.getCustomKafkaProperties());
        }
        if (!this.customProperties.containsKey(PROP_GROUP_ID)) {
            this.customProperties.put(PROP_GROUP_ID, this.name + "_" + UUID.randomUUID().toString());
        }
    }

    private void setCustomKafkaPartitions(CreateRoutineLoadStmt stmt) throws LoadException {
        List<Pair<Integer, Long>> kafkaPartitionOffsets = stmt.getKafkaPartitionOffsets();
        boolean isForTimes = stmt.isOffsetsForTimes();
        if (isForTimes) {
            kafkaPartitionOffsets = KafkaUtil.getOffsetsForTimes(stmt.getKafkaBrokerList(), stmt.getKafkaTopic(), this.convertedCustomProperties, stmt.getKafkaPartitionOffsets());
        }
        for (Pair<Integer, Long> partitionOffset : kafkaPartitionOffsets) {
            this.customKafkaPartitions.add((Integer)partitionOffset.first);
            ((KafkaProgress)this.progress).addPartitionOffset(partitionOffset);
        }
    }

    private void setCustomKafkaProperties(Map<String, String> kafkaProperties) {
        this.customProperties = kafkaProperties;
    }

    @Override
    protected String dataSourcePropertiesJsonToString() {
        HashMap dataSourceProperties = Maps.newHashMap();
        dataSourceProperties.put("brokerList", this.brokerList);
        dataSourceProperties.put("topic", this.topic);
        ArrayList sortedPartitions = Lists.newArrayList(this.currentKafkaPartitions);
        Collections.sort(sortedPartitions);
        dataSourceProperties.put("currentKafkaPartitions", Joiner.on((String)",").join((Iterable)sortedPartitions));
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson((Object)dataSourceProperties);
    }

    @Override
    protected String customPropertiesJsonToString() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson(this.customProperties);
    }

    @Override
    protected Map<String, String> getDataSourceProperties() {
        HashMap dataSourceProperties = Maps.newHashMap();
        dataSourceProperties.put("kafka_broker_list", this.brokerList);
        dataSourceProperties.put("kafka_topic", this.topic);
        return dataSourceProperties;
    }

    @Override
    protected Map<String, String> getCustomProperties() {
        HashMap<String, String> ret = new HashMap<String, String>();
        this.customProperties.forEach((k, v) -> ret.put("property." + k, (String)v));
        return ret;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.brokerList);
        Text.writeString((DataOutput)out, (String)this.topic);
        out.writeInt(this.customKafkaPartitions.size());
        for (Integer n : this.customKafkaPartitions) {
            out.writeInt(n);
        }
        out.writeInt(this.customProperties.size());
        for (Map.Entry entry : this.customProperties.entrySet()) {
            Text.writeString((DataOutput)out, (String)("property." + (String)entry.getKey()));
            Text.writeString((DataOutput)out, (String)((String)entry.getValue()));
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.brokerList = Text.readString((DataInput)in);
        this.topic = Text.readString((DataInput)in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.customKafkaPartitions.add(in.readInt());
        }
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String propertyKey = Text.readString((DataInput)in);
            String propertyValue = Text.readString((DataInput)in);
            if (!propertyKey.startsWith("property.")) continue;
            this.customProperties.put(propertyKey.substring(propertyKey.indexOf(".") + 1), propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyProperties(AlterRoutineLoadStmt stmt) throws UserException {
        Map<String, String> jobProperties = stmt.getAnalyzedJobProperties();
        RoutineLoadDataSourceProperties dataSourceProperties = stmt.getDataSourceProperties();
        if (dataSourceProperties.isOffsetsForTimes()) {
            this.convertTimestampToOffset(dataSourceProperties);
        }
        this.writeLock();
        try {
            if (this.getState() != RoutineLoadJob.JobState.PAUSED) {
                throw new DdlException("Only supports modification of PAUSED jobs");
            }
            this.modifyPropertiesInternal(jobProperties, dataSourceProperties);
            AlterRoutineLoadJobOperationLog log = new AlterRoutineLoadJobOperationLog(this.id, jobProperties, dataSourceProperties);
            Catalog.getCurrentCatalog().getEditLog().logAlterRoutineLoadJob(log);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void convertTimestampToOffset(RoutineLoadDataSourceProperties dataSourceProperties) throws UserException {
        List<Pair<Integer, Long>> partitionOffsets = dataSourceProperties.getKafkaPartitionOffsets();
        if (partitionOffsets.isEmpty()) {
            return;
        }
        List<Pair<Integer, Long>> newOffsets = KafkaUtil.getOffsetsForTimes(this.brokerList, this.topic, this.convertedCustomProperties, partitionOffsets);
        dataSourceProperties.setKafkaPartitionOffsets(newOffsets);
    }

    private void modifyPropertiesInternal(Map<String, String> jobProperties, RoutineLoadDataSourceProperties dataSourceProperties) throws DdlException {
        List<Object> kafkaPartitionOffsets = Lists.newArrayList();
        Map<Object, Object> customKafkaProperties = Maps.newHashMap();
        if (dataSourceProperties.hasAnalyzedProperties()) {
            kafkaPartitionOffsets = dataSourceProperties.getKafkaPartitionOffsets();
            customKafkaProperties = dataSourceProperties.getCustomKafkaProperties();
        }
        if (!kafkaPartitionOffsets.isEmpty()) {
            ((KafkaProgress)this.progress).modifyOffset(kafkaPartitionOffsets);
        }
        if (!customKafkaProperties.isEmpty()) {
            this.customProperties.putAll(customKafkaProperties);
            this.convertCustomProperties(true);
        }
        if (!jobProperties.isEmpty()) {
            HashMap copiedJobProperties = Maps.newHashMap(jobProperties);
            this.modifyCommonJobProperties(copiedJobProperties);
            this.jobProperties.putAll(copiedJobProperties);
        }
        if (!Strings.isNullOrEmpty((String)dataSourceProperties.getKafkaBrokerList())) {
            this.brokerList = dataSourceProperties.getKafkaBrokerList();
        }
        if (!Strings.isNullOrEmpty((String)dataSourceProperties.getKafkaTopic())) {
            this.topic = dataSourceProperties.getKafkaTopic();
        }
        LOG.info("modify the properties of kafka routine load job: {}, jobProperties: {}, datasource properties: {}", (Object)this.id, jobProperties, (Object)dataSourceProperties);
    }

    @Override
    public void replayModifyProperties(AlterRoutineLoadJobOperationLog log) {
        try {
            this.modifyPropertiesInternal(log.getJobProperties(), log.getDataSourceProperties());
        }
        catch (DdlException e) {
            LOG.error("failed to replay modify kafka routine load job: {}", (Object)this.id, (Object)e);
        }
    }

    public boolean hasMoreDataToConsume(UUID taskId, Map<Integer, Long> partitionIdToOffset) {
        for (Map.Entry<Integer, Long> entry : partitionIdToOffset.entrySet()) {
            if (!this.cachedPartitionWithLatestOffsets.containsKey(entry.getKey()) || entry.getValue() >= this.cachedPartitionWithLatestOffsets.get(entry.getKey())) continue;
            LOG.debug("has more data to consume. offsets to be consumed: {}, latest offsets: {}, task {}, job {}", partitionIdToOffset, this.cachedPartitionWithLatestOffsets, (Object)taskId, (Object)this.id);
            return true;
        }
        try {
            List<Pair<Integer, Long>> tmp = KafkaUtil.getLatestOffsets(this.id, taskId, this.getBrokerList(), this.getTopic(), this.getConvertedCustomProperties(), Lists.newArrayList(partitionIdToOffset.keySet()));
            for (Pair pair : tmp) {
                this.cachedPartitionWithLatestOffsets.put((Integer)pair.first, (Long)pair.second);
            }
        }
        catch (Exception e) {
            LOG.warn("failed to get latest partition offset. {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        for (Map.Entry<Integer, Long> entry : partitionIdToOffset.entrySet()) {
            if (!this.cachedPartitionWithLatestOffsets.containsKey(entry.getKey()) || entry.getValue() >= this.cachedPartitionWithLatestOffsets.get(entry.getKey())) continue;
            LOG.debug("has more data to consume. offsets to be consumed: {}, latest offsets: {}, task {}, job {}", partitionIdToOffset, this.cachedPartitionWithLatestOffsets, (Object)taskId, (Object)this.id);
            return true;
        }
        LOG.debug("no more data to consume. offsets to be consumed: {}, latest offsets: {}, task {}, job {}", partitionIdToOffset, this.cachedPartitionWithLatestOffsets, (Object)taskId, (Object)this.id);
        return false;
    }

    @Override
    protected String getLag() {
        Map<Integer, Long> partitionIdToOffsetLag = ((KafkaProgress)this.progress).getLag(this.cachedPartitionWithLatestOffsets);
        Gson gson = new Gson();
        return gson.toJson(partitionIdToOffsetLag);
    }

    @Override
    public double getMaxFilterRatio() {
        return 1.0;
    }
}

