/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.routineload;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.load.routineload.LoadDataSourceType;
import org.apache.doris.load.routineload.RLTaskTxnCommitAttachment;
import org.apache.doris.load.routineload.RoutineLoadProgress;
import org.apache.doris.thrift.TKafkaRLTaskProgress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaProgress
extends RoutineLoadProgress {
    private static final Logger LOG = LogManager.getLogger(KafkaProgress.class);
    public static final String OFFSET_BEGINNING = "OFFSET_BEGINNING";
    public static final String OFFSET_END = "OFFSET_END";
    public static final String OFFSET_ZERO = "OFFSET_ZERO";
    public static final long OFFSET_BEGINNING_VAL = -2L;
    public static final long OFFSET_END_VAL = -1L;
    private Map<Integer, Long> partitionIdToOffset = Maps.newConcurrentMap();

    public KafkaProgress() {
        super(LoadDataSourceType.KAFKA);
    }

    public KafkaProgress(TKafkaRLTaskProgress tKafkaRLTaskProgress) {
        super(LoadDataSourceType.KAFKA);
        this.partitionIdToOffset = tKafkaRLTaskProgress.getPartitionCmtOffset();
    }

    public Map<Integer, Long> getPartitionIdToOffset(List<Integer> partitionIds) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<Integer, Long> entry : this.partitionIdToOffset.entrySet()) {
            for (Integer partitionId : partitionIds) {
                if (!entry.getKey().equals(partitionId)) continue;
                result.put(partitionId, entry.getValue());
            }
        }
        return result;
    }

    public void addPartitionOffset(Pair<Integer, Long> partitionOffset) {
        this.partitionIdToOffset.put((Integer)partitionOffset.first, (Long)partitionOffset.second);
    }

    public Long getOffsetByPartition(int kafkaPartition) {
        return this.partitionIdToOffset.get(kafkaPartition);
    }

    public boolean containsPartition(Integer kafkaPartition) {
        return this.partitionIdToOffset.containsKey(kafkaPartition);
    }

    public boolean hasPartition() {
        return !this.partitionIdToOffset.isEmpty();
    }

    private void getReadableProgress(Map<Integer, String> showPartitionIdToOffset) {
        for (Map.Entry<Integer, Long> entry : this.partitionIdToOffset.entrySet()) {
            if (entry.getValue() == 0L) {
                showPartitionIdToOffset.put(entry.getKey(), OFFSET_ZERO);
                continue;
            }
            if (entry.getValue() == -1L) {
                showPartitionIdToOffset.put(entry.getKey(), OFFSET_END);
                continue;
            }
            if (entry.getValue() == -2L) {
                showPartitionIdToOffset.put(entry.getKey(), OFFSET_BEGINNING);
                continue;
            }
            showPartitionIdToOffset.put(entry.getKey(), "" + (entry.getValue() - 1L));
        }
    }

    public void modifyOffset(List<Pair<Integer, Long>> kafkaPartitionOffsets) throws DdlException {
        for (Pair<Integer, Long> pair : kafkaPartitionOffsets) {
            if (this.partitionIdToOffset.containsKey(pair.first)) continue;
            throw new DdlException("The specified partition " + pair.first + " is not in the consumed partitions");
        }
        for (Pair<Integer, Long> pair : kafkaPartitionOffsets) {
            this.partitionIdToOffset.put((Integer)pair.first, (Long)pair.second);
        }
    }

    public List<Pair<Integer, String>> getPartitionOffsetPairs(boolean alreadyConsumed) {
        ArrayList pairs = Lists.newArrayList();
        for (Map.Entry<Integer, Long> entry : this.partitionIdToOffset.entrySet()) {
            if (entry.getValue() == 0L) {
                pairs.add(Pair.create(entry.getKey(), OFFSET_ZERO));
                continue;
            }
            if (entry.getValue() == -1L) {
                pairs.add(Pair.create(entry.getKey(), OFFSET_END));
                continue;
            }
            if (entry.getValue() == -2L) {
                pairs.add(Pair.create(entry.getKey(), OFFSET_BEGINNING));
                continue;
            }
            long offset = entry.getValue();
            if (alreadyConsumed) {
                --offset;
            }
            pairs.add(Pair.create(entry.getKey(), "" + offset));
        }
        return pairs;
    }

    public Map<Integer, Long> getLag(Map<Integer, Long> partitionIdWithLatestOffsets) {
        HashMap lagMap = Maps.newHashMap();
        for (Map.Entry<Integer, Long> entry : this.partitionIdToOffset.entrySet()) {
            if (partitionIdWithLatestOffsets.containsKey(entry.getKey())) {
                long lag = partitionIdWithLatestOffsets.get(entry.getKey()) - entry.getValue();
                lagMap.put(entry.getKey(), lag);
                continue;
            }
            lagMap.put(entry.getKey(), -1L);
        }
        return lagMap;
    }

    public String toString() {
        HashMap showPartitionIdToOffset = Maps.newHashMap();
        this.getReadableProgress(showPartitionIdToOffset);
        return "KafkaProgress [partitionIdToOffset=" + Joiner.on((String)"|").withKeyValueSeparator("_").join((Map)showPartitionIdToOffset) + "]";
    }

    @Override
    public String toJsonString() {
        HashMap showPartitionIdToOffset = Maps.newHashMap();
        this.getReadableProgress(showPartitionIdToOffset);
        Gson gson = new Gson();
        return gson.toJson((Object)showPartitionIdToOffset);
    }

    @Override
    public void update(RLTaskTxnCommitAttachment attachment) {
        KafkaProgress newProgress = (KafkaProgress)attachment.getProgress();
        newProgress.partitionIdToOffset.entrySet().stream().forEach(entity -> this.partitionIdToOffset.put((Integer)entity.getKey(), (Long)entity.getValue() + 1L));
        LOG.debug("update kafka progress: {}, task: {}, job: {}", (Object)newProgress.toJsonString(), (Object)DebugUtil.printId(attachment.getTaskId()), (Object)attachment.getJobId());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.partitionIdToOffset.size());
        for (Map.Entry<Integer, Long> entry : this.partitionIdToOffset.entrySet()) {
            out.writeInt(entry.getKey());
            out.writeLong(entry.getValue());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int size = in.readInt();
        this.partitionIdToOffset = new HashMap<Integer, Long>();
        for (int i = 0; i < size; ++i) {
            this.partitionIdToOffset.put(in.readInt(), in.readLong());
        }
    }
}

