/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.common.LoadException;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationReportPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class YarnApplicationReport {
    private static final String APPLICATION_ID = "Application-Id";
    private static final String APPLICATION_TYPE = "Application-Type";
    private static final String APPLICATION_NAME = "Application-Name";
    private static final String USER = "User";
    private static final String QUEUE = "Queue";
    private static final String START_TIME = "Start-Time";
    private static final String FINISH_TIME = "Finish-Time";
    private static final String PROGRESS = "Progress";
    private static final String STATE = "State";
    private static final String FINAL_STATE = "Final-State";
    private static final String TRACKING_URL = "Tracking-URL";
    private static final String RPC_PORT = "RPC Port";
    private static final String AM_HOST = "AM Host";
    private static final String DIAGNOSTICS = "Diagnostics";
    private ApplicationReport report = new ApplicationReportPBImpl();

    public YarnApplicationReport(String output) throws LoadException {
        this.parseFromOutput(output);
    }

    public ApplicationReport getReport() {
        return this.report;
    }

    private void parseFromOutput(String output) throws LoadException {
        HashMap reportMap = Maps.newHashMap();
        List lines = Splitter.onPattern((String)"\n").trimResults().splitToList((CharSequence)output);
        for (String line : lines) {
            List entry = Splitter.onPattern((String)":").limit(2).trimResults().splitToList((CharSequence)line);
            Preconditions.checkState((entry.size() <= 2 ? 1 : 0) != 0, (Object)line);
            if (entry.size() > 1) {
                reportMap.put((String)entry.get(0), (String)entry.get(1));
                continue;
            }
            reportMap.put((String)entry.get(0), "");
        }
        try {
            this.report.setApplicationId(ConverterUtils.toApplicationId((String)((String)reportMap.get(APPLICATION_ID))));
            this.report.setName((String)reportMap.get(APPLICATION_NAME));
            this.report.setApplicationType((String)reportMap.get(APPLICATION_TYPE));
            this.report.setUser((String)reportMap.get(USER));
            this.report.setQueue((String)reportMap.get(QUEUE));
            this.report.setStartTime(Long.parseLong((String)reportMap.get(START_TIME)));
            this.report.setFinishTime(Long.parseLong((String)reportMap.get(FINISH_TIME)));
            this.report.setProgress(NumberFormat.getPercentInstance().parse((String)reportMap.get(PROGRESS)).floatValue());
            this.report.setYarnApplicationState(YarnApplicationState.valueOf((String)((String)reportMap.get(STATE))));
            this.report.setFinalApplicationStatus(FinalApplicationStatus.valueOf((String)((String)reportMap.get(FINAL_STATE))));
            this.report.setTrackingUrl((String)reportMap.get(TRACKING_URL));
            this.report.setRpcPort(Integer.parseInt((String)reportMap.get(RPC_PORT)));
            this.report.setHost((String)reportMap.get(AM_HOST));
            this.report.setDiagnostics((String)reportMap.get(DIAGNOSTICS));
        }
        catch (NumberFormatException | ParseException e) {
            throw new LoadException(e.getMessage());
        }
        catch (Exception e) {
            throw new LoadException(e.getMessage());
        }
    }
}

