/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.doris.common.Config;
import org.apache.doris.common.LoadException;
import org.apache.doris.load.loadv2.ConfigFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SparkYarnConfigFiles {
    private static final Logger LOG = LogManager.getLogger(SparkYarnConfigFiles.class);
    private static final String HADOOP_CONF_FILE = "core-site.xml";
    private static final String YARN_CONF_FILE = "yarn-site.xml";
    private static final String SPARK_HADOOP_PREFIX = "spark.hadoop.";
    private static final String HADOOP_PREFIX = "hadoop.";
    private static final String YARN_PREFIX = "yarn.";
    private String configDir;
    private List<ConfigFile> configFiles;

    public String getConfigDir() {
        return this.configDir;
    }

    public SparkYarnConfigFiles(String resourceName, Map<String, String> properties) {
        this.configDir = Config.yarn_config_dir + "/" + resourceName;
        this.configFiles = Lists.newArrayList();
        this.createConfigFiles(properties);
    }

    public SparkYarnConfigFiles(String resourceName, String parentDir, Map<String, String> properties) {
        this.configDir = parentDir + "/" + resourceName;
        this.configFiles = Lists.newArrayList();
        this.createConfigFiles(properties);
    }

    private void createConfigFiles(Map<String, String> properties) {
        LOG.info("create config file, properties size: {}", (Object)properties.size());
        this.configFiles.add(new XMLConfigFile(this.configDir + "/" + HADOOP_CONF_FILE, this.getPropertiesByPrefix(properties, HADOOP_PREFIX)));
        this.configFiles.add(new XMLConfigFile(this.configDir + "/" + YARN_CONF_FILE, this.getPropertiesByPrefix(properties, YARN_PREFIX)));
    }

    public void prepare() throws LoadException {
        this.initConfigFile();
    }

    private void initConfigFile() throws LoadException {
        LOG.info("start to init config file. config dir: {}", (Object)this.configDir);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.configDir) ? 1 : 0) != 0);
        boolean needUpdate = false;
        boolean needReplace = false;
        if (!this.checkConfigDirExists(this.configDir)) {
            needUpdate = true;
        } else {
            for (ConfigFile configFile : this.configFiles) {
                String filePath = configFile.getFilePath();
                if (this.checkConfigFileExists(filePath)) continue;
                needUpdate = true;
                needReplace = true;
                break;
            }
        }
        if (needUpdate) {
            this.updateConfig(needReplace);
        }
        LOG.info("init spark yarn config success, config dir={}, config file size={}", (Object)this.configDir, (Object)this.configFiles.size());
    }

    private boolean checkConfigDirExists(String dir) {
        boolean result = true;
        File configDir = new File(dir);
        if (!configDir.exists() || !configDir.isDirectory()) {
            result = false;
        }
        LOG.info("check yarn client config dir exists, result: {}", (Object)result);
        return result;
    }

    private boolean checkConfigFileExists(String filePath) {
        boolean result = true;
        File configFile = new File(filePath);
        if (!configFile.exists() || !configFile.isFile()) {
            result = false;
        }
        LOG.info("check yarn client config file path exists, result: {}, path: {}", (Object)result, (Object)filePath);
        return result;
    }

    private void updateConfig(boolean needReplace) throws LoadException {
        if (needReplace) {
            this.clearAndDelete(this.configDir);
        }
        this.mkdir(this.configDir);
        for (ConfigFile configFile : this.configFiles) {
            configFile.createFile();
        }
        LOG.info("finished to update yarn client config dir, dir={}", (Object)this.configDir);
    }

    private Map<String, String> getPropertiesByPrefix(Map<String, String> properties, String prefix) {
        HashMap result = Maps.newHashMap();
        Iterator<Map.Entry<String, String>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            String newKey;
            Map.Entry<String, String> property = iterator.next();
            String key = property.getKey();
            if (!key.startsWith(SPARK_HADOOP_PREFIX) || !(newKey = key.substring(SPARK_HADOOP_PREFIX.length())).startsWith(prefix)) continue;
            result.put(newKey, property.getValue());
            iterator.remove();
        }
        return result;
    }

    private void clearAndDelete(String deletePath) {
        File[] files;
        File file = new File(deletePath);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        for (File file1 : files = file.listFiles()) {
            this.clearAndDelete(file1.getAbsolutePath());
        }
        file.delete();
    }

    private void mkdir(String configDir) {
        File file = new File(configDir);
        file.mkdirs();
    }

    public static class XMLConfigFile
    implements ConfigFile {
        private static final String CONFIGURATION = "configuration";
        private static final String PROPERTY = "property";
        private static final String NAME = "name";
        private static final String VALUE = "value";
        private String filePath;
        private Map<String, String> configProperties;

        public XMLConfigFile(String filePath, Map<String, String> configProperties) {
            this.filePath = filePath;
            this.configProperties = configProperties;
        }

        @Override
        public String getFilePath() {
            return this.filePath;
        }

        @Override
        public void createFile() throws LoadException {
            this.createXML(this.filePath, this.configProperties);
        }

        private void createXML(String filePath, Map<String, String> properties) throws LoadException {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = factory.newDocumentBuilder();
                Document document = db.newDocument();
                document.setXmlStandalone(true);
                Element configuration = (Element)this.appendNode(document, CONFIGURATION, null);
                for (Map.Entry<String, String> pair : properties.entrySet()) {
                    Element property = (Element)this.appendNode(configuration, PROPERTY, null);
                    this.appendNode(property, NAME, pair.getKey());
                    this.appendNode(property, VALUE, pair.getValue());
                }
                TransformerFactory tff = TransformerFactory.newInstance();
                Transformer tf = tff.newTransformer();
                tf.setOutputProperty("indent", "yes");
                tf.transform(new DOMSource(document), new StreamResult(new File(filePath)));
            }
            catch (Exception e) {
                throw new LoadException(e.getMessage());
            }
        }

        private Node appendNode(Node parent, String tag, String content) {
            Element child = null;
            child = parent instanceof Document ? ((Document)parent).createElement(tag) : parent.getOwnerDocument().createElement(tag);
            if (content != null && !content.equals("")) {
                child.setTextContent(content);
            }
            return parent.appendChild(child);
        }
    }
}

