/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.ImportColumnDesc;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.HiveTable;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.SparkResource;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.load.BrokerFileGroupAggInfo;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.Load;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.load.loadv2.SparkEtlJobHandler;
import org.apache.doris.load.loadv2.SparkLoadAppHandle;
import org.apache.doris.load.loadv2.SparkLoadJob;
import org.apache.doris.load.loadv2.SparkPendingTaskAttachment;
import org.apache.doris.load.loadv2.etl.EtlJobConfig;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SparkLoadPendingTask
extends LoadTask {
    private static final Logger LOG = LogManager.getLogger(SparkLoadPendingTask.class);
    private final Map<BrokerFileGroupAggInfo.FileGroupAggKey, List<BrokerFileGroup>> aggKeyToBrokerFileGroups;
    private final SparkResource resource;
    private final BrokerDesc brokerDesc;
    private final long dbId;
    private final String loadLabel;
    private final long loadJobId;
    private final long transactionId;
    private EtlJobConfig etlJobConfig;
    private SparkLoadAppHandle sparkLoadAppHandle;

    public SparkLoadPendingTask(SparkLoadJob loadTaskCallback, Map<BrokerFileGroupAggInfo.FileGroupAggKey, List<BrokerFileGroup>> aggKeyToBrokerFileGroups, SparkResource resource, BrokerDesc brokerDesc) {
        super(loadTaskCallback, LoadTask.TaskType.PENDING);
        this.retryTime = 3;
        this.attachment = new SparkPendingTaskAttachment(this.signature);
        this.aggKeyToBrokerFileGroups = aggKeyToBrokerFileGroups;
        this.resource = resource;
        this.brokerDesc = brokerDesc;
        this.dbId = loadTaskCallback.getDbId();
        this.loadJobId = loadTaskCallback.getId();
        this.loadLabel = loadTaskCallback.getLabel();
        this.transactionId = loadTaskCallback.getTransactionId();
        this.sparkLoadAppHandle = loadTaskCallback.getHandle();
        this.failMsg = new FailMsg(FailMsg.CancelType.ETL_SUBMIT_FAIL);
    }

    @Override
    void executeTask() throws UserException {
        LOG.info("begin to execute spark pending task. load job id: {}", (Object)this.loadJobId);
        this.submitEtlJob();
    }

    private void submitEtlJob() throws LoadException {
        SparkPendingTaskAttachment sparkAttachment = (SparkPendingTaskAttachment)this.attachment;
        this.etlJobConfig.outputPath = EtlJobConfig.getOutputPath((String)this.resource.getWorkingDir(), (long)this.dbId, (String)this.loadLabel, (long)this.signature);
        sparkAttachment.setOutputPath(this.etlJobConfig.outputPath);
        SparkEtlJobHandler handler = new SparkEtlJobHandler();
        handler.submitEtlJob(this.loadJobId, this.loadLabel, this.etlJobConfig, this.resource, this.brokerDesc, this.sparkLoadAppHandle, sparkAttachment);
        LOG.info("submit spark etl job success. load job id: {}, attachment: {}", (Object)this.loadJobId, (Object)sparkAttachment);
    }

    @Override
    public void init() throws LoadException {
        this.createEtlJobConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEtlJobConf() throws LoadException {
        List<Table> tableList;
        Database db = Catalog.getCurrentCatalog().getDbOrException(this.dbId, s -> new LoadException("db does not exist. id: " + s));
        HashMap tables = Maps.newHashMap();
        HashMap tableIdToPartitionIds = Maps.newHashMap();
        HashSet allPartitionsTableIds = Sets.newHashSet();
        this.prepareTablePartitionInfos(db, tableIdToPartitionIds, allPartitionsTableIds);
        try {
            tableList = db.getTablesOnIdOrderOrThrowException(Lists.newArrayList((Iterable)allPartitionsTableIds));
        }
        catch (MetaNotFoundException e) {
            throw new LoadException(e.getMessage());
        }
        MetaLockUtils.readLockTables(tableList);
        try {
            for (Map.Entry<BrokerFileGroupAggInfo.FileGroupAggKey, List<BrokerFileGroup>> entry : this.aggKeyToBrokerFileGroups.entrySet()) {
                BrokerFileGroupAggInfo.FileGroupAggKey aggKey = entry.getKey();
                long tableId = aggKey.getTableId();
                OlapTable table = (OlapTable)db.getTableOrException(tableId, s -> new LoadException("table does not exist. id: " + s));
                EtlJobConfig.EtlTable etlTable = null;
                if (tables.containsKey(tableId)) {
                    etlTable = (EtlJobConfig.EtlTable)tables.get(tableId);
                } else {
                    List<EtlJobConfig.EtlIndex> etlIndexes = this.createEtlIndexes(table);
                    EtlJobConfig.EtlPartitionInfo etlPartitionInfo = this.createEtlPartitionInfo(table, (Set)tableIdToPartitionIds.get(tableId));
                    etlTable = new EtlJobConfig.EtlTable(etlIndexes, etlPartitionInfo);
                    tables.put(tableId, etlTable);
                    TransactionState txnState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(this.dbId, this.transactionId);
                    if (txnState == null) {
                        throw new LoadException("txn does not exist. id: " + this.transactionId);
                    }
                    txnState.addTableIndexes(table);
                }
                for (BrokerFileGroup fileGroup : entry.getValue()) {
                    etlTable.addFileGroup(this.createEtlFileGroup(fileGroup, (Set)tableIdToPartitionIds.get(tableId), db, table));
                }
            }
        }
        finally {
            MetaLockUtils.readUnlockTables(tableList);
        }
        String outputFilePattern = EtlJobConfig.getOutputFilePattern((String)this.loadLabel, (EtlJobConfig.FilePatternVersion)EtlJobConfig.FilePatternVersion.V1);
        EtlJobConfig.EtlJobProperty properties = new EtlJobConfig.EtlJobProperty();
        properties.strictMode = ((LoadJob)this.callback).isStrictMode();
        properties.timezone = ((LoadJob)this.callback).getTimeZone();
        this.etlJobConfig = new EtlJobConfig((Map)tables, outputFilePattern, this.loadLabel, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTablePartitionInfos(Database db, Map<Long, Set<Long>> tableIdToPartitionIds, Set<Long> allPartitionsTableIds) throws LoadException {
        for (BrokerFileGroupAggInfo.FileGroupAggKey aggKey : this.aggKeyToBrokerFileGroups.keySet()) {
            long tableId = aggKey.getTableId();
            if (allPartitionsTableIds.contains(tableId)) continue;
            OlapTable table = (OlapTable)db.getTableOrException(tableId, s -> new LoadException("table does not exist. id: " + s));
            table.readLock();
            try {
                Set<Object> partitionIds;
                if (tableIdToPartitionIds.containsKey(tableId)) {
                    partitionIds = tableIdToPartitionIds.get(tableId);
                } else {
                    partitionIds = Sets.newHashSet();
                    tableIdToPartitionIds.put(tableId, (Set<Long>)partitionIds);
                }
                Set<Long> groupPartitionIds = aggKey.getPartitionIds();
                if (groupPartitionIds == null || groupPartitionIds.isEmpty()) {
                    for (Partition partition : table.getPartitions()) {
                        partitionIds.add(partition.getId());
                    }
                    allPartitionsTableIds.add(tableId);
                    continue;
                }
                partitionIds.addAll(groupPartitionIds);
            }
            finally {
                table.readUnlock();
            }
        }
    }

    private List<EtlJobConfig.EtlIndex> createEtlIndexes(OlapTable table) throws LoadException {
        ArrayList etlIndexes = Lists.newArrayList();
        for (Map.Entry<Long, List<Column>> entry : table.getIndexIdToSchema().entrySet()) {
            long indexId = entry.getKey();
            int schemaHash = table.getSchemaHashByIndexId(indexId);
            ArrayList etlColumns = Lists.newArrayList();
            for (Column column : entry.getValue()) {
                etlColumns.add(this.createEtlColumn(column));
            }
            DistributionInfo distributionInfo = table.getDefaultDistributionInfo();
            if (distributionInfo.getType() != DistributionInfo.DistributionInfoType.HASH) {
                String errMsg = "Unsupported distribution type. type: " + distributionInfo.getType().name();
                LOG.warn(errMsg);
                throw new LoadException(errMsg);
            }
            String indexType = null;
            KeysType keysType = table.getKeysTypeByIndexId(indexId);
            switch (keysType) {
                case DUP_KEYS: {
                    indexType = "DUPLICATE";
                    break;
                }
                case AGG_KEYS: {
                    indexType = "AGGREGATE";
                    break;
                }
                case UNIQUE_KEYS: {
                    indexType = "UNIQUE";
                    break;
                }
                default: {
                    String errMsg = "unknown keys type. type: " + keysType.name();
                    LOG.warn(errMsg);
                    throw new LoadException(errMsg);
                }
            }
            boolean isBaseIndex = indexId == table.getBaseIndexId();
            etlIndexes.add(new EtlJobConfig.EtlIndex(indexId, (List)etlColumns, schemaHash, indexType, isBaseIndex));
        }
        return etlIndexes;
    }

    private EtlJobConfig.EtlColumn createEtlColumn(Column column) {
        String name = column.getName();
        PrimitiveType type = column.getDataType();
        String columnType = column.getDataType().toString();
        boolean isAllowNull = column.isAllowNull();
        boolean isKey = column.isKey();
        String aggregationType = null;
        if (column.getAggregationType() != null) {
            aggregationType = column.getAggregationType().toString();
        }
        String defaultValue = null;
        if (column.getDefaultValue() != null) {
            defaultValue = column.getDefaultValue();
        }
        if (column.isAllowNull() && column.getDefaultValue() == null) {
            defaultValue = "\\N";
        }
        int stringLength = 0;
        if (type.isStringType()) {
            stringLength = column.getStrLen();
        }
        int precision = 0;
        int scale = 0;
        if (type.isDecimalV2Type()) {
            precision = column.getPrecision();
            scale = column.getScale();
        }
        return new EtlJobConfig.EtlColumn(name, columnType, isAllowNull, isKey, aggregationType, defaultValue, stringLength, precision, scale);
    }

    private EtlJobConfig.EtlPartitionInfo createEtlPartitionInfo(OlapTable table, Set<Long> partitionIds) throws LoadException {
        PartitionType type = table.getPartitionInfo().getType();
        ArrayList partitionColumnRefs = Lists.newArrayList();
        ArrayList etlPartitions = Lists.newArrayList();
        if (type == PartitionType.RANGE) {
            RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)table.getPartitionInfo();
            for (Column column : rangePartitionInfo.getPartitionColumns()) {
                partitionColumnRefs.add(column.getName());
            }
            for (Map.Entry entry : rangePartitionInfo.getPartitionItemEntryList(false, true)) {
                long partitionId = (Long)entry.getKey();
                if (!partitionIds.contains(partitionId)) continue;
                Partition partition = table.getPartition(partitionId);
                if (partition == null) {
                    throw new LoadException("partition does not exist. id: " + partitionId);
                }
                int bucketNum = partition.getDistributionInfo().getBucketNum();
                Range range = (Range)((PartitionItem)entry.getValue()).getItems();
                boolean isMaxPartition = ((PartitionKey)range.upperEndpoint()).isMaxValue();
                List<LiteralExpr> rangeKeyExprs = ((PartitionKey)range.lowerEndpoint()).getKeys();
                ArrayList startKeys = Lists.newArrayList();
                for (int i = 0; i < rangeKeyExprs.size(); ++i) {
                    LiteralExpr literalExpr = rangeKeyExprs.get(i);
                    Object keyValue = literalExpr.getRealValue();
                    startKeys.add(keyValue);
                }
                ArrayList endKeys = Lists.newArrayList();
                if (!isMaxPartition) {
                    rangeKeyExprs = ((PartitionKey)range.upperEndpoint()).getKeys();
                    for (int i = 0; i < rangeKeyExprs.size(); ++i) {
                        LiteralExpr literalExpr = rangeKeyExprs.get(i);
                        Object keyValue = literalExpr.getRealValue();
                        endKeys.add(keyValue);
                    }
                }
                etlPartitions.add(new EtlJobConfig.EtlPartition(partitionId, (List)startKeys, (List)endKeys, isMaxPartition, bucketNum));
            }
        } else if (type == PartitionType.UNPARTITIONED) {
            Preconditions.checkState((partitionIds.size() == 1 ? 1 : 0) != 0);
            for (Long partitionId : partitionIds) {
                Partition partition = table.getPartition(partitionId);
                if (partition == null) {
                    throw new LoadException("partition does not exist. id: " + partitionId);
                }
                int bucketNum = partition.getDistributionInfo().getBucketNum();
                etlPartitions.add(new EtlJobConfig.EtlPartition(partitionId.longValue(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), true, bucketNum));
            }
        } else {
            throw new LoadException("Spark Load does not support list partition yet");
        }
        ArrayList distributionColumnRefs = Lists.newArrayList();
        DistributionInfo distributionInfo = table.getDefaultDistributionInfo();
        Preconditions.checkState((distributionInfo.getType() == DistributionInfo.DistributionInfoType.HASH ? 1 : 0) != 0);
        for (Column column : ((HashDistributionInfo)distributionInfo).getDistributionColumns()) {
            distributionColumnRefs.add(column.getName());
        }
        return new EtlJobConfig.EtlPartitionInfo(type.typeString, (List)partitionColumnRefs, (List)distributionColumnRefs, (List)etlPartitions);
    }

    /*
     * WARNING - void declaration
     */
    private EtlJobConfig.EtlFileGroup createEtlFileGroup(BrokerFileGroup fileGroup, Set<Long> tablePartitionIds, Database db, OlapTable table) throws LoadException {
        void var11_24;
        ArrayList fileFieldNames;
        ArrayList copiedColumnExprList = Lists.newArrayList(fileGroup.getColumnExprList());
        TreeMap exprByName = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (ImportColumnDesc importColumnDesc : copiedColumnExprList) {
            if (importColumnDesc.isColumn()) continue;
            exprByName.put(importColumnDesc.getColumnName(), importColumnDesc.getExpr());
        }
        try {
            Load.initColumns(table, copiedColumnExprList, fileGroup.getColumnToHadoopFunction());
        }
        catch (UserException e) {
            throw new LoadException(e.getMessage());
        }
        for (ImportColumnDesc importColumnDesc : Load.getSchemaChangeShadowColumnDesc(table, exprByName)) {
            copiedColumnExprList.add(importColumnDesc);
            exprByName.put(importColumnDesc.getColumnName(), importColumnDesc.getExpr());
        }
        if (fileGroup.isNegative()) {
            for (Column column : table.getBaseSchema()) {
                if (column.isKey() || column.getAggregationType() == AggregateType.SUM) continue;
                throw new LoadException("Column is not SUM AggreateType. column:" + column.getName());
            }
        }
        if ((fileFieldNames = fileGroup.getFileFieldNames()) == null || fileFieldNames.isEmpty()) {
            fileFieldNames = Lists.newArrayList();
            for (Column column : table.getBaseSchema()) {
                fileFieldNames.add(column.getName());
            }
        }
        Map<String, Pair<String, List<String>>> map = fileGroup.getColumnToHadoopFunction();
        HashMap columnMappings = Maps.newHashMap();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                columnMappings.put((String)entry.getKey(), new EtlJobConfig.EtlColumnMapping((String)((Pair)entry.getValue()).first, (List)((Pair)entry.getValue()).second));
            }
        }
        for (ImportColumnDesc importColumnDesc : copiedColumnExprList) {
            if (importColumnDesc.isColumn() || columnMappings.containsKey(importColumnDesc.getColumnName())) continue;
            columnMappings.put(importColumnDesc.getColumnName(), new EtlJobConfig.EtlColumnMapping(importColumnDesc.getExpr().toSql()));
        }
        ArrayList partitionIds = fileGroup.getPartitionIds();
        if (partitionIds == null || partitionIds.isEmpty()) {
            partitionIds = Lists.newArrayList(tablePartitionIds);
        }
        String string = "";
        if (fileGroup.getWhereExpr() != null) {
            String string2 = fileGroup.getWhereExpr().toSql();
        }
        String hiveDbTableName = "";
        HashMap hiveTableProperties = Maps.newHashMap();
        if (fileGroup.isLoadFromTable()) {
            long srcTableId = fileGroup.getSrcTableId();
            HiveTable srcHiveTable = (HiveTable)db.getTableOrException(srcTableId, s -> new LoadException("table does not exist. id: " + s));
            hiveDbTableName = srcHiveTable.getHiveDbTable();
            hiveTableProperties.putAll(srcHiveTable.getHiveProperties());
        }
        for (Column column : table.getBaseSchema()) {
            String columnName = column.getName();
            PrimitiveType columnType = column.getDataType();
            Expr expr = (Expr)exprByName.get(columnName);
            if (columnType == PrimitiveType.HLL) {
                this.checkHllMapping(columnName, expr);
            }
            if (columnType != PrimitiveType.BITMAP) continue;
            this.checkBitmapMapping(columnName, expr, fileGroup.isLoadFromTable());
        }
        EtlJobConfig.EtlFileGroup etlFileGroup = null;
        etlFileGroup = fileGroup.isLoadFromTable() ? new EtlJobConfig.EtlFileGroup(EtlJobConfig.SourceType.HIVE, hiveDbTableName, (Map)hiveTableProperties, fileGroup.isNegative(), (Map)columnMappings, (String)var11_24, (List)partitionIds) : new EtlJobConfig.EtlFileGroup(EtlJobConfig.SourceType.FILE, fileGroup.getFilePaths(), (List)fileFieldNames, fileGroup.getColumnsFromPath(), fileGroup.getValueSeparator(), fileGroup.getLineDelimiter(), fileGroup.isNegative(), fileGroup.getFileFormat(), (Map)columnMappings, (String)var11_24, (List)partitionIds);
        return etlFileGroup;
    }

    private void checkHllMapping(String columnName, Expr expr) throws LoadException {
        if (expr == null) {
            throw new LoadException("HLL column func is not assigned. column:" + columnName);
        }
        String msg = "HLL column must use hll function, like " + columnName + "=hll_hash(xxx) or " + columnName + "=hll_empty()";
        if (!(expr instanceof FunctionCallExpr)) {
            throw new LoadException(msg);
        }
        FunctionCallExpr fn = (FunctionCallExpr)expr;
        String functionName = fn.getFnName().getFunction();
        if (!functionName.equalsIgnoreCase("hll_hash") && !functionName.equalsIgnoreCase("hll_empty")) {
            throw new LoadException(msg);
        }
    }

    private void checkBitmapMapping(String columnName, Expr expr, boolean isLoadFromTable) throws LoadException {
        if (expr == null) {
            throw new LoadException("BITMAP column func is not assigned. column:" + columnName);
        }
        String msg = "BITMAP column must use bitmap function, like " + columnName + "=to_bitmap(xxx) or " + columnName + "=bitmap_hash() or " + columnName + "=bitmap_dict()";
        if (!(expr instanceof FunctionCallExpr)) {
            throw new LoadException(msg);
        }
        FunctionCallExpr fn = (FunctionCallExpr)expr;
        String functionName = fn.getFnName().getFunction();
        if (!(functionName.equalsIgnoreCase("to_bitmap") || functionName.equalsIgnoreCase("bitmap_hash") || functionName.equalsIgnoreCase("bitmap_dict") || functionName.equalsIgnoreCase("binary_bitmap"))) {
            throw new LoadException(msg);
        }
        if (functionName.equalsIgnoreCase("bitmap_dict") && !isLoadFromTable) {
            throw new LoadException("Bitmap global dict should load data from hive table");
        }
    }
}

