/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.DescriptorTable;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ResourceDesc;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.SparkResource;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DataQualityException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.QuotaExceedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.EtlStatus;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.BulkLoadJob;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.LoadJobFinalOperation;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.load.loadv2.SparkEtlJobHandler;
import org.apache.doris.load.loadv2.SparkLoadAppHandle;
import org.apache.doris.load.loadv2.SparkLoadPendingTask;
import org.apache.doris.load.loadv2.SparkPendingTaskAttachment;
import org.apache.doris.load.loadv2.TaskAttachment;
import org.apache.doris.load.loadv2.dpp.DppResult;
import org.apache.doris.load.loadv2.etl.EtlJobConfig;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.system.Backend;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.PushTask;
import org.apache.doris.thrift.TBrokerRangeDesc;
import org.apache.doris.thrift.TBrokerScanRange;
import org.apache.doris.thrift.TBrokerScanRangeParams;
import org.apache.doris.thrift.TDescriptorTable;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPriority;
import org.apache.doris.thrift.TPushType;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.doris.transaction.TabletQuorumFailedException;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SparkLoadJob
extends BulkLoadJob {
    private static final Logger LOG = LogManager.getLogger(SparkLoadJob.class);
    private SparkResource sparkResource;
    private long etlStartTimestamp = -1L;
    private String appId = "";
    private String etlOutputPath = "";
    private Map<String, Pair<String, Long>> tabletMetaToFileInfo = Maps.newHashMap();
    private ResourceDesc resourceDesc;
    private SparkLoadAppHandle sparkLoadAppHandle = new SparkLoadAppHandle();
    private long quorumFinishTimestamp = -1L;
    private Map<Long, Set<Long>> tableToLoadPartitions = Maps.newHashMap();
    private Map<Long, PushBrokerReaderParams> indexToPushBrokerReaderParams = Maps.newHashMap();
    private Map<Long, Integer> indexToSchemaHash = Maps.newHashMap();
    private Map<Long, Map<Long, PushTask>> tabletToSentReplicaPushTask = Maps.newHashMap();
    private Set<Long> finishedReplicas = Sets.newHashSet();
    private Set<Long> quorumTablets = Sets.newHashSet();
    private Set<Long> fullTablets = Sets.newHashSet();

    public SparkLoadJob() {
        super(EtlJobType.SPARK);
    }

    public SparkLoadJob(long dbId, String label, ResourceDesc resourceDesc, OriginStatement originStmt, UserIdentity userInfo) throws MetaNotFoundException {
        super(EtlJobType.SPARK, dbId, label, originStmt, userInfo);
        this.resourceDesc = resourceDesc;
    }

    @Override
    public void setJobProperties(Map<String, String> properties) throws DdlException {
        super.setJobProperties(properties);
        this.setResourceInfo();
    }

    private void setResourceInfo() throws DdlException {
        if (this.resourceDesc == null) {
            return;
        }
        String resourceName = this.resourceDesc.getName();
        Resource oriResource = Catalog.getCurrentCatalog().getResourceMgr().getResource(resourceName);
        if (oriResource == null) {
            throw new DdlException("Resource does not exist. name: " + resourceName);
        }
        this.sparkResource = ((SparkResource)oriResource).getCopiedResource();
        this.sparkResource.update(this.resourceDesc);
        Map<String, String> brokerProperties = this.sparkResource.getBrokerPropertiesWithoutPrefix();
        this.brokerDesc = new BrokerDesc(this.sparkResource.getBroker(), brokerProperties);
    }

    @Override
    public void beginTxn() throws LabelAlreadyUsedException, BeginTransactionException, AnalysisException, DuplicatedRequestException, QuotaExceedException, MetaNotFoundException {
        this.transactionId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(this.dbId, Lists.newArrayList(this.fileGroupAggInfo.getAllTableIds()), this.label, null, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), TransactionState.LoadJobSourceType.FRONTEND, this.id, this.getTimeout());
    }

    @Override
    protected void unprotectedExecuteJob() throws LoadException {
        try {
            this.beginTxn();
        }
        catch (UserException e) {
            LOG.warn("failed to begin transaction for spark load job {}", (Object)this.id, (Object)e);
            throw new LoadException(e.getMessage());
        }
        SparkLoadPendingTask task = new SparkLoadPendingTask(this, this.fileGroupAggInfo.getAggKeyToFileGroups(), this.sparkResource, this.brokerDesc);
        ((LoadTask)task).init();
        this.idToTasks.put(task.getSignature(), task);
        Catalog.getCurrentCatalog().getPendingLoadTaskScheduler().submit(task);
    }

    @Override
    public void onTaskFinished(TaskAttachment attachment) {
        if (attachment instanceof SparkPendingTaskAttachment) {
            this.onPendingTaskFinished((SparkPendingTaskAttachment)attachment);
        }
    }

    private void onPendingTaskFinished(SparkPendingTaskAttachment attachment) {
        this.writeLock();
        try {
            if (this.isTxnDone()) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("state", (Object)this.state).add("error_msg", "this task will be ignored when job is: " + (Object)((Object)this.state)).build());
                return;
            }
            if (this.finishedTaskIds.contains(attachment.getTaskId())) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("task_id", attachment.getTaskId()).add("error_msg", "this is a duplicated callback of pending task when broker already has loading task").build());
                return;
            }
            this.finishedTaskIds.add(attachment.getTaskId());
            this.sparkLoadAppHandle = attachment.getHandle();
            this.appId = attachment.getAppId();
            this.etlOutputPath = attachment.getOutputPath();
            this.executeEtl();
            this.unprotectedLogUpdateStateInfo();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void executeEtl() {
        this.etlStartTimestamp = System.currentTimeMillis();
        this.state = JobState.ETL;
        LOG.info("update to {} state success. job id: {}", (Object)this.state, (Object)this.id);
    }

    private boolean checkState(JobState expectState) {
        this.readLock();
        try {
            if (this.state == expectState) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateEtlStatus() throws Exception {
        if (!this.checkState(JobState.ETL)) {
            return;
        }
        handler = new SparkEtlJobHandler();
        status = handler.getEtlJobStatus(this.sparkLoadAppHandle, this.appId, this.id, this.etlOutputPath, this.sparkResource, this.brokerDesc);
        this.writeLock();
        try {
            switch (1.$SwitchMap$org$apache$doris$thrift$TEtlState[status.getState().ordinal()]) {
                case 1: {
                    this.unprotectedUpdateEtlStatusInternal(status);
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.unprotectedProcessEtlFinish(status, handler);
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 3: {
                    throw new LoadException("spark etl job failed. msg: " + status.getFailMsg());
                }
                default: {
                    SparkLoadJob.LOG.warn("unknown etl state: {}", (Object)status.getState().name());
                    break;
                }
            }
        }
        finally {
            this.writeUnlock();
        }
        if (this.checkState(JobState.LOADING)) {
            this.submitPushTasks();
        }
    }

    private void unprotectedUpdateEtlStatusInternal(EtlStatus etlStatus) {
        DppResult dppResult;
        this.loadingStatus = etlStatus;
        this.progress = etlStatus.getProgress();
        if (!this.sparkResource.isYarnMaster()) {
            this.loadingStatus.setTrackingUrl(this.appId);
        }
        if ((dppResult = etlStatus.getDppResult()) != null) {
            this.loadStatistic.fileNum = (int)dppResult.fileNumber;
            this.loadStatistic.totalFileSizeB = dppResult.fileSize;
            TUniqueId dummyId = new TUniqueId(0L, 0L);
            long dummyBackendId = -1L;
            this.loadStatistic.initLoad(dummyId, Sets.newHashSet((Object[])new TUniqueId[]{dummyId}), Lists.newArrayList((Object[])new Long[]{dummyBackendId}));
            this.loadStatistic.updateLoadProgress(dummyBackendId, dummyId, dummyId, dppResult.scannedRows, dppResult.scannedBytes, true);
            Map<String, String> counters = this.loadingStatus.getCounters();
            counters.put("dpp.norm.ALL", String.valueOf(dppResult.normalRows));
            counters.put("dpp.abnorm.ALL", String.valueOf(dppResult.abnormalRows));
            counters.put("unselected.rows", String.valueOf(dppResult.unselectRows));
        }
    }

    private void unprotectedProcessEtlFinish(EtlStatus etlStatus, SparkEtlJobHandler handler) throws Exception {
        this.unprotectedUpdateEtlStatusInternal(etlStatus);
        if (!this.checkDataQuality()) {
            throw new DataQualityException("quality not good enough to cancel");
        }
        this.unprotectedUpdateToLoadingState(etlStatus, handler.getEtlFilePaths(this.etlOutputPath, this.brokerDesc));
        this.unprotectedLogUpdateStateInfo();
        this.unprotectedPrepareLoadingInfos();
    }

    private void unprotectedUpdateToLoadingState(EtlStatus etlStatus, Map<String, Long> filePathToSize) throws LoadException {
        try {
            for (Map.Entry<String, Long> entry : filePathToSize.entrySet()) {
                String filePath = entry.getKey();
                if (!filePath.endsWith("parquet")) continue;
                String tabletMetaStr = EtlJobConfig.getTabletMetaStr((String)filePath);
                this.tabletMetaToFileInfo.put(tabletMetaStr, Pair.create(filePath, entry.getValue()));
            }
            this.loadingStatus = etlStatus;
            this.progress = 0;
            this.unprotectedUpdateState(JobState.LOADING);
            LOG.info("update to {} state success. job id: {}", (Object)this.state, (Object)this.id);
        }
        catch (Exception e) {
            LOG.warn("update to {} state failed. job id: {}", (Object)this.state, (Object)this.id, (Object)e);
            throw new LoadException(e.getMessage(), e);
        }
    }

    private void unprotectedPrepareLoadingInfos() {
        for (String tabletMetaStr : this.tabletMetaToFileInfo.keySet()) {
            String[] fileNameArr = tabletMetaStr.split("\\.");
            Preconditions.checkState((fileNameArr.length == 5 ? 1 : 0) != 0);
            long tableId = Long.parseLong(fileNameArr[0]);
            long partitionId = Long.parseLong(fileNameArr[1]);
            long indexId = Long.parseLong(fileNameArr[2]);
            int schemaHash = Integer.parseInt(fileNameArr[4]);
            if (!this.tableToLoadPartitions.containsKey(tableId)) {
                this.tableToLoadPartitions.put(tableId, Sets.newHashSet());
            }
            this.tableToLoadPartitions.get(tableId).add(partitionId);
            this.indexToSchemaHash.put(indexId, schemaHash);
        }
    }

    private PushBrokerReaderParams getPushBrokerReaderParams(OlapTable table, long indexId) throws UserException {
        if (!this.indexToPushBrokerReaderParams.containsKey(indexId)) {
            PushBrokerReaderParams pushBrokerReaderParams = new PushBrokerReaderParams();
            pushBrokerReaderParams.init(table.getSchemaByIndexId(indexId), this.brokerDesc);
            this.indexToPushBrokerReaderParams.put(indexId, pushBrokerReaderParams);
        }
        return this.indexToPushBrokerReaderParams.get(indexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> submitPushTasks() throws UserException {
        Database db = null;
        try {
            db = this.getDb();
        }
        catch (MetaNotFoundException e) {
            String errMsg = new LogBuilder(LogKey.LOAD_JOB, this.id).add("database_id", this.dbId).add("label", this.label).add("error_msg", "db has been deleted when job is loading").build();
            throw new MetaNotFoundException(errMsg);
        }
        AgentBatchTask batchTask = new AgentBatchTask();
        boolean hasLoadPartitions = false;
        HashSet totalTablets = Sets.newHashSet();
        List<Table> tableList = db.getTablesOnIdOrderOrThrowException(Lists.newArrayList(this.tableToLoadPartitions.keySet()));
        MetaLockUtils.readLockTables(tableList);
        try {
            HashSet hashSet;
            block23: {
                this.writeLock();
                if (this.state == JobState.LOADING) break block23;
                LOG.warn("job state is not loading. job id: {}, state: {}", (Object)this.id, (Object)this.state);
                HashSet hashSet2 = totalTablets;
                this.writeUnlock();
                return hashSet2;
            }
            try {
                for (Table table : tableList) {
                    Set<Long> partitionIds = this.tableToLoadPartitions.get(table.getId());
                    OlapTable olapTable = (OlapTable)table;
                    for (long partitionId : partitionIds) {
                        Partition partition = olapTable.getPartition(partitionId);
                        if (partition == null) {
                            LOG.warn("partition does not exist. id: {}", (Object)partitionId);
                            continue;
                        }
                        hasLoadPartitions = true;
                        int quorumReplicaNum = olapTable.getPartitionInfo().getReplicaAllocation(partitionId).getTotalReplicaNum() / 2 + 1;
                        List<MaterializedIndex> indexes = partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL);
                        for (MaterializedIndex index : indexes) {
                            long indexId = index.getId();
                            int schemaHash = this.indexToSchemaHash.get(indexId);
                            int bucket = 0;
                            for (Tablet tablet : index.getTablets()) {
                                long tabletId = tablet.getId();
                                totalTablets.add(tabletId);
                                String tabletMetaStr = String.format("%d.%d.%d.%d.%d", olapTable.getId(), partitionId, indexId, bucket++, schemaHash);
                                HashSet tabletAllReplicas = Sets.newHashSet();
                                HashSet tabletFinishedReplicas = Sets.newHashSet();
                                for (Replica replica : tablet.getReplicas()) {
                                    long replicaId = replica.getId();
                                    tabletAllReplicas.add(replicaId);
                                    if (!this.tabletToSentReplicaPushTask.containsKey(tabletId) || !this.tabletToSentReplicaPushTask.get(tabletId).containsKey(replicaId)) {
                                        long backendId = replica.getBackendId();
                                        long taskSignature = Catalog.getCurrentGlobalTransactionMgr().getTransactionIDGenerator().getNextTransactionId();
                                        PushBrokerReaderParams params = this.getPushBrokerReaderParams(olapTable, indexId);
                                        TBrokerScanRange tBrokerScanRange = new TBrokerScanRange(params.tBrokerScanRange);
                                        TBrokerRangeDesc tBrokerRangeDesc = (TBrokerRangeDesc)tBrokerScanRange.getRanges().get(0);
                                        tBrokerRangeDesc.setPath("");
                                        tBrokerRangeDesc.setFileSize(-1L);
                                        if (this.tabletMetaToFileInfo.containsKey(tabletMetaStr)) {
                                            Pair<String, Long> fileInfo = this.tabletMetaToFileInfo.get(tabletMetaStr);
                                            tBrokerRangeDesc.setPath((String)fileInfo.first);
                                            tBrokerRangeDesc.setFileSize(((Long)fileInfo.second).longValue());
                                        }
                                        Catalog.getCurrentCatalog();
                                        Backend backend = Catalog.getCurrentSystemInfo().getBackend(backendId);
                                        FsBroker fsBroker = Catalog.getCurrentCatalog().getBrokerMgr().getBroker(this.brokerDesc.getName(), backend.getHost());
                                        tBrokerScanRange.getBrokerAddresses().add(new TNetworkAddress(fsBroker.ip, fsBroker.port));
                                        LOG.debug("push task for replica {}, broker {}:{}, backendId {}, filePath {}, fileSize {}", (Object)replicaId, (Object)fsBroker.ip, (Object)fsBroker.port, (Object)backendId, (Object)tBrokerRangeDesc.path, (Object)tBrokerRangeDesc.file_size);
                                        PushTask pushTask = new PushTask(backendId, this.dbId, olapTable.getId(), partitionId, indexId, tabletId, replicaId, schemaHash, 0, this.id, TPushType.LOAD_V2, TPriority.NORMAL, this.transactionId, taskSignature, tBrokerScanRange, params.tDescriptorTable);
                                        if (AgentTaskQueue.addTask(pushTask)) {
                                            batchTask.addTask(pushTask);
                                            if (!this.tabletToSentReplicaPushTask.containsKey(tabletId)) {
                                                this.tabletToSentReplicaPushTask.put(tabletId, Maps.newHashMap());
                                            }
                                            this.tabletToSentReplicaPushTask.get(tabletId).put(replicaId, pushTask);
                                        }
                                    }
                                    if (!this.finishedReplicas.contains(replicaId) || replica.getLastFailedVersion() >= 0L) continue;
                                    tabletFinishedReplicas.add(replicaId);
                                }
                                if (tabletAllReplicas.size() == 0) {
                                    LOG.error("invalid situation. tablet is empty. id: {}", (Object)tabletId);
                                }
                                if (tabletFinishedReplicas.size() < quorumReplicaNum) continue;
                                this.quorumTablets.add(tabletId);
                                if (tabletFinishedReplicas.size() != tabletAllReplicas.size()) continue;
                                this.fullTablets.add(tabletId);
                            }
                        }
                    }
                }
                if (batchTask.getTaskNum() > 0) {
                    AgentTaskExecutor.submit(batchTask);
                }
                if (!hasLoadPartitions) {
                    String errMsg = new LogBuilder(LogKey.LOAD_JOB, this.id).add("database_id", this.dbId).add("label", this.label).add("error_msg", "all partitions have no load data").build();
                    throw new LoadException(errMsg);
                }
                hashSet = totalTablets;
            }
            catch (Throwable throwable) {
                this.writeUnlock();
                throw throwable;
            }
            this.writeUnlock();
            return hashSet;
        }
        finally {
            MetaLockUtils.readUnlockTables(tableList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinishedReplica(long replicaId, long tabletId, long backendId) {
        this.writeLock();
        try {
            if (this.finishedReplicas.add(replicaId)) {
                this.commitInfos.add(new TabletCommitInfo(tabletId, backendId));
                Map<Long, PushTask> sentReplicaPushTask = this.tabletToSentReplicaPushTask.get(tabletId);
                if (sentReplicaPushTask != null && sentReplicaPushTask.containsKey(replicaId)) {
                    sentReplicaPushTask.put(replicaId, null);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoadingStatus() throws UserException {
        if (!this.checkState(JobState.LOADING)) {
            return;
        }
        Set<Long> totalTablets = this.submitPushTasks();
        if (totalTablets.isEmpty()) {
            LOG.warn("total tablets set is empty. job id: {}, state: {}", (Object)this.id, (Object)this.state);
            return;
        }
        boolean canCommitJob = false;
        this.writeLock();
        try {
            this.progress = this.fullTablets.size() * 100 / totalTablets.size();
            if (this.progress == 100) {
                this.progress = 99;
            }
            if (this.quorumFinishTimestamp < 0L && this.quorumTablets.containsAll(totalTablets)) {
                this.quorumFinishTimestamp = System.currentTimeMillis();
            }
            long stragglerTimeout = Config.load_straggler_wait_second * 1000;
            if (this.quorumFinishTimestamp > 0L && System.currentTimeMillis() - this.quorumFinishTimestamp > stragglerTimeout || this.fullTablets.containsAll(totalTablets)) {
                canCommitJob = true;
            }
        }
        finally {
            this.writeUnlock();
        }
        if (canCommitJob) {
            this.tryCommitJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCommitJob() throws UserException {
        LOG.info(new LogBuilder(LogKey.LOAD_JOB, this.id).add("txn_id", this.transactionId).add("msg", "Load job try to commit txn").build());
        Database db = this.getDb();
        List<Table> tableList = db.getTablesOnIdOrderOrThrowException(Lists.newArrayList(this.tableToLoadPartitions.keySet()));
        MetaLockUtils.writeLockTablesOrMetaException(tableList);
        try {
            Catalog.getCurrentGlobalTransactionMgr().commitTransaction(this.dbId, tableList, this.transactionId, this.commitInfos, new LoadJobFinalOperation(this.id, this.loadingStatus, this.progress, this.loadStartTimestamp, this.finishTimestamp, this.state, this.failMsg));
        }
        catch (TabletQuorumFailedException tabletQuorumFailedException) {
        }
        finally {
            MetaLockUtils.writeUnlockTables(tableList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearJob() {
        Preconditions.checkState((this.state == JobState.FINISHED || this.state == JobState.CANCELLED ? 1 : 0) != 0);
        LOG.debug("kill etl job and delete etl files. id: {}, state: {}", (Object)this.id, (Object)this.state);
        SparkEtlJobHandler handler = new SparkEtlJobHandler();
        if (this.state == JobState.CANCELLED && (!Strings.isNullOrEmpty((String)this.appId) && this.sparkResource.isYarnMaster() || this.sparkLoadAppHandle != null)) {
            try {
                handler.killEtlJob(this.sparkLoadAppHandle, this.appId, this.id, this.sparkResource);
            }
            catch (Exception e) {
                LOG.warn("kill etl job failed. id: {}, state: {}", (Object)this.id, (Object)this.state, (Object)e);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.etlOutputPath)) {
            try {
                String outputPath = this.etlOutputPath.substring(0, this.etlOutputPath.lastIndexOf("/"));
                handler.deleteEtlOutputPath(outputPath, this.brokerDesc);
            }
            catch (Exception e) {
                LOG.warn("delete etl files failed. id: {}, state: {}", (Object)this.id, (Object)this.state, (Object)e);
            }
        }
        LOG.debug("clear push tasks and infos that not persist. id: {}, state: {}", (Object)this.id, (Object)this.state);
        this.writeLock();
        try {
            for (Map<Long, PushTask> sentReplicaPushTask : this.tabletToSentReplicaPushTask.values()) {
                for (PushTask pushTask : sentReplicaPushTask.values()) {
                    if (pushTask == null) continue;
                    AgentTaskQueue.removeTask(pushTask.getBackendId(), pushTask.getTaskType(), pushTask.getSignature());
                }
            }
            this.sparkLoadAppHandle = null;
            this.resourceDesc = null;
            this.tableToLoadPartitions.clear();
            this.indexToPushBrokerReaderParams.clear();
            this.indexToSchemaHash.clear();
            this.tabletToSentReplicaPushTask.clear();
            this.finishedReplicas.clear();
            this.quorumTablets.clear();
            this.fullTablets.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void afterVisible(TransactionState txnState, boolean txnOperated) {
        super.afterVisible(txnState, txnOperated);
        this.clearJob();
    }

    @Override
    public void cancelJobWithoutCheck(FailMsg failMsg, boolean abortTxn, boolean needLog) {
        super.cancelJobWithoutCheck(failMsg, abortTxn, needLog);
        this.clearJob();
    }

    @Override
    public void cancelJob(FailMsg failMsg) throws DdlException {
        super.cancelJob(failMsg);
        this.clearJob();
    }

    @Override
    protected String getResourceName() {
        return this.sparkResource.getName();
    }

    @Override
    protected long getEtlStartTimestamp() {
        return this.etlStartTimestamp;
    }

    public SparkLoadAppHandle getHandle() {
        return this.sparkLoadAppHandle;
    }

    public void clearSparkLauncherLog() {
        File file;
        String logPath = this.sparkLoadAppHandle.getLogPath();
        if (!Strings.isNullOrEmpty((String)logPath) && (file = new File(logPath)).exists()) {
            file.delete();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.sparkResource.write(out);
        this.sparkLoadAppHandle.write(out);
        out.writeLong(this.etlStartTimestamp);
        Text.writeString((DataOutput)out, (String)this.appId);
        Text.writeString((DataOutput)out, (String)this.etlOutputPath);
        out.writeInt(this.tabletMetaToFileInfo.size());
        for (Map.Entry<String, Pair<String, Long>> entry : this.tabletMetaToFileInfo.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)((String)entry.getValue().first));
            out.writeLong((Long)entry.getValue().second);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.sparkResource = (SparkResource)Resource.read(in);
        this.sparkLoadAppHandle = SparkLoadAppHandle.read(in);
        this.etlStartTimestamp = in.readLong();
        this.appId = Text.readString((DataInput)in);
        this.etlOutputPath = Text.readString((DataInput)in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String tabletMetaStr = Text.readString((DataInput)in);
            Pair<String, Long> fileInfo = Pair.create(Text.readString((DataInput)in), in.readLong());
            this.tabletMetaToFileInfo.put(tabletMetaStr, fileInfo);
        }
    }

    private void unprotectedLogUpdateStateInfo() {
        SparkLoadJobStateUpdateInfo info = new SparkLoadJobStateUpdateInfo(this.id, this.state, this.transactionId, this.sparkLoadAppHandle, this.etlStartTimestamp, this.appId, this.etlOutputPath, this.loadStartTimestamp, this.tabletMetaToFileInfo);
        Catalog.getCurrentCatalog().getEditLog().logUpdateLoadJob(info);
    }

    @Override
    public void replayUpdateStateInfo(LoadJob.LoadJobStateUpdateInfo info) {
        super.replayUpdateStateInfo(info);
        SparkLoadJobStateUpdateInfo sparkJobStateInfo = (SparkLoadJobStateUpdateInfo)info;
        this.sparkLoadAppHandle = sparkJobStateInfo.getSparkLoadAppHandle();
        this.etlStartTimestamp = sparkJobStateInfo.getEtlStartTimestamp();
        this.appId = sparkJobStateInfo.getAppId();
        this.etlOutputPath = sparkJobStateInfo.getEtlOutputPath();
        this.tabletMetaToFileInfo = sparkJobStateInfo.getTabletMetaToFileInfo();
        switch (this.state) {
            case ETL: {
                break;
            }
            case LOADING: {
                this.unprotectedPrepareLoadingInfos();
                break;
            }
            default: {
                LOG.warn("replay update load job state info failed. error: wrong state. job id: {}, state: {}", (Object)this.id, (Object)this.state);
            }
        }
    }

    private static class PushBrokerReaderParams {
        TBrokerScanRange tBrokerScanRange = new TBrokerScanRange();
        TDescriptorTable tDescriptorTable = null;

        public void init(List<Column> columns, BrokerDesc brokerDesc) throws UserException {
            DescriptorTable descTable = new DescriptorTable();
            TupleDescriptor destTupleDesc = descTable.createTupleDescriptor();
            for (Column column : columns) {
                SlotDescriptor destSlotDesc = descTable.addSlotDescriptor(destTupleDesc);
                destSlotDesc.setIsMaterialized(true);
                destSlotDesc.setColumn(column);
                if (column.isAllowNull()) {
                    destSlotDesc.setIsNullable(true);
                    continue;
                }
                destSlotDesc.setIsNullable(false);
            }
            this.initTBrokerScanRange(descTable, destTupleDesc, columns, brokerDesc);
            this.initTDescriptorTable(descTable);
        }

        private void initTBrokerScanRange(DescriptorTable descTable, TupleDescriptor destTupleDesc, List<Column> columns, BrokerDesc brokerDesc) throws AnalysisException {
            TBrokerScanRangeParams params = new TBrokerScanRangeParams();
            params.setStrictMode(false);
            params.setProperties(brokerDesc.getProperties());
            TupleDescriptor srcTupleDesc = descTable.createTupleDescriptor();
            HashMap srcSlotDescByName = Maps.newHashMap();
            for (Column column : columns) {
                SlotDescriptor srcSlotDesc = descTable.addSlotDescriptor(srcTupleDesc);
                srcSlotDesc.setType(ScalarType.createType(PrimitiveType.VARCHAR));
                srcSlotDesc.setIsMaterialized(true);
                srcSlotDesc.setIsNullable(true);
                srcSlotDesc.setColumn(new Column(column.getName(), PrimitiveType.VARCHAR));
                params.addToSrcSlotIds(srcSlotDesc.getId().asInt());
                srcSlotDescByName.put(column.getName(), srcSlotDesc);
            }
            HashMap destSidToSrcSidWithoutTrans = Maps.newHashMap();
            for (SlotDescriptor destSlotDesc : destTupleDesc.getSlots()) {
                if (!destSlotDesc.isMaterialized()) continue;
                SlotDescriptor srcSlotDesc = (SlotDescriptor)srcSlotDescByName.get(destSlotDesc.getColumn().getName());
                destSidToSrcSidWithoutTrans.put(destSlotDesc.getId().asInt(), srcSlotDesc.getId().asInt());
                Expr expr = new SlotRef(srcSlotDesc);
                expr = this.castToSlot(destSlotDesc, expr);
                params.putToExprOfDestSlot(destSlotDesc.getId().asInt(), expr.treeToThrift());
            }
            params.setDestSidToSrcSidWithoutTrans((Map)destSidToSrcSidWithoutTrans);
            params.setSrcTupleId(srcTupleDesc.getId().asInt());
            params.setDestTupleId(destTupleDesc.getId().asInt());
            this.tBrokerScanRange.setParams(params);
            this.tBrokerScanRange.setBrokerAddresses((List)Lists.newArrayList());
            TBrokerRangeDesc tBrokerRangeDesc = new TBrokerRangeDesc();
            tBrokerRangeDesc.setFileType(TFileType.FILE_BROKER);
            tBrokerRangeDesc.setFormatType(TFileFormatType.FORMAT_PARQUET);
            tBrokerRangeDesc.setSplittable(false);
            tBrokerRangeDesc.setStartOffset(0L);
            tBrokerRangeDesc.setSize(-1L);
            this.tBrokerScanRange.setRanges((List)Lists.newArrayList((Object[])new TBrokerRangeDesc[]{tBrokerRangeDesc}));
        }

        private Expr castToSlot(SlotDescriptor slotDesc, Expr expr) throws AnalysisException {
            PrimitiveType dstType = slotDesc.getType().getPrimitiveType();
            PrimitiveType srcType = expr.getType().getPrimitiveType();
            if (dstType == PrimitiveType.BOOLEAN && srcType == PrimitiveType.VARCHAR) {
                return new CastExpr(Type.BOOLEAN, (Expr)new CastExpr(Type.TINYINT, expr));
            }
            if (dstType != srcType) {
                return expr.castTo(slotDesc.getType());
            }
            return expr;
        }

        private void initTDescriptorTable(DescriptorTable descTable) {
            descTable.computeStatAndMemLayout();
            this.tDescriptorTable = descTable.toThrift();
        }
    }

    public static class SparkLoadJobStateUpdateInfo
    extends LoadJob.LoadJobStateUpdateInfo {
        @SerializedName(value="sparkLoadAppHandle")
        private SparkLoadAppHandle sparkLoadAppHandle;
        @SerializedName(value="etlStartTimestamp")
        private long etlStartTimestamp;
        @SerializedName(value="appId")
        private String appId;
        @SerializedName(value="etlOutputPath")
        private String etlOutputPath;
        @SerializedName(value="tabletMetaToFileInfo")
        private Map<String, Pair<String, Long>> tabletMetaToFileInfo;

        public SparkLoadJobStateUpdateInfo(long jobId, JobState state, long transactionId, SparkLoadAppHandle sparkLoadAppHandle, long etlStartTimestamp, String appId, String etlOutputPath, long loadStartTimestamp, Map<String, Pair<String, Long>> tabletMetaToFileInfo) {
            super(jobId, state, transactionId, loadStartTimestamp);
            this.sparkLoadAppHandle = sparkLoadAppHandle;
            this.etlStartTimestamp = etlStartTimestamp;
            this.appId = appId;
            this.etlOutputPath = etlOutputPath;
            this.tabletMetaToFileInfo = tabletMetaToFileInfo;
        }

        public SparkLoadAppHandle getSparkLoadAppHandle() {
            return this.sparkLoadAppHandle;
        }

        public long getEtlStartTimestamp() {
            return this.etlStartTimestamp;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getEtlOutputPath() {
            return this.etlOutputPath;
        }

        public Map<String, Pair<String, Long>> getTabletMetaToFileInfo() {
            return this.tabletMetaToFileInfo;
        }
    }
}

