/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SparkLoadAppHandle
implements Writable {
    private static final Logger LOG = LogManager.getLogger(SparkLoadAppHandle.class);
    private static final long SUBMIT_APP_TIMEOUT_MS = 300000L;
    private Process process;
    @SerializedName(value="appId")
    private String appId;
    @SerializedName(value="state")
    private State state = State.UNKNOWN;
    @SerializedName(value="queue")
    private String queue;
    @SerializedName(value="startTime")
    private long startTime;
    @SerializedName(value="finalStatus")
    private FinalApplicationStatus finalStatus;
    @SerializedName(value="trackingUrl")
    private String trackingUrl;
    @SerializedName(value="user")
    private String user;
    @SerializedName(value="logPath")
    private String logPath;
    private List<Listener> listeners;

    public SparkLoadAppHandle(Process process) {
        this.process = process;
    }

    public SparkLoadAppHandle() {
    }

    public void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void stop() {
    }

    public void kill() {
        this.setState(State.KILLED);
        if (this.process != null) {
            if (this.process.isAlive()) {
                this.process.destroyForcibly();
            }
            this.process = null;
        }
    }

    public State getState() {
        return this.state;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getQueue() {
        return this.queue;
    }

    public Process getProcess() {
        return this.process;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public FinalApplicationStatus getFinalStatus() {
        return this.finalStatus;
    }

    public String getUrl() {
        return this.trackingUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void setState(State state) {
        this.state = state;
        this.fireEvent(false);
    }

    public void setAppId(String appId) {
        this.appId = appId;
        this.fireEvent(true);
    }

    public void setQueue(String queue) {
        this.queue = queue;
        this.fireEvent(true);
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.fireEvent(true);
    }

    public void setFinalStatus(FinalApplicationStatus status) {
        this.finalStatus = status;
        this.fireEvent(true);
    }

    public void setUrl(String url) {
        this.trackingUrl = url;
        this.fireEvent(true);
    }

    public void setUser(String user) {
        this.user = user;
        this.fireEvent(true);
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
        this.fireEvent(true);
    }

    private void fireEvent(boolean isInfoChanged) {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                if (isInfoChanged) {
                    l.infoChanged(this);
                    continue;
                }
                l.stateChanged(this);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static SparkLoadAppHandle read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (SparkLoadAppHandle)GsonUtils.GSON.fromJson(json, SparkLoadAppHandle.class);
    }

    public static enum State {
        UNKNOWN(false),
        CONNECTED(false),
        SUBMITTED(false),
        RUNNING(false),
        FINISHED(true),
        FAILED(true),
        KILLED(true),
        LOST(true);

        private final boolean isFinal;

        private State(boolean isFinal) {
            this.isFinal = isFinal;
        }

        public boolean isFinal() {
            return this.isFinal;
        }
    }

    public static interface Listener {
        public void stateChanged(SparkLoadAppHandle var1);

        public void infoChanged(SparkLoadAppHandle var1);
    }
}

