/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.doris.load.loadv2.SparkLoadAppHandle;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SparkLauncherMonitor {
    private static final Logger LOG = LogManager.getLogger(SparkLauncherMonitor.class);

    public static LogMonitor createLogMonitor(SparkLoadAppHandle handle) {
        return new LogMonitor(handle);
    }

    private static SparkLoadAppHandle.State fromYarnState(YarnApplicationState yarnState) {
        switch (yarnState) {
            case SUBMITTED: 
            case ACCEPTED: {
                return SparkLoadAppHandle.State.SUBMITTED;
            }
            case RUNNING: {
                return SparkLoadAppHandle.State.RUNNING;
            }
            case FINISHED: {
                return SparkLoadAppHandle.State.FINISHED;
            }
            case FAILED: {
                return SparkLoadAppHandle.State.FAILED;
            }
            case KILLED: {
                return SparkLoadAppHandle.State.KILLED;
            }
        }
        return SparkLoadAppHandle.State.UNKNOWN;
    }

    public static class LogMonitor
    extends Thread {
        private final Process process;
        private SparkLoadAppHandle handle;
        private long submitTimeoutMs;
        private boolean isStop;
        private OutputStream outputStream;
        private static final String STATE = "state";
        private static final String QUEUE = "queue";
        private static final String START_TIME = "start time";
        private static final String FINAL_STATUS = "final status";
        private static final String URL = "tracking URL";
        private static final String USER = "user";
        private static final long DEFAULT_SUBMIT_TIMEOUT_MS = 300000L;

        public LogMonitor(SparkLoadAppHandle handle) {
            this.handle = handle;
            this.process = handle.getProcess();
            this.isStop = false;
            this.setSubmitTimeoutMs(300000L);
        }

        public void setSubmitTimeoutMs(long submitTimeoutMs) {
            this.submitTimeoutMs = submitTimeoutMs;
        }

        public void setRedirectLogPath(String redirectLogPath) throws IOException {
            this.outputStream = new FileOutputStream(new File(redirectLogPath), false);
            this.handle.setLogPath(redirectLogPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.handle.getState() == SparkLoadAppHandle.State.KILLED) {
                this.process.destroyForcibly();
                return;
            }
            BufferedReader outReader = null;
            String line = null;
            long startTime = System.currentTimeMillis();
            try {
                outReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                block18: while (!this.isStop && (line = outReader.readLine()) != null) {
                    String value;
                    SparkLoadAppHandle.State oldState;
                    if (this.outputStream != null) {
                        this.outputStream.write((line + "\n").getBytes());
                    }
                    SparkLoadAppHandle.State newState = oldState = this.handle.getState();
                    if (line.contains(STATE)) {
                        String appId;
                        YarnApplicationState yarnState;
                        String state = LogMonitor.regexGetState(line);
                        if (state != null && (newState = SparkLauncherMonitor.fromYarnState(yarnState = YarnApplicationState.valueOf((String)state))) != oldState) {
                            this.handle.setState(newState);
                        }
                        if ((appId = LogMonitor.regexGetAppId(line)) != null && !appId.equals(this.handle.getAppId())) {
                            this.handle.setAppId(appId);
                        }
                        LOG.debug("spark appId that handle get is {}, state: {}", (Object)this.handle.getAppId(), (Object)this.handle.getState().toString());
                        switch (newState) {
                            case UNKNOWN: 
                            case CONNECTED: 
                            case SUBMITTED: {
                                if (System.currentTimeMillis() - startTime <= this.submitTimeoutMs) continue block18;
                                this.isStop = true;
                                this.handle.kill();
                                break;
                            }
                            case RUNNING: 
                            case FINISHED: {
                                this.isStop = true;
                                break;
                            }
                            case KILLED: 
                            case FAILED: 
                            case LOST: {
                                this.isStop = true;
                                this.handle.kill();
                                break;
                            }
                            default: {
                                Preconditions.checkState((boolean)false, (Object)"wrong spark app state");
                                break;
                            }
                        }
                        continue;
                    }
                    if (!line.contains(QUEUE) && !line.contains(START_TIME) && !line.contains(FINAL_STATUS) && !line.contains(URL) && !line.contains(USER) || Strings.isNullOrEmpty((String)(value = LogMonitor.getValue(line)))) continue;
                    try {
                        if (line.contains(QUEUE)) {
                            this.handle.setQueue(value);
                            continue;
                        }
                        if (line.contains(START_TIME)) {
                            this.handle.setStartTime(Long.parseLong(value));
                            continue;
                        }
                        if (line.contains(FINAL_STATUS)) {
                            this.handle.setFinalStatus(FinalApplicationStatus.valueOf((String)value));
                            continue;
                        }
                        if (line.contains(URL)) {
                            this.handle.setUrl(value);
                            continue;
                        }
                        if (!line.contains(USER)) continue;
                        this.handle.setUser(value);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("parse log encounter an error, line: {}, msg: {}", (Object)line, (Object)e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Exception monitoring process.", (Throwable)e);
            }
            finally {
                try {
                    if (outReader != null) {
                        outReader.close();
                    }
                    if (this.outputStream != null) {
                        this.outputStream.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("close buffered reader error", (Throwable)e);
                }
            }
        }

        private static String getValue(String line) {
            String result = null;
            List entry = Splitter.onPattern((String)":").trimResults().limit(2).splitToList((CharSequence)line);
            if (entry.size() == 2) {
                result = (String)entry.get(1);
            }
            return result;
        }

        private static String regexGetState(String line) {
            String result = null;
            Matcher stateMatcher = Pattern.compile("(?<=\\(state: )(.+?)(?=\\))").matcher(line);
            if (stateMatcher.find()) {
                result = stateMatcher.group();
            }
            return result;
        }

        private static String regexGetAppId(String line) {
            String result = null;
            Matcher appIdMatcher = Pattern.compile("application_[0-9]+_[0-9]+").matcher(line);
            if (appIdMatcher.find()) {
                result = appIdMatcher.group();
            }
            return result;
        }
    }
}

