/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.catalog.SparkResource;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.BrokerUtil;
import org.apache.doris.common.util.CommandResult;
import org.apache.doris.common.util.Util;
import org.apache.doris.load.EtlStatus;
import org.apache.doris.load.loadv2.SparkLauncherMonitor;
import org.apache.doris.load.loadv2.SparkLoadAppHandle;
import org.apache.doris.load.loadv2.SparkPendingTaskAttachment;
import org.apache.doris.load.loadv2.SparkRepository;
import org.apache.doris.load.loadv2.YarnApplicationReport;
import org.apache.doris.load.loadv2.dpp.DppResult;
import org.apache.doris.load.loadv2.etl.EtlJobConfig;
import org.apache.doris.load.loadv2.etl.SparkEtlJob;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TEtlState;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.launcher.SparkLauncher;

public class SparkEtlJobHandler {
    private static final Logger LOG = LogManager.getLogger(SparkEtlJobHandler.class);
    private static final String CONFIG_FILE_NAME = "jobconfig.json";
    private static final String JOB_CONFIG_DIR = "configs";
    private static final String ETL_JOB_NAME = "doris__%s";
    private static final String LAUNCHER_LOG = "spark_launcher_%s_%s.log";
    private static final long GET_APPID_TIMEOUT_MS = 300000L;
    private static final long EXEC_CMD_TIMEOUT_MS = 30000L;
    private static final String YARN_STATUS_CMD = "%s --config %s application -status %s";
    private static final String YARN_KILL_CMD = "%s --config %s application -kill %s";

    public void submitEtlJob(long loadJobId, String loadLabel, EtlJobConfig etlJobConfig, SparkResource resource, BrokerDesc brokerDesc, SparkLoadAppHandle handle, SparkPendingTaskAttachment attachment) throws LoadException {
        this.deleteEtlOutputPath(etlJobConfig.outputPath, brokerDesc);
        if (!FeConstants.runningUnitTest) {
            SparkEtlJobHandler.initLocalDir();
        }
        SparkRepository.SparkArchive archive = resource.prepareArchive();
        SparkRepository.SparkLibrary dppLibrary = archive.getDppLibrary();
        SparkRepository.SparkLibrary spark2xLibrary = archive.getSpark2xLibrary();
        String sparkHome = Config.spark_home_default_dir;
        String configsHdfsDir = etlJobConfig.outputPath + "/" + JOB_CONFIG_DIR + "/";
        String jobConfigHdfsPath = configsHdfsDir + CONFIG_FILE_NAME;
        String appResourceHdfsPath = dppLibrary.remotePath;
        String jobArchiveHdfsPath = spark2xLibrary.remotePath;
        String jobStageHdfsPath = resource.getWorkingDir();
        String logFilePath = Config.spark_launcher_log_dir + "/" + String.format(LAUNCHER_LOG, loadJobId, loadLabel);
        Map<String, String> sparkConfigs = resource.getSparkConfigs();
        if (Strings.isNullOrEmpty((String)sparkConfigs.get("spark.yarn.archive"))) {
            sparkConfigs.put("spark.yarn.archive", jobArchiveHdfsPath);
        }
        if (Strings.isNullOrEmpty((String)sparkConfigs.get("spark.yarn.stage.dir"))) {
            sparkConfigs.put("spark.yarn.stage.dir", jobStageHdfsPath);
        }
        try {
            byte[] configData = etlJobConfig.configToJson().getBytes("UTF-8");
            BrokerUtil.writeFile(configData, jobConfigHdfsPath, brokerDesc);
        }
        catch (UnsupportedEncodingException | UserException e) {
            throw new LoadException(e.getMessage());
        }
        SparkLauncher launcher = new SparkLauncher();
        launcher.setMaster(resource.getMaster()).setDeployMode(resource.getDeployMode().name().toLowerCase()).setAppResource(appResourceHdfsPath).setMainClass(SparkEtlJob.class.getCanonicalName()).setAppName(String.format(ETL_JOB_NAME, loadLabel)).setSparkHome(sparkHome).addAppArgs(new String[]{jobConfigHdfsPath}).redirectError();
        for (Map.Entry<String, String> entry : resource.getSparkConfigs().entrySet()) {
            launcher.setConf(entry.getKey(), entry.getValue());
        }
        SparkLoadAppHandle.State state = null;
        String appId = null;
        String errMsg = "start spark app failed. error: ";
        try {
            Process process = launcher.launch();
            handle.setProcess(process);
            if (!FeConstants.runningUnitTest) {
                SparkLauncherMonitor.LogMonitor logMonitor = SparkLauncherMonitor.createLogMonitor(handle);
                logMonitor.setSubmitTimeoutMs(300000L);
                logMonitor.setRedirectLogPath(logFilePath);
                logMonitor.start();
                try {
                    logMonitor.join();
                }
                catch (InterruptedException e) {
                    logMonitor.interrupt();
                    throw new LoadException(errMsg + e.getMessage());
                }
            }
            appId = handle.getAppId();
            state = handle.getState();
        }
        catch (IOException e) {
            LOG.warn(errMsg, (Throwable)e);
            throw new LoadException(errMsg + e.getMessage());
        }
        if (this.fromSparkState(state) == TEtlState.CANCELLED) {
            throw new LoadException(errMsg + "spark app state: " + state.toString() + ", loadJobId:" + loadJobId);
        }
        if (appId == null) {
            throw new LoadException(errMsg + "Waiting too much time to get appId from handle. spark app state: " + state.toString() + ", loadJobId:" + loadJobId);
        }
        attachment.setAppId(appId);
        attachment.setHandle(handle);
    }

    public EtlStatus getEtlJobStatus(SparkLoadAppHandle handle, String appId, long loadJobId, String etlOutputPath, SparkResource resource, BrokerDesc brokerDesc) throws LoadException {
        EtlStatus status = new EtlStatus();
        Preconditions.checkState((appId != null && !appId.isEmpty() ? 1 : 0) != 0);
        if (resource.isYarnMaster()) {
            String configDir = resource.prepareYarnConfig();
            String yarnClient = resource.getYarnClientPath();
            String yarnStatusCmd = String.format(YARN_STATUS_CMD, yarnClient, configDir, appId);
            LOG.info(yarnStatusCmd);
            String[] envp = new String[]{"LC_ALL=" + Config.locale};
            CommandResult result = Util.executeCommand(yarnStatusCmd, envp, 30000L);
            if (result.getReturnCode() != 0) {
                String stderr = result.getStderr();
                if (stderr != null && stderr.contains("doesn't exist in RM")) {
                    LOG.warn("spark app not found. spark app id: {}, load job id: {}", (Object)appId, (Object)loadJobId);
                    status.setState(TEtlState.CANCELLED);
                }
                LOG.warn("yarn application status failed. spark app id: {}, load job id: {}, timeout: {}, msg: {}", (Object)appId, (Object)loadJobId, (Object)30000L, (Object)stderr);
                status.setState(TEtlState.CANCELLED);
                return status;
            }
            ApplicationReport report = new YarnApplicationReport(result.getStdout()).getReport();
            LOG.info("yarn application -status {}. load job id: {}, output: {}, report: {}", (Object)appId, (Object)loadJobId, (Object)result.getStdout(), (Object)report);
            YarnApplicationState state = report.getYarnApplicationState();
            FinalApplicationStatus faStatus = report.getFinalApplicationStatus();
            status.setState(this.fromYarnState(state, faStatus));
            if (status.getState() == TEtlState.CANCELLED) {
                if (state == YarnApplicationState.FINISHED) {
                    status.setFailMsg("spark app state: " + faStatus.toString());
                } else {
                    status.setFailMsg("yarn app state: " + state.toString());
                }
            }
            status.setTrackingUrl(handle.getUrl() != null ? handle.getUrl() : report.getTrackingUrl());
            status.setProgress((int)(report.getProgress() * 100.0f));
        } else {
            if (handle == null) {
                status.setFailMsg("spark app handle is null");
                status.setState(TEtlState.CANCELLED);
                return status;
            }
            SparkLoadAppHandle.State state = handle.getState();
            status.setState(this.fromSparkState(state));
            if (status.getState() == TEtlState.CANCELLED) {
                status.setFailMsg("spark app state: " + state.toString());
            }
            LOG.info("spark app id: {}, load job id: {}, app state: {}", (Object)appId, (Object)loadJobId, (Object)state);
        }
        if (status.getState() == TEtlState.FINISHED || status.getState() == TEtlState.CANCELLED) {
            String dppResultFilePath = EtlJobConfig.getDppResultFilePath((String)etlOutputPath);
            try {
                byte[] data = BrokerUtil.readFile(dppResultFilePath, brokerDesc, 0L);
                String dppResultStr = new String(data, "UTF-8");
                DppResult dppResult = (DppResult)new Gson().fromJson(dppResultStr, DppResult.class);
                if (dppResult != null) {
                    status.setDppResult(dppResult);
                    if (status.getState() == TEtlState.CANCELLED && !Strings.isNullOrEmpty((String)dppResult.failedReason)) {
                        status.setFailMsg(dppResult.failedReason);
                    }
                }
            }
            catch (JsonSyntaxException | UnsupportedEncodingException | UserException e) {
                LOG.warn("read broker file failed. path: {}", (Object)dppResultFilePath, (Object)e);
            }
        }
        return status;
    }

    public void killEtlJob(SparkLoadAppHandle handle, String appId, long loadJobId, SparkResource resource) throws LoadException {
        if (resource.isYarnMaster()) {
            if (Strings.isNullOrEmpty((String)appId) && Strings.isNullOrEmpty((String)(appId = handle.getAppId()))) {
                handle.kill();
                return;
            }
            String configDir = resource.prepareYarnConfig();
            String yarnClient = resource.getYarnClientPath();
            String yarnKillCmd = String.format(YARN_KILL_CMD, yarnClient, configDir, appId);
            LOG.info(yarnKillCmd);
            String[] envp = new String[]{"LC_ALL=" + Config.locale};
            CommandResult result = Util.executeCommand(yarnKillCmd, envp, 30000L);
            LOG.info("yarn application -kill {}, output: {}", (Object)appId, (Object)result.getStdout());
            if (result.getReturnCode() != 0) {
                String stderr = result.getStderr();
                LOG.warn("yarn application kill failed. app id: {}, load job id: {}, msg: {}", (Object)appId, (Object)loadJobId, (Object)stderr);
            }
        } else if (handle != null) {
            handle.stop();
        }
    }

    public Map<String, Long> getEtlFilePaths(String outputPath, BrokerDesc brokerDesc) throws Exception {
        HashMap filePathToSize = Maps.newHashMap();
        ArrayList fileStatuses = Lists.newArrayList();
        String etlFilePaths = outputPath + "/*";
        try {
            BrokerUtil.parseFile(etlFilePaths, brokerDesc, fileStatuses);
        }
        catch (UserException e) {
            throw new Exception(e);
        }
        for (TBrokerFileStatus fstatus : fileStatuses) {
            if (fstatus.isDir) continue;
            filePathToSize.put(fstatus.getPath(), fstatus.getSize());
        }
        LOG.debug("get spark etl file paths. files map: {}", (Object)filePathToSize);
        return filePathToSize;
    }

    public static synchronized void initLocalDir() {
        String logDir = Config.spark_launcher_log_dir;
        File file = new File(logDir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void deleteEtlOutputPath(String outputPath, BrokerDesc brokerDesc) {
        try {
            BrokerUtil.deletePath(outputPath, brokerDesc);
            LOG.info("delete path success. path: {}", (Object)outputPath);
        }
        catch (UserException e) {
            LOG.warn("delete path failed. path: {}", (Object)outputPath, (Object)e);
        }
    }

    private TEtlState fromYarnState(YarnApplicationState state, FinalApplicationStatus faStatus) {
        switch (state) {
            case FINISHED: {
                if (faStatus == FinalApplicationStatus.SUCCEEDED) {
                    return TEtlState.FINISHED;
                }
                return TEtlState.CANCELLED;
            }
            case FAILED: 
            case KILLED: {
                return TEtlState.CANCELLED;
            }
        }
        return TEtlState.RUNNING;
    }

    private TEtlState fromSparkState(SparkLoadAppHandle.State state) {
        switch (state) {
            case FINISHED: {
                return TEtlState.FINISHED;
            }
            case FAILED: 
            case KILLED: 
            case LOST: {
                return TEtlState.CANCELLED;
            }
        }
        return TEtlState.RUNNING;
    }
}

