/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.thrift.TMiniLoadTxnCommitAttachment;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TxnCommitAttachment;

public class MiniLoadTxnCommitAttachment
extends TxnCommitAttachment {
    private long loadedRows;
    private long filteredRows;
    private String errorLogUrl;

    public MiniLoadTxnCommitAttachment() {
        super(TransactionState.LoadJobSourceType.BACKEND_STREAMING);
    }

    public MiniLoadTxnCommitAttachment(TMiniLoadTxnCommitAttachment tMiniLoadTxnCommitAttachment) {
        super(TransactionState.LoadJobSourceType.BACKEND_STREAMING);
        this.loadedRows = tMiniLoadTxnCommitAttachment.getLoadedRows();
        this.filteredRows = tMiniLoadTxnCommitAttachment.getFilteredRows();
        if (tMiniLoadTxnCommitAttachment.isSetErrorLogUrl()) {
            this.errorLogUrl = tMiniLoadTxnCommitAttachment.getErrorLogUrl();
        }
    }

    public long getLoadedRows() {
        return this.loadedRows;
    }

    public long getFilteredRows() {
        return this.filteredRows;
    }

    public String getErrorLogUrl() {
        return this.errorLogUrl;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.filteredRows);
        out.writeLong(this.loadedRows);
        if (this.errorLogUrl == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.errorLogUrl);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.filteredRows = in.readLong();
        this.loadedRows = in.readLong();
        if (in.readBoolean()) {
            this.errorLogUrl = Text.readString((DataInput)in);
        }
    }
}

