/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.doris.catalog.AuthorizationInfo;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.QuotaExceedException;
import org.apache.doris.common.io.Text;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.MiniLoadTxnCommitAttachment;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TMiniLoadBeginRequest;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MiniLoadJob
extends LoadJob {
    private static final Logger LOG = LogManager.getLogger(MiniLoadJob.class);
    private String tableName;
    private long tableId;

    public MiniLoadJob() {
        super(EtlJobType.MINI);
    }

    public MiniLoadJob(long dbId, long tableId, TMiniLoadBeginRequest request) throws MetaNotFoundException {
        super(EtlJobType.MINI, dbId, request.getLabel());
        this.tableId = tableId;
        this.tableName = request.getTbl();
        if (request.isSetTimeoutSecond()) {
            this.setTimeout(request.getTimeoutSecond());
        }
        if (request.isSetMaxFilterRatio()) {
            this.setMaxFilterRatio(request.getMaxFilterRatio());
        }
        this.loadStartTimestamp = this.createTimestamp = request.getCreateTimestamp();
        this.authorizationInfo = this.gatherAuthInfo();
        this.requestId = request.getRequestId();
    }

    @Override
    public Set<String> getTableNamesForShow() {
        return Sets.newHashSet((Object[])new String[]{this.tableName});
    }

    @Override
    public Set<String> getTableNames() throws MetaNotFoundException {
        return Sets.newHashSet((Object[])new String[]{this.tableName});
    }

    public AuthorizationInfo gatherAuthInfo() throws MetaNotFoundException {
        Database database = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        return new AuthorizationInfo(database.getFullName(), this.getTableNames());
    }

    @Override
    public void beginTxn() throws LabelAlreadyUsedException, BeginTransactionException, AnalysisException, DuplicatedRequestException, QuotaExceedException, MetaNotFoundException {
        this.transactionId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(this.dbId, Lists.newArrayList((Object[])new Long[]{this.tableId}), this.label, this.requestId, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), TransactionState.LoadJobSourceType.BACKEND_STREAMING, this.id, this.getTimeout());
    }

    @Override
    protected void replayTxnAttachment(TransactionState txnState) {
        this.updateLoadingStatue(txnState);
    }

    private void updateLoadingStatue(TransactionState txnState) {
        MiniLoadTxnCommitAttachment miniLoadTxnCommitAttachment = (MiniLoadTxnCommitAttachment)txnState.getTxnCommitAttachment();
        if (miniLoadTxnCommitAttachment == null) {
            LOG.info("no miniLoadTxnCommitAttachment, txn id: {} status: {}", (Object)txnState.getTransactionId(), (Object)txnState.getTransactionStatus());
            return;
        }
        this.loadingStatus.replaceCounter("dpp.abnorm.ALL", String.valueOf(miniLoadTxnCommitAttachment.getFilteredRows()));
        this.loadingStatus.replaceCounter("dpp.norm.ALL", String.valueOf(miniLoadTxnCommitAttachment.getLoadedRows()));
        if (miniLoadTxnCommitAttachment.getErrorLogUrl() != null) {
            this.loadingStatus.setTrackingUrl(miniLoadTxnCommitAttachment.getErrorLogUrl());
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.tableName);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.tableName = Text.readString((DataInput)in);
    }
}

