/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.DescriptorTable;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.planner.BrokerScanNode;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.OlapTableSink;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanFragmentId;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadingTaskPlanner {
    private static final Logger LOG = LogManager.getLogger(LoadingTaskPlanner.class);
    private final long loadJobId;
    private final long txnId;
    private final long dbId;
    private final OlapTable table;
    private final BrokerDesc brokerDesc;
    private final List<BrokerFileGroup> fileGroups;
    private final boolean strictMode;
    private final long timeoutS;
    private final int loadParallelism;
    private final int sendBatchParallelism;
    private UserIdentity userInfo;
    private Analyzer analyzer = new Analyzer(Catalog.getCurrentCatalog(), new ConnectContext());
    private DescriptorTable descTable = this.analyzer.getDescTbl();
    private List<PlanFragment> fragments = Lists.newArrayList();
    private List<ScanNode> scanNodes = Lists.newArrayList();
    private int nextNodeId = 0;

    public LoadingTaskPlanner(Long loadJobId, long txnId, long dbId, OlapTable table, BrokerDesc brokerDesc, List<BrokerFileGroup> brokerFileGroups, boolean strictMode, String timezone, long timeoutS, int loadParallelism, int sendBatchParallelism, UserIdentity userInfo) {
        this.loadJobId = loadJobId;
        this.txnId = txnId;
        this.dbId = dbId;
        this.table = table;
        this.brokerDesc = brokerDesc;
        this.fileGroups = brokerFileGroups;
        this.strictMode = strictMode;
        this.analyzer.setTimezone(timezone);
        this.timeoutS = timeoutS;
        this.loadParallelism = loadParallelism;
        this.sendBatchParallelism = sendBatchParallelism;
        this.userInfo = userInfo;
        if (Catalog.getCurrentCatalog().getAuth().checkDbPriv(userInfo, Catalog.getCurrentCatalog().getDbNullable(dbId).getFullName(), PrivPredicate.SELECT)) {
            this.analyzer.setUDFAllowed(true);
        } else {
            this.analyzer.setUDFAllowed(false);
        }
    }

    public void plan(TUniqueId loadId, List<List<TBrokerFileStatus>> fileStatusesList, int filesAdded) throws UserException {
        TupleDescriptor destTupleDesc = this.descTable.createTupleDescriptor();
        for (Column col : this.table.getFullSchema()) {
            SlotDescriptor slotDesc = this.descTable.addSlotDescriptor(destTupleDesc);
            slotDesc.setIsMaterialized(true);
            slotDesc.setColumn(col);
            if (col.isAllowNull()) {
                slotDesc.setIsNullable(true);
                continue;
            }
            slotDesc.setIsNullable(false);
        }
        BrokerScanNode scanNode = new BrokerScanNode(new PlanNodeId(this.nextNodeId++), destTupleDesc, "BrokerScanNode", fileStatusesList, filesAdded);
        scanNode.setLoadInfo(this.loadJobId, this.txnId, this.table, this.brokerDesc, this.fileGroups, this.strictMode, this.loadParallelism, this.userInfo);
        scanNode.init(this.analyzer);
        scanNode.finalize(this.analyzer);
        this.scanNodes.add(scanNode);
        this.descTable.computeStatAndMemLayout();
        List<Long> partitionIds = this.getAllPartitionIds();
        OlapTableSink olapTableSink = new OlapTableSink(this.table, destTupleDesc, partitionIds);
        olapTableSink.init(loadId, this.txnId, this.dbId, this.timeoutS, this.sendBatchParallelism, false);
        olapTableSink.complete();
        PlanFragment sinkFragment = new PlanFragment(new PlanFragmentId(0), scanNode, DataPartition.RANDOM);
        sinkFragment.setParallelExecNum(this.loadParallelism);
        sinkFragment.setSink(olapTableSink);
        this.fragments.add(sinkFragment);
        for (PlanFragment fragment : this.fragments) {
            fragment.finalize(null);
        }
        Collections.reverse(this.fragments);
    }

    public DescriptorTable getDescTable() {
        return this.descTable;
    }

    public List<PlanFragment> getFragments() {
        return this.fragments;
    }

    public List<ScanNode> getScanNodes() {
        return this.scanNodes;
    }

    public String getTimezone() {
        return this.analyzer.getTimezone();
    }

    private List<Long> getAllPartitionIds() throws LoadException, MetaNotFoundException {
        BrokerFileGroup brokerFileGroup;
        HashSet specifiedPartitionIds = Sets.newHashSet();
        Iterator<BrokerFileGroup> iterator = this.fileGroups.iterator();
        if (iterator.hasNext() && (brokerFileGroup = iterator.next()).getPartitionIds() != null) {
            specifiedPartitionIds.addAll(brokerFileGroup.getPartitionIds());
        }
        if (specifiedPartitionIds.isEmpty()) {
            return null;
        }
        return Lists.newArrayList((Iterable)specifiedPartitionIds);
    }

    public void updateLoadId(TUniqueId loadId) {
        for (PlanFragment planFragment : this.fragments) {
            if (!(planFragment.getSink() instanceof OlapTableSink)) continue;
            OlapTableSink olapTableSink = (OlapTableSink)planFragment.getSink();
            olapTableSink.updateLoadId(loadId);
        }
        LOG.info("update olap table sink's load id to {}, job: {}", (Object)DebugUtil.printId(loadId), (Object)this.loadJobId);
    }
}

