/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.LoadTaskCallback;
import org.apache.doris.load.loadv2.TaskAttachment;
import org.apache.doris.task.MasterTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LoadTask
extends MasterTask {
    private static final Logger LOG = LogManager.getLogger(LoadTask.class);
    protected TaskType taskType;
    protected LoadTaskCallback callback;
    protected TaskAttachment attachment;
    protected FailMsg failMsg = new FailMsg();
    protected int retryTime = 1;

    public LoadTask(LoadTaskCallback callback, TaskType taskType) {
        this.taskType = taskType;
        this.signature = Catalog.getCurrentCatalog().getNextId();
        this.callback = callback;
    }

    @Override
    protected void exec() {
        boolean isFinished = false;
        try {
            this.executeTask();
            this.callback.onTaskFinished(this.attachment);
            isFinished = true;
        }
        catch (UserException e) {
            this.failMsg.setMsg(e.getMessage() == null ? "" : e.getMessage());
            LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.callback.getCallbackId()).add("error_msg", "Failed to execute load task").build(), (Throwable)e);
        }
        catch (Exception e) {
            this.failMsg.setMsg(e.getMessage() == null ? "" : e.getMessage());
            LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.callback.getCallbackId()).add("error_msg", "Unexpected failed to execute load task").build(), (Throwable)e);
        }
        finally {
            if (!isFinished) {
                this.callback.onTaskFailed(this.signature, this.failMsg);
            }
        }
    }

    public void init() throws LoadException {
    }

    abstract void executeTask() throws Exception;

    public int getRetryTime() {
        return this.retryTime;
    }

    public void updateRetryInfo() {
        --this.retryTime;
        this.signature = Catalog.getCurrentCatalog().getNextId();
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public static enum TaskType {
        PENDING,
        LOADING;

    }

    public static enum MergeType {
        MERGE,
        APPEND,
        DELETE;

    }
}

