/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.doris.analysis.CancelLoadStmt;
import org.apache.doris.analysis.LoadStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.Config;
import org.apache.doris.common.DataQualityException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.Load;
import org.apache.doris.load.loadv2.BulkLoadJob;
import org.apache.doris.load.loadv2.InsertLoadJob;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.LoadJobFinalOperation;
import org.apache.doris.load.loadv2.LoadJobScheduler;
import org.apache.doris.load.loadv2.MiniLoadJob;
import org.apache.doris.load.loadv2.SparkLoadJob;
import org.apache.doris.thrift.TMiniLoadBeginRequest;
import org.apache.doris.thrift.TMiniLoadRequest;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadManager
implements Writable {
    private static final Logger LOG = LogManager.getLogger(LoadManager.class);
    private Map<Long, LoadJob> idToLoadJob = Maps.newConcurrentMap();
    private Map<Long, Map<String, List<LoadJob>>> dbIdToLabelToLoadJobs = Maps.newConcurrentMap();
    private LoadJobScheduler loadJobScheduler;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public LoadManager(LoadJobScheduler loadJobScheduler) {
        this.loadJobScheduler = loadJobScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createLoadJobFromStmt(LoadStmt stmt) throws DdlException {
        Database database = this.checkDb(stmt.getLabel().getDbName());
        long dbId = database.getId();
        BulkLoadJob loadJob = null;
        this.writeLock();
        try {
            if (stmt.getBrokerDesc() != null && stmt.getBrokerDesc().isMultiLoadBroker()) {
                if (!Catalog.getCurrentCatalog().getLoadInstance().isUncommittedLabel(dbId, stmt.getLabel().getLabelName())) {
                    throw new DdlException("label: " + stmt.getLabel().getLabelName() + " not found!");
                }
            } else {
                this.checkLabelUsed(dbId, stmt.getLabel().getLabelName());
                if (stmt.getBrokerDesc() == null && stmt.getResourceDesc() == null) {
                    throw new DdlException("LoadManager only support the broker and spark load.");
                }
                if (this.unprotectedGetUnfinishedJobNum() >= (long)Config.desired_max_waiting_jobs) {
                    throw new DdlException("There are more than " + Config.desired_max_waiting_jobs + " unfinished load jobs, please retry later. You can use `SHOW LOAD` to view submitted jobs");
                }
            }
            loadJob = BulkLoadJob.fromLoadStmt(stmt);
            this.createLoadJob(loadJob);
        }
        finally {
            this.writeUnlock();
        }
        Catalog.getCurrentCatalog().getEditLog().logCreateLoadJob(loadJob);
        this.loadJobScheduler.submitJob(loadJob);
        return loadJob.getId();
    }

    private long unprotectedGetUnfinishedJobNum() {
        return this.idToLoadJob.values().parallelStream().filter(j -> j.getState() != JobState.FINISHED && j.getState() != JobState.CANCELLED).count();
    }

    public long createLoadJobFromMiniLoad(TMiniLoadBeginRequest request) throws UserException {
        String cluster = "default_cluster";
        if (request.isSetCluster()) {
            cluster = request.getCluster();
        }
        Database database = this.checkDb(ClusterNamespace.getFullName(cluster, request.getDb()));
        Table table = database.getTableOrDdlException(request.tbl);
        MiniLoadJob loadJob = null;
        this.writeLock();
        try {
            loadJob = new MiniLoadJob(database.getId(), table.getId(), request);
            loadJob.beginTxn();
            loadJob.unprotectedExecute();
            this.createLoadJob(loadJob);
        }
        catch (DuplicatedRequestException e) {
            LOG.info("duplicate request for mini load. request id: {}, txn: {}", (Object)e.getDuplicatedRequestId(), (Object)e.getTxnId());
            long l = e.getTxnId();
            return l;
        }
        catch (UserException e) {
            if (loadJob != null) {
                loadJob.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL, e.getMessage()), false, false);
            }
            throw e;
        }
        finally {
            this.writeUnlock();
        }
        Catalog.getCurrentCatalog().getEditLog().logCreateLoadJob(loadJob);
        return loadJob.getTransactionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLoadJobV1FromStmt(LoadStmt stmt, EtlJobType jobType, long timestamp) throws DdlException {
        Database database = this.checkDb(stmt.getLabel().getDbName());
        this.writeLock();
        try {
            this.checkLabelUsed(database.getId(), stmt.getLabel().getLabelName());
            Catalog.getCurrentCatalog().getLoadInstance().addLoadJob(stmt, jobType, timestamp);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean createLoadJobV1FromRequest(TMiniLoadRequest request) throws DdlException {
        String cluster = "default_cluster";
        if (request.isSetCluster()) {
            cluster = request.getCluster();
        }
        Database database = this.checkDb(ClusterNamespace.getFullName(cluster, request.getDb()));
        this.writeLock();
        try {
            this.checkLabelUsed(database.getId(), request.getLabel());
            boolean bl = Catalog.getCurrentCatalog().getLoadInstance().addMiniLoadJob(request);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLoadJobV1FromMultiStart(String fullDbName, String label) throws DdlException {
        Database database = this.checkDb(fullDbName);
        this.writeLock();
        try {
            this.checkLabelUsed(database.getId(), label);
            Catalog.getCurrentCatalog().getLoadInstance().registerMiniLabel(fullDbName, label, System.currentTimeMillis());
        }
        finally {
            this.writeUnlock();
        }
    }

    public void replayCreateLoadJob(LoadJob loadJob) {
        this.createLoadJob(loadJob);
        LOG.info(new LogBuilder(LogKey.LOAD_JOB, loadJob.getId()).add("msg", "replay create load job").build());
    }

    private void createLoadJob(LoadJob loadJob) {
        if (loadJob.isExpired(System.currentTimeMillis())) {
            return;
        }
        this.addLoadJob(loadJob);
        if (!loadJob.isCompleted()) {
            Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().addCallback(loadJob);
        }
    }

    private void addLoadJob(LoadJob loadJob) {
        Map<String, List<LoadJob>> labelToLoadJobs;
        this.idToLoadJob.put(loadJob.getId(), loadJob);
        long dbId = loadJob.getDbId();
        if (!this.dbIdToLabelToLoadJobs.containsKey(dbId)) {
            this.dbIdToLabelToLoadJobs.put(loadJob.getDbId(), new ConcurrentHashMap());
        }
        if (!(labelToLoadJobs = this.dbIdToLabelToLoadJobs.get(dbId)).containsKey(loadJob.getLabel())) {
            labelToLoadJobs.put(loadJob.getLabel(), new ArrayList());
        }
        labelToLoadJobs.get(loadJob.getLabel()).add(loadJob);
    }

    public void recordFinishedLoadJob(String label, long transactionId, String dbName, long tableId, EtlJobType jobType, long createTimestamp, String failMsg, String trackingUrl) throws MetaNotFoundException {
        InsertLoadJob loadJob;
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(dbName);
        switch (jobType) {
            case INSERT: {
                loadJob = new InsertLoadJob(label, transactionId, db.getId(), tableId, createTimestamp, failMsg, trackingUrl);
                break;
            }
            default: {
                return;
            }
        }
        this.addLoadJob(loadJob);
        Catalog.getCurrentCatalog().getEditLog().logCreateLoadJob(loadJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLoadJob(CancelLoadStmt stmt, boolean isAccurateMatch) throws DdlException, AnalysisException {
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(stmt.getDbName());
        ArrayList loadJobs = Lists.newArrayList();
        this.readLock();
        try {
            Map<String, List<LoadJob>> labelToLoadJobs = this.dbIdToLabelToLoadJobs.get(db.getId());
            if (labelToLoadJobs == null) {
                throw new DdlException("Load job does not exist");
            }
            ArrayList matchLoadJobs = Lists.newArrayList();
            if (isAccurateMatch) {
                if (labelToLoadJobs.containsKey(stmt.getLabel())) {
                    matchLoadJobs.addAll((Collection)labelToLoadJobs.get(stmt.getLabel()));
                }
            } else {
                PatternMatcher matcher = PatternMatcher.createMysqlPattern(stmt.getLabel(), CaseSensibility.LABEL.getCaseSensibility());
                for (Map.Entry<String, List<LoadJob>> entry : labelToLoadJobs.entrySet()) {
                    if (!matcher.match(entry.getKey())) continue;
                    matchLoadJobs.addAll((Collection)entry.getValue());
                }
            }
            if (matchLoadJobs.isEmpty()) {
                throw new DdlException("Load job does not exist");
            }
            List uncompletedLoadJob = matchLoadJobs.stream().filter(entity -> !entity.isTxnDone()).collect(Collectors.toList());
            if (uncompletedLoadJob.isEmpty()) {
                throw new DdlException("There is no uncompleted job which label " + (isAccurateMatch ? "is " : "like ") + stmt.getLabel());
            }
            loadJobs.addAll(uncompletedLoadJob);
        }
        finally {
            this.readUnlock();
        }
        for (LoadJob loadJob : loadJobs) {
            try {
                loadJob.cancelJob(new FailMsg(FailMsg.CancelType.USER_CANCEL, "user cancel"));
            }
            catch (DdlException e) {
                throw new DdlException("Cancel load job [" + loadJob.getId() + "] fail, label=[" + loadJob.getLabel() + "] failed msg=" + e.getMessage());
            }
        }
    }

    public void replayEndLoadJob(LoadJobFinalOperation operation) {
        LoadJob job = this.idToLoadJob.get(operation.getId());
        if (job == null) {
            LOG.warn("job does not exist when replaying end load job edit log: {}", (Object)operation);
            return;
        }
        job.unprotectReadEndOperation(operation);
        LOG.info(new LogBuilder(LogKey.LOAD_JOB, operation.getId()).add("operation", operation).add("msg", "replay end load job").build());
    }

    public void replayUpdateLoadJobStateInfo(LoadJob.LoadJobStateUpdateInfo info) {
        long jobId = info.getJobId();
        LoadJob job = this.idToLoadJob.get(jobId);
        if (job == null) {
            LOG.warn("replay update load job state failed. error: job not found, id: {}", (Object)jobId);
            return;
        }
        job.replayUpdateStateInfo(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoadJobNum(JobState jobState, long dbId) {
        this.readLock();
        try {
            Map<String, List<LoadJob>> labelToLoadJobs = this.dbIdToLabelToLoadJobs.get(dbId);
            if (labelToLoadJobs == null) {
                int n = 0;
                return n;
            }
            List loadJobList = labelToLoadJobs.values().stream().flatMap(entity -> entity.stream()).collect(Collectors.toList());
            int n = (int)loadJobList.stream().filter(entity -> entity.getState() == jobState).count();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLoadJobNum(JobState jobState, EtlJobType jobType) {
        this.readLock();
        try {
            long l = this.idToLoadJob.values().stream().filter(j -> j.getState() == jobState && j.getJobType() == jobType).count();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldLoadJob() {
        long currentTimeMs = System.currentTimeMillis();
        this.writeLock();
        try {
            Iterator<Map.Entry<Long, LoadJob>> iter = this.idToLoadJob.entrySet().iterator();
            while (iter.hasNext()) {
                LoadJob job = iter.next().getValue();
                if (!job.isExpired(currentTimeMs)) continue;
                iter.remove();
                Map<String, List<LoadJob>> map = this.dbIdToLabelToLoadJobs.get(job.getDbId());
                List<LoadJob> list = map.get(job.getLabel());
                list.remove(job);
                if (job instanceof SparkLoadJob) {
                    ((SparkLoadJob)job).clearSparkLauncherLog();
                }
                if (list.isEmpty()) {
                    map.remove(job.getLabel());
                }
                if (!map.isEmpty()) continue;
                this.dbIdToLabelToLoadJobs.remove(job.getDbId());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void processEtlStateJobs() {
        this.idToLoadJob.values().stream().filter(job -> job.jobType == EtlJobType.SPARK && job.state == JobState.ETL).forEach(job -> {
            try {
                ((SparkLoadJob)job).updateEtlStatus();
            }
            catch (DataQualityException e) {
                LOG.info("update load job etl status failed. job id: {}", (Object)job.getId(), (Object)e);
                job.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.ETL_QUALITY_UNSATISFIED, "quality not good enough to cancel"), true, true);
            }
            catch (UserException e) {
                LOG.warn("update load job etl status failed. job id: {}", (Object)job.getId(), (Object)e);
                job.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.ETL_RUN_FAIL, e.getMessage()), true, true);
            }
            catch (Exception e) {
                LOG.warn("update load job etl status failed. job id: {}", (Object)job.getId(), (Object)e);
            }
        });
    }

    public void processLoadingStateJobs() {
        this.idToLoadJob.values().stream().filter(job -> job.jobType == EtlJobType.SPARK && job.state == JobState.LOADING).forEach(job -> {
            try {
                ((SparkLoadJob)job).updateLoadingStatus();
            }
            catch (UserException e) {
                LOG.warn("update load job loading status failed. job id: {}", (Object)job.getId(), (Object)e);
                job.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL, e.getMessage()), true, true);
            }
            catch (Exception e) {
                LOG.warn("update load job loading status failed. job id: {}", (Object)job.getId(), (Object)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Comparable>> getLoadJobInfosByDb(long dbId, String labelValue, boolean accurateMatch, Set<String> statesValue) throws AnalysisException {
        LinkedList<List<Comparable>> loadJobInfos = new LinkedList<List<Comparable>>();
        if (!this.dbIdToLabelToLoadJobs.containsKey(dbId)) {
            return loadJobInfos;
        }
        HashSet states = Sets.newHashSet();
        if (statesValue == null || statesValue.size() == 0) {
            states.addAll(EnumSet.allOf(JobState.class));
        } else {
            for (String stateValue : statesValue) {
                try {
                    states.add(JobState.valueOf(stateValue));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        this.readLock();
        try {
            Map<String, List<LoadJob>> labelToLoadJobs = this.dbIdToLabelToLoadJobs.get(dbId);
            ArrayList loadJobList = Lists.newArrayList();
            if (Strings.isNullOrEmpty((String)labelValue)) {
                loadJobList.addAll(labelToLoadJobs.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            } else if (accurateMatch) {
                if (!labelToLoadJobs.containsKey(labelValue)) {
                    LinkedList<List<Comparable>> linkedList = loadJobInfos;
                    return linkedList;
                }
                loadJobList.addAll((Collection)labelToLoadJobs.get(labelValue));
            } else {
                PatternMatcher matcher = PatternMatcher.createMysqlPattern(labelValue, CaseSensibility.LABEL.getCaseSensibility());
                for (Map.Entry<String, List<LoadJob>> entry : labelToLoadJobs.entrySet()) {
                    if (!matcher.match(entry.getKey())) continue;
                    loadJobList.addAll((Collection)entry.getValue());
                }
            }
            for (LoadJob loadJob : loadJobList) {
                try {
                    if (!states.contains((Object)loadJob.getState())) continue;
                    loadJobInfos.add(loadJob.getShowInfo());
                }
                catch (DdlException e) {}
            }
            LinkedList<List<Comparable>> linkedList = loadJobInfos;
            return linkedList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLoadJobInfo(Load.JobInfo info) throws DdlException {
        String fullDbName;
        info.dbName = fullDbName = ClusterNamespace.getFullName(info.clusterName, info.dbName);
        Database database = this.checkDb(info.dbName);
        this.readLock();
        try {
            Map<String, List<LoadJob>> labelToLoadJobs = this.dbIdToLabelToLoadJobs.get(database.getId());
            if (labelToLoadJobs == null) {
                throw new DdlException("No jobs belong to database(" + info.dbName + ")");
            }
            List<LoadJob> loadJobList = labelToLoadJobs.get(info.label);
            if (loadJobList == null || loadJobList.isEmpty()) {
                throw new DdlException("Unknown job(" + info.label + ")");
            }
            LoadJob loadJob = loadJobList.get(loadJobList.size() - 1);
            loadJob.getJobInfo(info);
        }
        finally {
            this.readUnlock();
        }
    }

    public LoadJob getLoadJob(long jobId) {
        return this.idToLoadJob.get(jobId);
    }

    public void prepareJobs() {
        this.analyzeLoadJobs();
        this.submitJobs();
    }

    private void submitJobs() {
        this.loadJobScheduler.submitJob(this.idToLoadJob.values().stream().filter(loadJob -> loadJob.state == JobState.PENDING).collect(Collectors.toList()));
    }

    private void analyzeLoadJobs() {
        for (LoadJob loadJob : this.idToLoadJob.values()) {
            if (loadJob.getState() != JobState.PENDING) continue;
            loadJob.analyze();
        }
    }

    private Database checkDb(String dbName) throws DdlException {
        return Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
    }

    private void checkLabelUsed(long dbId, String label) throws DdlException {
        List<LoadJob> labelLoadJobs;
        Optional<LoadJob> loadJobOptional;
        Map<String, List<LoadJob>> labelToLoadJobs;
        Catalog.getCurrentCatalog().getLoadInstance().isLabelUsed(dbId, label);
        if (this.dbIdToLabelToLoadJobs.containsKey(dbId) && (labelToLoadJobs = this.dbIdToLabelToLoadJobs.get(dbId)).containsKey(label) && (loadJobOptional = (labelLoadJobs = labelToLoadJobs.get(label)).stream().filter(entity -> entity.getState() != JobState.CANCELLED).findFirst()).isPresent()) {
            LOG.warn("Failed to add load job when label {} has been used.", (Object)label);
            throw new LabelAlreadyUsedException(label);
        }
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public void initJobProgress(Long jobId, TUniqueId loadId, Set<TUniqueId> fragmentIds, List<Long> relatedBackendIds) {
        LoadJob job = this.idToLoadJob.get(jobId);
        if (job != null) {
            job.initLoadProgress(loadId, fragmentIds, relatedBackendIds);
        }
    }

    public void updateJobProgress(Long jobId, Long beId, TUniqueId loadId, TUniqueId fragmentId, long scannedRows, long scannedBytes, boolean isDone) {
        LoadJob job = this.idToLoadJob.get(jobId);
        if (job != null) {
            job.updateProgress(beId, loadId, fragmentId, scannedRows, scannedBytes, isDone);
        }
    }

    public void write(DataOutput out) throws IOException {
        long currentTimeMs = System.currentTimeMillis();
        List loadJobs = this.idToLoadJob.values().stream().filter(t -> !t.isExpired(currentTimeMs)).collect(Collectors.toList());
        out.writeInt(loadJobs.size());
        for (LoadJob loadJob : loadJobs) {
            loadJob.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        long currentTimeMs = System.currentTimeMillis();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            List jobs;
            LoadJob loadJob = LoadJob.read(in);
            if (loadJob.isExpired(currentTimeMs)) continue;
            if (loadJob.getJobType() == EtlJobType.MINI) {
                TransactionState state;
                if (loadJob.getState() == JobState.LOADING) {
                    LOG.warn("skip mini load job {} in db {} with LOADING state", (Object)loadJob.getId(), (Object)loadJob.getDbId());
                    continue;
                }
                if (loadJob.getState() == JobState.PENDING && (state = Catalog.getCurrentCatalog().getGlobalTransactionMgr().getTransactionState(loadJob.getDbId(), loadJob.getTransactionId())) == null) {
                    LOG.warn("skip mini load job {} in db {} with PENDING state and with txn: {}", (Object)loadJob.getId(), (Object)loadJob.getDbId(), (Object)loadJob.getTransactionId());
                    continue;
                }
            }
            this.idToLoadJob.put(loadJob.getId(), loadJob);
            ConcurrentMap map = this.dbIdToLabelToLoadJobs.get(loadJob.getDbId());
            if (map == null) {
                map = Maps.newConcurrentMap();
                this.dbIdToLabelToLoadJobs.put(loadJob.getDbId(), map);
            }
            if ((jobs = (List)map.get(loadJob.getLabel())) == null) {
                jobs = Lists.newArrayList();
                map.put(loadJob.getLabel(), jobs);
            }
            jobs.add(loadJob);
            if (loadJob.isCompleted()) continue;
            Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().addCallback(loadJob);
        }
    }
}

