/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import java.util.List;
import java.util.UUID;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.Status;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.BrokerLoadJob;
import org.apache.doris.load.loadv2.BrokerLoadingTaskAttachment;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.load.loadv2.LoadTaskCallback;
import org.apache.doris.load.loadv2.LoadingTaskPlanner;
import org.apache.doris.qe.Coordinator;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TQueryType;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.ErrorTabletInfo;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadLoadingTask
extends LoadTask {
    private static final Logger LOG = LogManager.getLogger(LoadLoadingTask.class);
    private TUniqueId loadId;
    private final Database db;
    private final OlapTable table;
    private final BrokerDesc brokerDesc;
    private final List<BrokerFileGroup> fileGroups;
    private final long jobDeadlineMs;
    private final long execMemLimit;
    private final boolean strictMode;
    private final long txnId;
    private final String timezone;
    private final long timeoutS;
    private final int loadParallelism;
    private final int sendBatchParallelism;
    private final boolean loadZeroTolerance;
    private final boolean singleTabletLoadPerSink;
    private LoadingTaskPlanner planner;
    private RuntimeProfile jobProfile;
    private long beginTime;

    public LoadLoadingTask(Database db, OlapTable table, BrokerDesc brokerDesc, List<BrokerFileGroup> fileGroups, long jobDeadlineMs, long execMemLimit, boolean strictMode, long txnId, LoadTaskCallback callback, String timezone, long timeoutS, int loadParallelism, int sendBatchParallelism, boolean loadZeroTolerance, RuntimeProfile profile, boolean singleTabletLoadPerSink) {
        super(callback, LoadTask.TaskType.LOADING);
        this.db = db;
        this.table = table;
        this.brokerDesc = brokerDesc;
        this.fileGroups = fileGroups;
        this.jobDeadlineMs = jobDeadlineMs;
        this.execMemLimit = execMemLimit;
        this.strictMode = strictMode;
        this.txnId = txnId;
        this.failMsg = new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL);
        this.retryTime = 2;
        this.timezone = timezone;
        this.timeoutS = timeoutS;
        this.loadParallelism = loadParallelism;
        this.sendBatchParallelism = sendBatchParallelism;
        this.loadZeroTolerance = loadZeroTolerance;
        this.jobProfile = profile;
        this.singleTabletLoadPerSink = singleTabletLoadPerSink;
    }

    public void init(TUniqueId loadId, List<List<TBrokerFileStatus>> fileStatusList, int fileNum, UserIdentity userInfo) throws UserException {
        this.loadId = loadId;
        this.planner = new LoadingTaskPlanner(this.callback.getCallbackId(), this.txnId, this.db.getId(), this.table, this.brokerDesc, this.fileGroups, this.strictMode, this.timezone, this.timeoutS, this.loadParallelism, this.sendBatchParallelism, userInfo);
        this.planner.plan(loadId, fileStatusList, fileNum);
    }

    public TUniqueId getLoadId() {
        return this.loadId;
    }

    @Override
    protected void executeTask() throws Exception {
        LOG.info("begin to execute loading task. load id: {} job id: {}. db: {}, tbl: {}. left retry: {}", (Object)DebugUtil.printId(this.loadId), (Object)this.callback.getCallbackId(), (Object)this.db.getFullName(), (Object)this.table.getName(), (Object)this.retryTime);
        --this.retryTime;
        this.beginTime = System.nanoTime();
        if (!((BrokerLoadJob)this.callback).updateState(JobState.LOADING)) {
            return;
        }
        this.executeOnce();
    }

    private void executeOnce() throws Exception {
        Coordinator curCoordinator = new Coordinator(this.callback.getCallbackId(), this.loadId, this.planner.getDescTable(), this.planner.getFragments(), this.planner.getScanNodes(), this.planner.getTimezone(), this.loadZeroTolerance);
        curCoordinator.setQueryType(TQueryType.LOAD);
        curCoordinator.setExecMemoryLimit(this.execMemLimit);
        curCoordinator.setLoadMemLimit(this.execMemLimit);
        curCoordinator.setTimeout((int)(this.getLeftTimeMs() / 1000L));
        try {
            QeProcessorImpl.INSTANCE.registerQuery(this.loadId, curCoordinator);
            this.actualExecute(curCoordinator);
        }
        finally {
            QeProcessorImpl.INSTANCE.unregisterQuery(this.loadId);
        }
    }

    private void actualExecute(Coordinator curCoordinator) throws Exception {
        int waitSecond = (int)(this.getLeftTimeMs() / 1000L);
        if (waitSecond <= 0) {
            throw new LoadException("failed to execute plan when the left time is less than 0");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(new LogBuilder(LogKey.LOAD_JOB, this.callback.getCallbackId()).add("task_id", this.signature).add("query_id", DebugUtil.printId(curCoordinator.getQueryId())).add("msg", "begin to execute plan").build());
        }
        curCoordinator.exec();
        if (curCoordinator.join(waitSecond)) {
            Status status = curCoordinator.getExecStatus();
            if (!status.ok()) {
                throw new LoadException(status.getErrorMsg());
            }
        } else {
            throw new LoadException("coordinator could not finished before job timeout");
        }
        this.attachment = new BrokerLoadingTaskAttachment(this.signature, curCoordinator.getLoadCounters(), curCoordinator.getTrackingUrl(), TabletCommitInfo.fromThrift(curCoordinator.getCommitInfos()), ErrorTabletInfo.fromThrift(curCoordinator.getErrorTabletInfos()));
        this.createProfile(curCoordinator);
    }

    private long getLeftTimeMs() {
        return Math.max(this.jobDeadlineMs - System.currentTimeMillis(), 1000L);
    }

    private void createProfile(Coordinator coord) {
        if (this.jobProfile == null) {
            return;
        }
        coord.getQueryProfile().getCounterTotalTime().setValue(TimeUtils.getEstimatedTime(this.beginTime));
        coord.endProfile();
        this.jobProfile.addChild(coord.getQueryProfile());
    }

    @Override
    public void updateRetryInfo() {
        super.updateRetryInfo();
        UUID uuid = UUID.randomUUID();
        this.loadId = new TUniqueId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        this.planner.updateLoadId(this.loadId);
    }
}

