/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import org.apache.doris.common.Config;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.load.loadv2.LoadManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadLoadingChecker
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(LoadLoadingChecker.class);
    private LoadManager loadManager;

    public LoadLoadingChecker(LoadManager loadManager) {
        super("Load loading checker", Config.load_checker_interval_second * 1000);
        this.loadManager = loadManager;
    }

    @Override
    protected void runAfterCatalogReady() {
        try {
            this.loadManager.processLoadingStateJobs();
        }
        catch (Throwable e) {
            LOG.warn("Failed to process one round of LoadLoadingChecker with error message {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

