/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.collect.Queues;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.BrokerLoadJob;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadJobScheduler
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(LoadJobScheduler.class);
    private LinkedBlockingQueue<LoadJob> needScheduleJobs = Queues.newLinkedBlockingQueue();

    public LoadJobScheduler() {
        super("Load job scheduler", Config.load_checker_interval_second * 1000);
    }

    @Override
    protected void runAfterCatalogReady() {
        try {
            this.process();
        }
        catch (Throwable e) {
            LOG.warn("Failed to process one round of LoadJobScheduler with error message {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void process() throws InterruptedException {
        while (!this.needScheduleJobs.isEmpty()) {
            if (this.needScheduleJobs.peek() instanceof BrokerLoadJob && !Catalog.getCurrentCatalog().getLoadingLoadTaskScheduler().hasIdleThread()) {
                LOG.info("Failed to take one broker load job from queue because of loading_load_task_scheduler is full. Waiting for next round. You can try to increase the value of Config.async_loading_load_task_pool_size");
                return;
            }
            LoadJob loadJob = this.needScheduleJobs.poll();
            try {
                loadJob.execute();
                continue;
            }
            catch (LoadException e) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, loadJob.getId()).add("error_msg", "Failed to submit etl job. Job will be cancelled").build(), (Throwable)e);
                loadJob.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.ETL_SUBMIT_FAIL, e.getMessage()), true, true);
                continue;
            }
            catch (RejectedExecutionException e) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, loadJob.getId()).add("error_msg", "Failed to submit etl job. Job queue is full. retry later").build(), (Throwable)e);
                this.needScheduleJobs.put(loadJob);
                return;
            }
            break;
        }
        return;
    }

    public boolean isQueueFull() {
        return this.needScheduleJobs.size() > Config.desired_max_waiting_jobs;
    }

    public void submitJob(LoadJob job) {
        this.needScheduleJobs.add(job);
    }

    public void submitJob(List<LoadJob> jobs) {
        this.needScheduleJobs.addAll(jobs);
    }
}

