/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.EtlStatus;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TxnCommitAttachment;

public class LoadJobFinalOperation
extends TxnCommitAttachment
implements Writable {
    private long id;
    private EtlStatus loadingStatus = new EtlStatus();
    private int progress;
    private long loadStartTimestamp;
    private long finishTimestamp;
    private JobState jobState;
    private FailMsg failMsg;

    public LoadJobFinalOperation() {
        super(TransactionState.LoadJobSourceType.BATCH_LOAD_JOB);
    }

    public LoadJobFinalOperation(long id, EtlStatus loadingStatus, int progress, long loadStartTimestamp, long finishTimestamp, JobState jobState, FailMsg failMsg) {
        super(TransactionState.LoadJobSourceType.BATCH_LOAD_JOB);
        this.id = id;
        this.loadingStatus = loadingStatus;
        this.progress = progress;
        this.loadStartTimestamp = loadStartTimestamp;
        this.finishTimestamp = finishTimestamp;
        this.jobState = jobState;
        this.failMsg = failMsg;
    }

    public long getId() {
        return this.id;
    }

    public EtlStatus getLoadingStatus() {
        return this.loadingStatus;
    }

    public int getProgress() {
        return this.progress;
    }

    public long getLoadStartTimestamp() {
        return this.loadStartTimestamp;
    }

    public long getFinishTimestamp() {
        return this.finishTimestamp;
    }

    public JobState getJobState() {
        return this.jobState;
    }

    public FailMsg getFailMsg() {
        return this.failMsg;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.id);
        this.loadingStatus.write(out);
        out.writeInt(this.progress);
        out.writeLong(this.loadStartTimestamp);
        out.writeLong(this.finishTimestamp);
        Text.writeString((DataOutput)out, (String)this.jobState.name());
        if (this.failMsg == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.failMsg.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.id = in.readLong();
        this.loadingStatus.readFields(in);
        this.progress = in.readInt();
        this.loadStartTimestamp = in.readLong();
        this.finishTimestamp = in.readLong();
        this.jobState = JobState.valueOf(Text.readString((DataInput)in));
        if (in.readBoolean()) {
            this.failMsg = new FailMsg();
            this.failMsg.readFields(in);
        }
    }

    public String toString() {
        return "LoadJobEndOperation{id=" + this.id + ", loadingStatus=" + this.loadingStatus + ", progress=" + this.progress + ", loadStartTimestamp=" + this.loadStartTimestamp + ", finishTimestamp=" + this.finishTimestamp + ", jobState=" + (Object)((Object)this.jobState) + ", failMsg=" + this.failMsg + '}';
    }
}

