/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.analysis.LoadStmt;
import org.apache.doris.catalog.AuthorizationInfo;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.QuotaExceedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.EtlStatus;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.Load;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.loadv2.BrokerLoadJob;
import org.apache.doris.load.loadv2.InsertLoadJob;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.load.loadv2.LoadJobFinalOperation;
import org.apache.doris.load.loadv2.LoadLoadingTask;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.load.loadv2.LoadTaskCallback;
import org.apache.doris.load.loadv2.MiniLoadJob;
import org.apache.doris.load.loadv2.SparkLoadJob;
import org.apache.doris.load.loadv2.TaskAttachment;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.Coordinator;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.thrift.TEtlState;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.AbstractTxnStateChangeCallback;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.ErrorTabletInfo;
import org.apache.doris.transaction.TransactionException;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LoadJob
extends AbstractTxnStateChangeCallback
implements LoadTaskCallback,
Writable {
    private static final Logger LOG = LogManager.getLogger(LoadJob.class);
    protected static final String DPP_NORMAL_ALL = "dpp.norm.ALL";
    protected static final String DPP_ABNORMAL_ALL = "dpp.abnorm.ALL";
    public static final String UNSELECTED_ROWS = "unselected.rows";
    protected long id;
    protected long dbId;
    protected String label;
    protected JobState state = JobState.PENDING;
    protected EtlJobType jobType;
    protected AuthorizationInfo authorizationInfo;
    protected long createTimestamp = System.currentTimeMillis();
    protected long loadStartTimestamp = -1L;
    protected long finishTimestamp = -1L;
    protected long transactionId;
    protected FailMsg failMsg;
    protected Map<Long, LoadTask> idToTasks = Maps.newConcurrentMap();
    protected Set<Long> finishedTaskIds = Sets.newHashSet();
    protected EtlStatus loadingStatus = new EtlStatus();
    protected int progress;
    protected boolean isCommitting = false;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    protected TUniqueId requestId;
    protected LoadStatistic loadStatistic = new LoadStatistic();
    private Map<String, Object> jobProperties = Maps.newHashMap();
    private boolean isJobTypeRead = false;
    protected List<ErrorTabletInfo> errorTabletInfos = Lists.newArrayList();

    public LoadJob(EtlJobType jobType) {
        this.jobType = jobType;
        this.initDefaultJobProperties();
    }

    public LoadJob(EtlJobType jobType, long dbId, String label) {
        this(jobType);
        this.id = Catalog.getCurrentCatalog().getNextId();
        this.dbId = dbId;
        this.label = label;
    }

    protected void readLock() {
        this.lock.readLock().lock();
    }

    protected void readUnlock() {
        this.lock.readLock().unlock();
    }

    protected void writeLock() {
        this.lock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public Database getDb() throws MetaNotFoundException {
        return Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
    }

    public long getDbId() {
        return this.dbId;
    }

    public String getLabel() {
        return this.label;
    }

    public JobState getState() {
        return this.state;
    }

    public EtlJobType getJobType() {
        return this.jobType;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    protected long getDeadlineMs() {
        return this.createTimestamp + this.getTimeout() * 1000L;
    }

    private boolean isTimeout() {
        return System.currentTimeMillis() > this.getDeadlineMs();
    }

    public long getFinishTimestamp() {
        return this.finishTimestamp;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void initLoadProgress(TUniqueId loadId, Set<TUniqueId> fragmentIds, List<Long> relatedBackendIds) {
        this.loadStatistic.initLoad(loadId, fragmentIds, relatedBackendIds);
    }

    public void updateProgress(Long beId, TUniqueId loadId, TUniqueId fragmentId, long scannedRows, long scannedBytes, boolean isDone) {
        this.loadStatistic.updateLoadProgress(beId, loadId, fragmentId, scannedRows, scannedBytes, isDone);
    }

    public void setLoadFileInfo(int fileNum, long fileSize) {
        this.loadStatistic.fileNum = fileNum;
        this.loadStatistic.totalFileSizeB = fileSize;
    }

    public TUniqueId getRequestId() {
        return this.requestId;
    }

    abstract Set<String> getTableNamesForShow();

    abstract Set<String> getTableNames() throws MetaNotFoundException;

    public boolean isTxnDone() {
        return this.state == JobState.COMMITTED || this.state == JobState.FINISHED || this.state == JobState.CANCELLED;
    }

    public boolean isCompleted() {
        return this.state == JobState.FINISHED || this.state == JobState.CANCELLED || this.state == JobState.UNKNOWN;
    }

    public void setJobProperties(Map<String, String> properties) throws DdlException {
        this.initDefaultJobProperties();
        if (ConnectContext.get() != null) {
            this.jobProperties.put("exec_mem_limit", ConnectContext.get().getSessionVariable().getMaxExecMemByte());
            this.jobProperties.put("timezone", ConnectContext.get().getSessionVariable().getTimeZone());
            this.jobProperties.put("send_batch_parallelism", ConnectContext.get().getSessionVariable().getSendBatchParallelism());
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (String key : LoadStmt.PROPERTIES_MAP.keySet()) {
            if (!properties.containsKey(key)) continue;
            try {
                this.jobProperties.put(key, ((Function)LoadStmt.PROPERTIES_MAP.get((Object)key)).apply((Object)properties.get(key)));
            }
            catch (Exception e) {
                throw new DdlException("Failed to set property " + key + ". Error: " + e.getMessage());
            }
        }
    }

    private void initDefaultJobProperties() {
        long timeout = Config.broker_load_default_timeout_second;
        switch (this.jobType) {
            case SPARK: {
                timeout = Config.spark_load_default_timeout_second;
                break;
            }
            case HADOOP: {
                timeout = Config.hadoop_load_default_timeout_second;
                break;
            }
            case BROKER: {
                timeout = Config.broker_load_default_timeout_second;
                break;
            }
            case INSERT: {
                timeout = Config.insert_load_default_timeout_second;
                break;
            }
            case MINI: {
                timeout = Config.stream_load_default_timeout_second;
                break;
            }
        }
        this.jobProperties.put("timeout", timeout);
        this.jobProperties.put("exec_mem_limit", 0x80000000L);
        this.jobProperties.put("max_filter_ratio", 0.0);
        this.jobProperties.put("strict_mode", false);
        this.jobProperties.put("timezone", "Asia/Shanghai");
        this.jobProperties.put("load_parallelism", Config.default_load_parallelism);
        this.jobProperties.put("send_batch_parallelism", 1);
        this.jobProperties.put("load_to_single_tablet", false);
    }

    public void isJobTypeRead(boolean jobTypeRead) {
        this.isJobTypeRead = jobTypeRead;
    }

    public void beginTxn() throws LabelAlreadyUsedException, BeginTransactionException, AnalysisException, DuplicatedRequestException, QuotaExceedException, MetaNotFoundException {
    }

    public void execute() throws LoadException {
        this.writeLock();
        try {
            this.unprotectedExecute();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void unprotectedExecute() throws LoadException {
        if (this.state != JobState.PENDING) {
            return;
        }
        this.unprotectedExecuteJob();
    }

    public void processTimeout() {
        this.writeLock();
        try {
            if (this.state != JobState.PENDING) {
                return;
            }
            if (!this.isTimeout()) {
                return;
            }
            this.unprotectedExecuteCancel(new FailMsg(FailMsg.CancelType.TIMEOUT, "loading timeout to cancel"), false);
            this.logFinalOperation();
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void unprotectedExecuteJob() throws LoadException {
    }

    public boolean updateState(JobState jobState) {
        this.writeLock();
        try {
            boolean bl = this.unprotectedUpdateState(jobState);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected boolean unprotectedUpdateState(JobState jobState) {
        if (this.state.isFinalState()) {
            LOG.warn("the load job {} is in final state: {}, should not update state to {} again", (Object)this.id, (Object)this.state, (Object)jobState);
            return false;
        }
        switch (jobState) {
            case UNKNOWN: {
                this.executeUnknown();
                return true;
            }
            case LOADING: {
                this.executeLoad();
                return true;
            }
            case COMMITTED: {
                this.executeCommitted();
                return true;
            }
            case FINISHED: {
                this.executeFinish();
                return true;
            }
        }
        return false;
    }

    private void executeUnknown() {
        this.finishTimestamp = this.createTimestamp;
        this.state = JobState.UNKNOWN;
    }

    private void executeLoad() {
        this.loadStartTimestamp = System.currentTimeMillis();
        this.state = JobState.LOADING;
    }

    private void executeCommitted() {
        this.state = JobState.COMMITTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobWithoutCheck(FailMsg failMsg, boolean abortTxn, boolean needLog) {
        this.writeLock();
        try {
            this.unprotectedExecuteCancel(failMsg, abortTxn);
            if (needLog) {
                this.logFinalOperation();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void cancelJob(FailMsg failMsg) throws DdlException {
        this.writeLock();
        try {
            this.checkAuth("CANCEL LOAD");
            if (this.jobType == EtlJobType.MINI) {
                throw new DdlException("Job could not be cancelled in type " + this.jobType.name());
            }
            if (this.isCommitting) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("error_msg", "The txn which belongs to job is committing. The job could not be cancelled in this step").build());
                throw new DdlException("Job could not be cancelled while txn is committing");
            }
            if (this.isTxnDone()) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("state", (Object)this.state).add("error_msg", "Job could not be cancelled when job is " + (Object)((Object)this.state)).build());
                throw new DdlException("Job could not be cancelled when job is finished or cancelled");
            }
            this.unprotectedExecuteCancel(failMsg, true);
            this.logFinalOperation();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void checkAuth(String command) throws DdlException {
        if (this.authorizationInfo == null) {
            this.checkAuthWithoutAuthInfo(command);
            return;
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkPrivByAuthInfo(ConnectContext.get(), this.authorizationInfo, PrivPredicate.LOAD)) {
            ErrorReport.reportDdlException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, new Object[]{PaloPrivilege.LOAD_PRIV});
        }
    }

    private void checkAuthWithoutAuthInfo(String command) throws DdlException {
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(this.dbId);
        try {
            Set<String> tableNames = this.getTableNames();
            if (tableNames.isEmpty()) {
                if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), db.getFullName(), PrivPredicate.LOAD)) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, new Object[]{PaloPrivilege.LOAD_PRIV});
                }
            } else {
                for (String tblName : tableNames) {
                    if (Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), db.getFullName(), tblName, PrivPredicate.LOAD)) continue;
                    ErrorReport.reportDdlException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, command, ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), db.getFullName() + ": " + tblName);
                }
            }
        }
        catch (MetaNotFoundException e) {
            throw new DdlException(e.getMessage());
        }
    }

    protected void unprotectedExecuteCancel(FailMsg failMsg, boolean abortTxn) {
        LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("transaction_id", this.transactionId).add("error_msg", "Failed to execute load with error: " + failMsg.getMsg()).build());
        this.loadingStatus.setState(TEtlState.CANCELLED);
        ArrayList loadIds = Lists.newArrayList();
        for (LoadTask loadTask : this.idToTasks.values()) {
            if (!(loadTask instanceof LoadLoadingTask)) continue;
            loadIds.add(((LoadLoadingTask)loadTask).getLoadId());
        }
        this.idToTasks.clear();
        this.failMsg = failMsg;
        this.finishTimestamp = failMsg.getCancelType() == FailMsg.CancelType.TXN_UNKNOWN ? this.createTimestamp : System.currentTimeMillis();
        Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().removeCallback(this.id);
        if (abortTxn) {
            try {
                LOG.debug(new LogBuilder(LogKey.LOAD_JOB, this.id).add("transaction_id", this.transactionId).add("msg", "begin to abort txn").build());
                Catalog.getCurrentGlobalTransactionMgr().abortTransaction(this.dbId, this.transactionId, failMsg.getMsg());
            }
            catch (UserException e) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("transaction_id", this.transactionId).add("error_msg", "failed to abort txn when job is cancelled. " + e.getMessage()).build());
            }
        }
        for (TUniqueId loadId : loadIds) {
            Coordinator coordinator = QeProcessorImpl.INSTANCE.getCoordinator(loadId);
            if (coordinator == null) continue;
            coordinator.cancel();
        }
        this.state = JobState.CANCELLED;
    }

    private void executeFinish() {
        this.progress = 100;
        this.finishTimestamp = System.currentTimeMillis();
        Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().removeCallback(this.id);
        this.state = JobState.FINISHED;
        if (MetricRepo.isInit) {
            MetricRepo.COUNTER_LOAD_FINISHED.increase(1L);
        }
        this.idToTasks.clear();
    }

    protected boolean checkDataQuality() {
        Map<String, String> counters = this.loadingStatus.getCounters();
        if (!counters.containsKey(DPP_NORMAL_ALL) || !counters.containsKey(DPP_ABNORMAL_ALL)) {
            return true;
        }
        long normalNum = Long.parseLong(counters.get(DPP_NORMAL_ALL));
        long abnormalNum = Long.parseLong(counters.get(DPP_ABNORMAL_ALL));
        return !((double)abnormalNum > (double)(abnormalNum + normalNum) * this.getMaxFilterRatio());
    }

    protected void logFinalOperation() {
        Catalog.getCurrentCatalog().getEditLog().logEndLoadJob(new LoadJobFinalOperation(this.id, this.loadingStatus, this.progress, this.loadStartTimestamp, this.finishTimestamp, this.state, this.failMsg));
    }

    public void unprotectReadEndOperation(LoadJobFinalOperation loadJobFinalOperation) {
        this.loadingStatus = loadJobFinalOperation.getLoadingStatus();
        this.progress = loadJobFinalOperation.getProgress();
        this.loadStartTimestamp = loadJobFinalOperation.getLoadStartTimestamp();
        this.finishTimestamp = loadJobFinalOperation.getFinishTimestamp();
        this.state = loadJobFinalOperation.getJobState();
        this.failMsg = loadJobFinalOperation.getFailMsg();
    }

    public List<Comparable> getShowInfo() throws DdlException {
        this.readLock();
        try {
            this.checkAuth("SHOW LOAD");
            ArrayList jobInfo = Lists.newArrayList();
            jobInfo.add(this.id);
            jobInfo.add(this.label);
            jobInfo.add(this.state.name());
            switch (this.state) {
                case PENDING: {
                    jobInfo.add("ETL:0%; LOAD:0%");
                    break;
                }
                case CANCELLED: {
                    jobInfo.add("ETL:N/A; LOAD:N/A");
                    break;
                }
                case ETL: {
                    jobInfo.add("ETL:" + this.progress + "%; LOAD:0%");
                    break;
                }
                default: {
                    jobInfo.add("ETL:100%; LOAD:" + this.progress + "%");
                }
            }
            jobInfo.add(this.jobType);
            if (this.loadingStatus.getCounters().size() == 0) {
                jobInfo.add(FeConstants.null_string);
            } else {
                jobInfo.add(Joiner.on((String)"; ").withKeyValueSeparator("=").join(this.loadingStatus.getCounters()));
            }
            jobInfo.add("cluster:" + this.getResourceName() + "; timeout(s):" + this.getTimeout() + "; max_filter_ratio:" + this.getMaxFilterRatio());
            if (this.failMsg == null) {
                jobInfo.add(FeConstants.null_string);
            } else {
                jobInfo.add("type:" + (Object)((Object)this.failMsg.getCancelType()) + "; msg:" + this.failMsg.getMsg());
            }
            jobInfo.add(TimeUtils.longToTimeString(this.createTimestamp));
            jobInfo.add(TimeUtils.longToTimeString(this.getEtlStartTimestamp()));
            jobInfo.add(TimeUtils.longToTimeString(this.loadStartTimestamp));
            jobInfo.add(TimeUtils.longToTimeString(this.loadStartTimestamp));
            jobInfo.add(TimeUtils.longToTimeString(this.finishTimestamp));
            jobInfo.add(this.loadingStatus.getTrackingUrl());
            jobInfo.add(this.loadStatistic.toJson());
            jobInfo.add(this.transactionId);
            jobInfo.add(this.errorTabletsToJson());
            ArrayList arrayList = jobInfo;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    public String errorTabletsToJson() {
        HashMap map = Maps.newHashMap();
        this.errorTabletInfos.stream().limit(3L).forEach(p -> map.put(p.getTabletId(), p.getMsg()));
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson((Object)map);
    }

    protected String getResourceName() {
        return "N/A";
    }

    protected long getEtlStartTimestamp() {
        return this.loadStartTimestamp;
    }

    public void getJobInfo(Load.JobInfo jobInfo) throws DdlException {
        this.checkAuth("SHOW LOAD");
        jobInfo.tblNames.addAll(this.getTableNamesForShow());
        jobInfo.state = LoadJob.JobState.valueOf(this.state.name());
        jobInfo.failMsg = this.failMsg != null ? this.failMsg.getMsg() : "";
        jobInfo.trackingUrl = this.loadingStatus.getTrackingUrl();
    }

    public static LoadJob read(DataInput in) throws IOException {
        LoadJob job = null;
        EtlJobType type = EtlJobType.valueOf(Text.readString((DataInput)in));
        if (type == EtlJobType.BROKER) {
            job = new BrokerLoadJob();
        } else if (type == EtlJobType.SPARK) {
            job = new SparkLoadJob();
        } else if (type == EtlJobType.INSERT) {
            job = new InsertLoadJob();
        } else if (type == EtlJobType.MINI) {
            job = new MiniLoadJob();
        } else {
            throw new IOException("Unknown load type: " + type.name());
        }
        job.isJobTypeRead(true);
        ((LoadJob)job).readFields(in);
        return job;
    }

    @Override
    public long getCallbackId() {
        return this.id;
    }

    @Override
    public void beforeCommitted(TransactionState txnState) throws TransactionException {
        this.writeLock();
        try {
            if (this.isTxnDone()) {
                throw new TransactionException("txn could not be committed because job is: " + (Object)((Object)this.state));
            }
            this.isCommitting = true;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void afterCommitted(TransactionState txnState, boolean txnOperated) throws UserException {
        if (txnOperated) {
            return;
        }
        this.writeLock();
        try {
            this.isCommitting = false;
            this.state = JobState.COMMITTED;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void replayOnCommitted(TransactionState txnState) {
        this.writeLock();
        try {
            this.replayTxnAttachment(txnState);
            this.transactionId = txnState.getTransactionId();
            this.state = JobState.COMMITTED;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterAborted(TransactionState txnState, boolean txnOperated, String txnStatusChangeReason) throws UserException {
        if (!txnOperated) {
            return;
        }
        this.writeLock();
        try {
            if (this.isTxnDone()) {
                return;
            }
            this.replayTxnAttachment(txnState);
            this.unprotectedExecuteCancel(new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL, txnStatusChangeReason), false);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void replayOnAborted(TransactionState txnState) {
        this.writeLock();
        try {
            this.replayTxnAttachment(txnState);
            this.failMsg = new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL, txnState.getReason());
            this.finishTimestamp = txnState.getFinishTime();
            this.state = JobState.CANCELLED;
            Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().removeCallback(this.id);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void afterVisible(TransactionState txnState, boolean txnOperated) {
        if (!txnOperated) {
            return;
        }
        this.replayTxnAttachment(txnState);
        this.updateState(JobState.FINISHED);
        this.auditFinishedLoadJob();
    }

    @Override
    public void replayOnVisible(TransactionState txnState) {
        this.writeLock();
        try {
            this.replayTxnAttachment(txnState);
            this.progress = 100;
            this.finishTimestamp = txnState.getFinishTime();
            this.state = JobState.FINISHED;
            Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().removeCallback(this.id);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void replayTxnAttachment(TransactionState txnState) {
    }

    @Override
    public void onTaskFinished(TaskAttachment attachment) {
    }

    @Override
    public void onTaskFailed(long taskId, FailMsg failMsg) {
    }

    public void analyze() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadJob other = (LoadJob)obj;
        return this.id == other.id && this.dbId == other.dbId && this.label.equals(other.label) && this.state.equals((Object)other.state) && this.jobType.equals((Object)other.jobType);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.jobType.name());
        out.writeLong(this.id);
        out.writeLong(this.dbId);
        Text.writeString((DataOutput)out, (String)this.label);
        Text.writeString((DataOutput)out, (String)this.state.name());
        out.writeLong(this.createTimestamp);
        out.writeLong(this.loadStartTimestamp);
        out.writeLong(this.finishTimestamp);
        if (this.failMsg == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.failMsg.write(out);
        }
        out.writeInt(this.progress);
        this.loadingStatus.write(out);
        out.writeLong(this.transactionId);
        if (this.authorizationInfo == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.authorizationInfo.write(out);
        }
        out.writeInt(this.jobProperties.size());
        for (Map.Entry<String, Object> entry : this.jobProperties.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)String.valueOf(entry.getValue()));
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (!this.isJobTypeRead) {
            this.jobType = EtlJobType.valueOf(Text.readString((DataInput)in));
            this.isJobTypeRead = true;
        }
        this.id = in.readLong();
        this.dbId = in.readLong();
        this.label = Text.readString((DataInput)in);
        this.state = JobState.valueOf(Text.readString((DataInput)in));
        this.createTimestamp = in.readLong();
        this.loadStartTimestamp = in.readLong();
        this.finishTimestamp = in.readLong();
        if (in.readBoolean()) {
            this.failMsg = new FailMsg();
            this.failMsg.readFields(in);
        }
        this.progress = in.readInt();
        this.loadingStatus.readFields(in);
        this.transactionId = in.readLong();
        if (in.readBoolean()) {
            this.authorizationInfo = new AuthorizationInfo();
            this.authorizationInfo.readFields(in);
        }
        int size = in.readInt();
        HashMap tmpProperties = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String val = Text.readString((DataInput)in);
            tmpProperties.put(key, val);
        }
        try {
            this.setJobProperties(tmpProperties);
        }
        catch (Exception e) {
            throw new IOException("failed to replay job property", e);
        }
    }

    public void replayUpdateStateInfo(LoadJobStateUpdateInfo info) {
        this.state = info.getState();
        this.transactionId = info.getTransactionId();
        this.loadStartTimestamp = info.getLoadStartTimestamp();
    }

    protected void auditFinishedLoadJob() {
    }

    protected long getTimeout() {
        return (Long)this.jobProperties.get("timeout");
    }

    protected void setTimeout(long timeout) {
        this.jobProperties.put("timeout", timeout);
    }

    protected long getExecMemLimit() {
        return (Long)this.jobProperties.get("exec_mem_limit");
    }

    protected double getMaxFilterRatio() {
        return (Double)this.jobProperties.get("max_filter_ratio");
    }

    protected void setMaxFilterRatio(double maxFilterRatio) {
        this.jobProperties.put("max_filter_ratio", maxFilterRatio);
    }

    protected boolean isStrictMode() {
        return (Boolean)this.jobProperties.get("strict_mode");
    }

    protected String getTimeZone() {
        return (String)this.jobProperties.get("timezone");
    }

    public int getLoadParallelism() {
        return (Integer)this.jobProperties.get("load_parallelism");
    }

    public int getSendBatchParallelism() {
        return (Integer)this.jobProperties.get("send_batch_parallelism");
    }

    public boolean isSingleTabletLoadPerSink() {
        return (Boolean)this.jobProperties.get("load_to_single_tablet");
    }

    public boolean isExpired(long currentTimeMs) {
        if (!this.isCompleted()) {
            return false;
        }
        long expireTime = Config.label_keep_max_second;
        if (this.jobType == EtlJobType.INSERT) {
            expireTime = Config.streaming_label_keep_max_second;
        }
        return (currentTimeMs - this.getFinishTimestamp()) / 1000L > expireTime;
    }

    public FailMsg getFailMsg() {
        return this.failMsg;
    }

    public EtlStatus getLoadingStatus() {
        return this.loadingStatus;
    }

    public LoadStatistic getLoadStatistic() {
        return this.loadStatistic;
    }

    public static class LoadJobStateUpdateInfo
    implements Writable {
        @SerializedName(value="jobId")
        private long jobId;
        @SerializedName(value="state")
        private JobState state;
        @SerializedName(value="transactionId")
        private long transactionId;
        @SerializedName(value="loadStartTimestamp")
        private long loadStartTimestamp;

        public LoadJobStateUpdateInfo(long jobId, JobState state, long transactionId, long loadStartTimestamp) {
            this.jobId = jobId;
            this.state = state;
            this.transactionId = transactionId;
            this.loadStartTimestamp = loadStartTimestamp;
        }

        public long getJobId() {
            return this.jobId;
        }

        public JobState getState() {
            return this.state;
        }

        public long getTransactionId() {
            return this.transactionId;
        }

        public long getLoadStartTimestamp() {
            return this.loadStartTimestamp;
        }

        public String toString() {
            return GsonUtils.GSON.toJson((Object)this);
        }

        public void write(DataOutput out) throws IOException {
            String json = GsonUtils.GSON.toJson((Object)this);
            Text.writeString((DataOutput)out, (String)json);
        }

        public static LoadJobStateUpdateInfo read(DataInput in) throws IOException {
            String json = Text.readString((DataInput)in);
            return (LoadJobStateUpdateInfo)GsonUtils.GSON.fromJson(json, LoadJobStateUpdateInfo.class);
        }
    }

    public static class LoadStatistic {
        private Table<TUniqueId, TUniqueId, Long> counterTbl = HashBasedTable.create();
        private Table<TUniqueId, TUniqueId, Long> loadBytes = HashBasedTable.create();
        private Map<TUniqueId, List<Long>> unfinishedBackendIds = Maps.newHashMap();
        private Map<TUniqueId, List<Long>> allBackendIds = Maps.newHashMap();
        public int fileNum = 0;
        public long totalFileSizeB = 0L;

        public synchronized void initLoad(TUniqueId loadId, Set<TUniqueId> fragmentIds, List<Long> relatedBackendIds) {
            this.counterTbl.rowMap().remove(loadId);
            for (TUniqueId fragId : fragmentIds) {
                this.counterTbl.put((Object)loadId, (Object)fragId, (Object)0L);
            }
            this.loadBytes.rowMap().remove(loadId);
            for (TUniqueId fragId : fragmentIds) {
                this.loadBytes.put((Object)loadId, (Object)fragId, (Object)0L);
            }
            this.allBackendIds.put(loadId, relatedBackendIds);
            this.unfinishedBackendIds.put(loadId, Lists.newArrayList(relatedBackendIds));
        }

        public synchronized void removeLoad(TUniqueId loadId) {
            this.counterTbl.rowMap().remove(loadId);
            this.loadBytes.rowMap().remove(loadId);
            this.unfinishedBackendIds.remove(loadId);
            this.allBackendIds.remove(loadId);
        }

        public synchronized void updateLoadProgress(long backendId, TUniqueId loadId, TUniqueId fragmentId, long rows, long bytes, boolean isDone) {
            if (this.counterTbl.contains((Object)loadId, (Object)fragmentId)) {
                this.counterTbl.put((Object)loadId, (Object)fragmentId, (Object)rows);
            }
            if (this.loadBytes.contains((Object)loadId, (Object)fragmentId)) {
                this.loadBytes.put((Object)loadId, (Object)fragmentId, (Object)bytes);
            }
            if (isDone && this.unfinishedBackendIds.containsKey(loadId)) {
                this.unfinishedBackendIds.get(loadId).remove(backendId);
            }
        }

        public synchronized long getScannedRows() {
            long total = 0L;
            Iterator iterator = this.counterTbl.values().iterator();
            while (iterator.hasNext()) {
                long rows = (Long)iterator.next();
                total += rows;
            }
            return total;
        }

        public synchronized long getLoadBytes() {
            long total = 0L;
            Iterator iterator = this.loadBytes.values().iterator();
            while (iterator.hasNext()) {
                long bytes = (Long)iterator.next();
                total += bytes;
            }
            return total;
        }

        public synchronized String toJson() {
            long total = 0L;
            Iterator iterator = this.counterTbl.values().iterator();
            while (iterator.hasNext()) {
                long rows = (Long)iterator.next();
                total += rows;
            }
            long totalBytes = 0L;
            Iterator iterator2 = this.loadBytes.values().iterator();
            while (iterator2.hasNext()) {
                long bytes = (Long)iterator2.next();
                totalBytes += bytes;
            }
            HashMap details = Maps.newHashMap();
            details.put("ScannedRows", total);
            details.put("LoadBytes", totalBytes);
            details.put("FileNumber", this.fileNum);
            details.put("FileSize", this.totalFileSizeB);
            details.put("TaskNumber", this.counterTbl.rowMap().size());
            details.put("Unfinished backends", this.getPrintableMap(this.unfinishedBackendIds));
            details.put("All backends", this.getPrintableMap(this.allBackendIds));
            Gson gson = new Gson();
            return gson.toJson((Object)details);
        }

        private Map<String, List<Long>> getPrintableMap(Map<TUniqueId, List<Long>> map) {
            HashMap newMap = Maps.newHashMap();
            for (Map.Entry<TUniqueId, List<Long>> entry : map.entrySet()) {
                newMap.put(DebugUtil.printId(entry.getKey()), entry.getValue());
            }
            return newMap;
        }
    }
}

