/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.doris.catalog.AuthorizationInfo;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.load.loadv2.LoadJob;

public class InsertLoadJob
extends LoadJob {
    private long tableId;

    public InsertLoadJob() {
        super(EtlJobType.INSERT);
    }

    public InsertLoadJob(String label, long transactionId, long dbId, long tableId, long createTimestamp, String failMsg, String trackingUrl) throws MetaNotFoundException {
        super(EtlJobType.INSERT, dbId, label);
        this.tableId = tableId;
        this.transactionId = transactionId;
        this.createTimestamp = createTimestamp;
        this.loadStartTimestamp = createTimestamp;
        this.finishTimestamp = System.currentTimeMillis();
        if (Strings.isNullOrEmpty((String)failMsg)) {
            this.state = JobState.FINISHED;
            this.progress = 100;
        } else {
            this.state = JobState.CANCELLED;
            this.failMsg = new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL, failMsg);
            this.progress = 0;
        }
        this.authorizationInfo = this.gatherAuthInfo();
        this.loadingStatus.setTrackingUrl(trackingUrl);
    }

    public AuthorizationInfo gatherAuthInfo() throws MetaNotFoundException {
        Database database = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        return new AuthorizationInfo(database.getFullName(), this.getTableNames());
    }

    @Override
    public Set<String> getTableNamesForShow() {
        String name = Catalog.getCurrentCatalog().getDb(this.dbId).flatMap(db -> db.getTable(this.tableId)).map(Table::getName).orElse(String.valueOf(this.tableId));
        return Sets.newHashSet((Object[])new String[]{name});
    }

    @Override
    public Set<String> getTableNames() throws MetaNotFoundException {
        Database database = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        Table table = database.getTableOrMetaException(this.tableId);
        return Sets.newHashSet((Object[])new String[]{table.getName()});
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.tableId);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.tableId = in.readLong();
    }
}

