/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.DataDescription;
import org.apache.doris.analysis.LoadStmt;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.AuthorizationInfo;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.load.BrokerFileGroupAggInfo;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.BrokerLoadJob;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.LoadJobFinalOperation;
import org.apache.doris.load.loadv2.LoadLoadingTask;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.load.loadv2.SparkLoadJob;
import org.apache.doris.plugin.AuditEvent;
import org.apache.doris.plugin.LoadAuditEvent;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.qe.SessionVariable;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BulkLoadJob
extends LoadJob {
    private static final Logger LOG = LogManager.getLogger(BulkLoadJob.class);
    protected BrokerDesc brokerDesc;
    private OriginStatement originStmt;
    private UserIdentity userInfo;
    protected BrokerFileGroupAggInfo fileGroupAggInfo = new BrokerFileGroupAggInfo();
    protected List<TabletCommitInfo> commitInfos = Lists.newArrayList();
    private Map<String, String> sessionVariables = Maps.newHashMap();

    public BulkLoadJob(EtlJobType jobType) {
        super(jobType);
    }

    public BulkLoadJob(EtlJobType jobType, long dbId, String label, OriginStatement originStmt, UserIdentity userInfo) throws MetaNotFoundException {
        super(jobType, dbId, label);
        this.originStmt = originStmt;
        this.authorizationInfo = this.gatherAuthInfo();
        this.userInfo = userInfo;
        if (ConnectContext.get() != null) {
            SessionVariable var = ConnectContext.get().getSessionVariable();
            this.sessionVariables.put("sql_mode", Long.toString(var.getSqlMode()));
        } else {
            this.sessionVariables.put("sql_mode", String.valueOf(0L));
        }
    }

    public static BulkLoadJob fromLoadStmt(LoadStmt stmt) throws DdlException {
        String dbName = stmt.getLabel().getDbName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        try {
            BulkLoadJob bulkLoadJob;
            switch (stmt.getEtlJobType()) {
                case BROKER: {
                    bulkLoadJob = new BrokerLoadJob(db.getId(), stmt.getLabel().getLabelName(), stmt.getBrokerDesc(), stmt.getOrigStmt(), stmt.getUserInfo());
                    break;
                }
                case SPARK: {
                    bulkLoadJob = new SparkLoadJob(db.getId(), stmt.getLabel().getLabelName(), stmt.getResourceDesc(), stmt.getOrigStmt(), stmt.getUserInfo());
                    break;
                }
                case MINI: 
                case DELETE: 
                case HADOOP: 
                case INSERT: {
                    throw new DdlException("LoadManager only support create broker and spark load job from stmt.");
                }
                default: {
                    throw new DdlException("Unknown load job type.");
                }
            }
            bulkLoadJob.setJobProperties(stmt.getProperties());
            bulkLoadJob.checkAndSetDataSourceInfo(db, stmt.getDataDescriptions());
            return bulkLoadJob;
        }
        catch (MetaNotFoundException e) {
            throw new DdlException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSetDataSourceInfo(Database db, List<DataDescription> dataDescriptions) throws DdlException {
        db.readLock();
        try {
            LoadTask.MergeType mergeType = null;
            for (DataDescription dataDescription : dataDescriptions) {
                if (mergeType == null) {
                    mergeType = dataDescription.getMergeType();
                }
                if (mergeType != dataDescription.getMergeType()) {
                    throw new DdlException("merge type in all statement must be the same.");
                }
                BrokerFileGroup fileGroup = new BrokerFileGroup(dataDescription);
                fileGroup.parse(db, dataDescription);
                this.fileGroupAggInfo.addFileGroup(fileGroup);
            }
        }
        finally {
            db.readUnlock();
        }
    }

    private AuthorizationInfo gatherAuthInfo() throws MetaNotFoundException {
        Database database = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        return new AuthorizationInfo(database.getFullName(), this.getTableNames());
    }

    @Override
    public Set<String> getTableNamesForShow() {
        Optional<Database> db = Catalog.getCurrentCatalog().getDb(this.dbId);
        return this.fileGroupAggInfo.getAllTableIds().stream().map(tableId -> db.flatMap(d -> d.getTable((long)tableId)).map(Table::getName).orElse(String.valueOf(tableId))).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getTableNames() throws MetaNotFoundException {
        HashSet result = Sets.newHashSet();
        Database database = Catalog.getCurrentCatalog().getDbOrMetaException(this.dbId);
        for (long tableId : this.fileGroupAggInfo.getAllTableIds()) {
            Table table = database.getTableOrMetaException(tableId);
            result.add(table.getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskFailed(long taskId, FailMsg failMsg) {
        ArrayList retriedTasks = Lists.newArrayList();
        this.writeLock();
        try {
            if (this.isTxnDone()) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("state", (Object)this.state).add("error_msg", "this task will be ignored when job is: " + (Object)((Object)this.state)).build());
                return;
            }
            LoadTask loadTask = (LoadTask)this.idToTasks.get(taskId);
            if (loadTask == null) {
                return;
            }
            if (loadTask.getRetryTime() <= 0) {
                this.unprotectedExecuteCancel(failMsg, true);
                this.logFinalOperation();
                return;
            }
            this.idToTasks.remove(loadTask.getSignature());
            if (loadTask instanceof LoadLoadingTask) {
                this.loadStatistic.removeLoad(((LoadLoadingTask)loadTask).getLoadId());
            }
            loadTask.updateRetryInfo();
            this.idToTasks.put(loadTask.getSignature(), loadTask);
            retriedTasks.add(loadTask);
        }
        finally {
            this.writeUnlock();
        }
        for (LoadTask loadTask : retriedTasks) {
            try {
                if (loadTask.getTaskType() == LoadTask.TaskType.PENDING) {
                    Catalog.getCurrentCatalog().getPendingLoadTaskScheduler().submit(loadTask);
                    continue;
                }
                if (loadTask.getTaskType() != LoadTask.TaskType.LOADING) continue;
                Catalog.getCurrentCatalog().getLoadingLoadTaskScheduler().submit(loadTask);
            }
            catch (RejectedExecutionException e) {
                this.writeLock();
                try {
                    this.unprotectedExecuteCancel(failMsg, true);
                    this.logFinalOperation();
                    return;
                }
                finally {
                    this.writeUnlock();
                }
            }
        }
    }

    @Override
    public void analyze() {
        if (this.originStmt == null || Strings.isNullOrEmpty((String)this.originStmt.originStmt)) {
            return;
        }
        this.fileGroupAggInfo = new BrokerFileGroupAggInfo();
        SqlParser parser = new SqlParser(new SqlScanner(new StringReader(this.originStmt.originStmt), Long.valueOf(this.sessionVariables.get("sql_mode"))));
        try {
            Database db = Catalog.getCurrentCatalog().getDbOrDdlException(this.dbId);
            LoadStmt stmt = (LoadStmt)SqlParserUtils.getStmt(parser, this.originStmt.idx);
            for (DataDescription dataDescription : stmt.getDataDescriptions()) {
                dataDescription.analyzeWithoutCheckPriv(db.getFullName());
            }
            this.checkAndSetDataSourceInfo(db, stmt.getDataDescriptions());
        }
        catch (Exception e) {
            LOG.info(new LogBuilder(LogKey.LOAD_JOB, this.id).add("origin_stmt", this.originStmt).add("msg", "The failure happens in analyze, the load job will be cancelled with error:" + e.getMessage()).build(), (Throwable)e);
            this.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL, e.getMessage()), false, true);
        }
    }

    @Override
    protected void replayTxnAttachment(TransactionState txnState) {
        if (txnState.getTxnCommitAttachment() == null) {
            return;
        }
        this.unprotectReadEndOperation((LoadJobFinalOperation)txnState.getTxnCommitAttachment());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.brokerDesc.write(out);
        this.originStmt.write(out);
        this.userInfo.write(out);
        out.writeInt(this.sessionVariables.size());
        for (Map.Entry<String, String> entry : this.sessionVariables.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.brokerDesc = BrokerDesc.read(in);
        this.originStmt = OriginStatement.read(in);
        this.userInfo = UserIdentity.read(in);
        this.userInfo.setIsAnalyzed();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.sessionVariables.put(key, value);
        }
    }

    public UserIdentity getUserInfo() {
        return this.userInfo;
    }

    @Override
    protected void auditFinishedLoadJob() {
        try {
            String dbName = this.getDb().getFullName();
            String tableListName = StringUtils.join(this.getTableNames(), (String)",");
            ArrayList filePathList = Lists.newArrayList();
            for (List<BrokerFileGroup> brokerFileGroups : this.fileGroupAggInfo.getAggKeyToFileGroups().values()) {
                for (BrokerFileGroup brokerFileGroup : brokerFileGroups) {
                    filePathList.add("(" + StringUtils.join(brokerFileGroup.getFilePaths(), (String)",") + ")");
                }
            }
            String filePathListName = StringUtils.join((Collection)filePathList, (String)",");
            String brokerUserName = this.getBrokerUserName();
            AuditEvent auditEvent = new LoadAuditEvent.AuditEventBuilder().setEventType(AuditEvent.EventType.LOAD_SUCCEED).setJobId(this.id).setLabel(this.label).setLoadType(this.jobType.name()).setDb(dbName).setTableList(tableListName).setFilePathList(filePathListName).setBrokerUser(brokerUserName).setTimestamp(this.createTimestamp).setLoadStartTime(this.loadStartTimestamp).setLoadFinishTime(this.finishTimestamp).setScanRows(this.loadStatistic.getScannedRows()).setScanBytes(this.loadStatistic.totalFileSizeB).setFileNumber(this.loadStatistic.fileNum).build();
            Catalog.getCurrentCatalog().getAuditEventProcessor().handleAuditEvent(auditEvent);
        }
        catch (Exception e) {
            LOG.warn("audit finished load job info failed", (Throwable)e);
        }
    }

    private String getBrokerUserName() {
        Map<String, String> properties = this.brokerDesc.getProperties();
        if (properties.containsKey("kerberos_principal")) {
            return properties.get("kerberos_principal");
        }
        if (properties.containsKey("username")) {
            return properties.get("username");
        }
        if (properties.containsKey("bos_accesskey")) {
            return properties.get("bos_accesskey");
        }
        if (properties.containsKey("fs.s3a.access.key")) {
            return properties.get("fs.s3a.access.key");
        }
        return null;
    }
}

