/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.doris.load.BrokerFileGroupAggInfo;
import org.apache.doris.load.loadv2.TaskAttachment;
import org.apache.doris.thrift.TBrokerFileStatus;

public class BrokerPendingTaskAttachment
extends TaskAttachment {
    private Map<BrokerFileGroupAggInfo.FileGroupAggKey, List<List<TBrokerFileStatus>>> fileStatusMap = Maps.newHashMap();
    private Map<BrokerFileGroupAggInfo.FileGroupAggKey, Integer> fileNumMap = Maps.newHashMap();

    public BrokerPendingTaskAttachment(long taskId) {
        super(taskId);
    }

    public void addFileStatus(BrokerFileGroupAggInfo.FileGroupAggKey aggKey, List<List<TBrokerFileStatus>> fileStatusList) {
        this.fileStatusMap.put(aggKey, fileStatusList);
        this.fileNumMap.put(aggKey, fileStatusList.stream().mapToInt(entity -> entity.size()).sum());
    }

    public List<List<TBrokerFileStatus>> getFileStatusByTable(BrokerFileGroupAggInfo.FileGroupAggKey aggKey) {
        return this.fileStatusMap.get(aggKey);
    }

    public int getFileNumByTable(BrokerFileGroupAggInfo.FileGroupAggKey aggKey) {
        return this.fileNumMap.get(aggKey);
    }
}

