/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.BrokerUtil;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.load.BrokerFileGroupAggInfo;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.BrokerLoadJob;
import org.apache.doris.load.loadv2.BrokerPendingTaskAttachment;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrokerLoadPendingTask
extends LoadTask {
    private static final Logger LOG = LogManager.getLogger(BrokerLoadPendingTask.class);
    private Map<BrokerFileGroupAggInfo.FileGroupAggKey, List<BrokerFileGroup>> aggKeyToBrokerFileGroups;
    private BrokerDesc brokerDesc;

    public BrokerLoadPendingTask(BrokerLoadJob loadTaskCallback, Map<BrokerFileGroupAggInfo.FileGroupAggKey, List<BrokerFileGroup>> aggKeyToBrokerFileGroups, BrokerDesc brokerDesc) {
        super(loadTaskCallback, LoadTask.TaskType.PENDING);
        this.retryTime = 3;
        this.attachment = new BrokerPendingTaskAttachment(this.signature);
        this.aggKeyToBrokerFileGroups = aggKeyToBrokerFileGroups;
        this.brokerDesc = brokerDesc;
        this.failMsg = new FailMsg(FailMsg.CancelType.ETL_RUN_FAIL);
    }

    @Override
    void executeTask() throws UserException {
        LOG.info("begin to execute broker pending task. job: {}", (Object)this.callback.getCallbackId());
        this.getAllFileStatus();
        ((BrokerLoadJob)this.callback).beginTxn();
    }

    private void getAllFileStatus() throws UserException {
        long start = System.currentTimeMillis();
        long totalFileSize = 0L;
        int totalFileNum = 0;
        for (Map.Entry<BrokerFileGroupAggInfo.FileGroupAggKey, List<BrokerFileGroup>> entry : this.aggKeyToBrokerFileGroups.entrySet()) {
            BrokerFileGroupAggInfo.FileGroupAggKey aggKey = entry.getKey();
            List<BrokerFileGroup> fileGroups = entry.getValue();
            ArrayList fileStatusList = Lists.newArrayList();
            long tableTotalFileSize = 0L;
            int tableTotalFileNum = 0;
            int groupNum = 0;
            if (this.brokerDesc.isMultiLoadBroker()) {
                for (BrokerFileGroup fileGroup : fileGroups) {
                    if (fileGroup.getFilePaths().size() != fileGroup.getFileSize().size()) {
                        LOG.warn("Cannot get file size, file path count {}, file size count {}", (Object)fileGroup.getFilePaths().size(), (Object)fileGroup.getFileSize().size());
                        throw new AnalysisException("Cannot get file size.");
                    }
                    ArrayList fileStatuses = Lists.newArrayList();
                    tableTotalFileNum += fileGroup.getFilePaths().size();
                    for (int i = 0; i < fileGroup.getFilePaths().size(); ++i) {
                        tableTotalFileSize += fileGroup.getFileSize().get(i).longValue();
                        TBrokerFileStatus fileStatus = new TBrokerFileStatus(fileGroup.getFilePaths().get(i), false, fileGroup.getFileSize().get(i).longValue(), false);
                        fileStatuses.add(fileStatus);
                    }
                    fileStatusList.add(fileStatuses);
                }
            } else {
                for (BrokerFileGroup fileGroup : fileGroups) {
                    long groupFileSize = 0L;
                    ArrayList fileStatuses = Lists.newArrayList();
                    for (String path : fileGroup.getFilePaths()) {
                        BrokerUtil.parseFile(path, this.brokerDesc, fileStatuses);
                    }
                    boolean isBinaryFileFormat = fileGroup.isBinaryFileFormat();
                    ArrayList filteredFileStatuses = Lists.newArrayList();
                    for (TBrokerFileStatus fstatus : fileStatuses) {
                        if (fstatus.getSize() == 0L && isBinaryFileFormat) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug(new LogBuilder(LogKey.LOAD_JOB, this.callback.getCallbackId()).add("empty file", fstatus).build());
                            continue;
                        }
                        groupFileSize += fstatus.size;
                        filteredFileStatuses.add(fstatus);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(new LogBuilder(LogKey.LOAD_JOB, this.callback.getCallbackId()).add("file_status", fstatus).build());
                    }
                    fileStatusList.add(filteredFileStatuses);
                    tableTotalFileSize += groupFileSize;
                    tableTotalFileNum += filteredFileStatuses.size();
                    LOG.info("get {} files in file group {} for table {}. size: {}. job: {}, broker: {} ", (Object)filteredFileStatuses.size(), (Object)groupNum, (Object)entry.getKey(), (Object)groupFileSize, (Object)this.callback.getCallbackId(), this.brokerDesc.getStorageType() == StorageBackend.StorageType.BROKER ? BrokerUtil.getAddress(this.brokerDesc) : this.brokerDesc.getStorageType());
                    ++groupNum;
                }
            }
            totalFileSize += tableTotalFileSize;
            totalFileNum += tableTotalFileNum;
            ((BrokerPendingTaskAttachment)this.attachment).addFileStatus(aggKey, fileStatusList);
            LOG.info("get {} files to be loaded. total size: {}. cost: {} ms, job: {}", (Object)tableTotalFileNum, (Object)tableTotalFileSize, (Object)(System.currentTimeMillis() - start), (Object)this.callback.getCallbackId());
        }
        ((BrokerLoadJob)this.callback).setLoadFileInfo(totalFileNum, totalFileSize);
    }
}

