/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.QuotaExceedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.common.util.ProfileManager;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.load.BrokerFileGroupAggInfo;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.loadv2.BrokerLoadPendingTask;
import org.apache.doris.load.loadv2.BrokerLoadingTaskAttachment;
import org.apache.doris.load.loadv2.BrokerPendingTaskAttachment;
import org.apache.doris.load.loadv2.BulkLoadJob;
import org.apache.doris.load.loadv2.LoadJobFinalOperation;
import org.apache.doris.load.loadv2.LoadLoadingTask;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.load.loadv2.TaskAttachment;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.BeginTransactionException;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrokerLoadJob
extends BulkLoadJob {
    private static final Logger LOG = LogManager.getLogger(BrokerLoadJob.class);
    private RuntimeProfile jobProfile;
    private boolean enableProfile = false;

    public BrokerLoadJob() {
        super(EtlJobType.BROKER);
    }

    public BrokerLoadJob(long dbId, String label, BrokerDesc brokerDesc, OriginStatement originStmt, UserIdentity userInfo) throws MetaNotFoundException {
        super(EtlJobType.BROKER, dbId, label, originStmt, userInfo);
        this.brokerDesc = brokerDesc;
        if (ConnectContext.get() != null && ConnectContext.get().getSessionVariable().enableProfile()) {
            this.enableProfile = true;
        }
    }

    @Override
    public void beginTxn() throws LabelAlreadyUsedException, BeginTransactionException, AnalysisException, DuplicatedRequestException, QuotaExceedException, MetaNotFoundException {
        MetricRepo.COUNTER_LOAD_ADD.increase(1L);
        this.transactionId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(this.dbId, Lists.newArrayList(this.fileGroupAggInfo.getAllTableIds()), this.label, null, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), TransactionState.LoadJobSourceType.BATCH_LOAD_JOB, this.id, this.getTimeout());
    }

    @Override
    protected void unprotectedExecuteJob() {
        BrokerLoadPendingTask task = new BrokerLoadPendingTask(this, this.fileGroupAggInfo.getAggKeyToFileGroups(), this.brokerDesc);
        this.idToTasks.put(task.getSignature(), task);
        Catalog.getCurrentCatalog().getPendingLoadTaskScheduler().submit(task);
    }

    @Override
    public void onTaskFinished(TaskAttachment attachment) {
        if (attachment instanceof BrokerPendingTaskAttachment) {
            this.onPendingTaskFinished((BrokerPendingTaskAttachment)attachment);
        } else if (attachment instanceof BrokerLoadingTaskAttachment) {
            this.onLoadingTaskFinished((BrokerLoadingTaskAttachment)attachment);
        }
    }

    private void onPendingTaskFinished(BrokerPendingTaskAttachment attachment) {
        this.writeLock();
        try {
            if (this.isTxnDone()) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("state", (Object)this.state).add("error_msg", "this task will be ignored when job is: " + (Object)((Object)this.state)).build());
                return;
            }
            if (this.finishedTaskIds.contains(attachment.getTaskId())) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("task_id", attachment.getTaskId()).add("error_msg", "this is a duplicated callback of pending task when broker already has loading task").build());
                return;
            }
            this.finishedTaskIds.add(attachment.getTaskId());
        }
        finally {
            this.writeUnlock();
        }
        try {
            Database db = this.getDb();
            this.createLoadingTask(db, attachment);
        }
        catch (UserException e) {
            LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("database_id", this.dbId).add("error_msg", "Failed to divide job into loading task.").build(), (Throwable)e);
            this.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.ETL_RUN_FAIL, e.getMessage()), true, true);
            return;
        }
        catch (RejectedExecutionException e) {
            LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("database_id", this.dbId).add("error_msg", "the task queque is full.").build(), (Throwable)e);
            this.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.ETL_RUN_FAIL, e.getMessage()), true, true);
            return;
        }
        this.loadStartTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLoadingTask(Database db, BrokerPendingTaskAttachment attachment) throws UserException {
        List<Table> tableList = db.getTablesOnIdOrderOrThrowException(Lists.newArrayList(this.fileGroupAggInfo.getAllTableIds()));
        ArrayList newLoadingTasks = Lists.newArrayList();
        this.jobProfile = new RuntimeProfile("BrokerLoadJob " + this.id + ". " + this.label);
        MetaLockUtils.readLockTables(tableList);
        try {
            for (Map.Entry<BrokerFileGroupAggInfo.FileGroupAggKey, List<BrokerFileGroup>> entry : this.fileGroupAggInfo.getAggKeyToFileGroups().entrySet()) {
                BrokerFileGroupAggInfo.FileGroupAggKey aggKey = entry.getKey();
                List<BrokerFileGroup> brokerFileGroups = entry.getValue();
                long tableId = aggKey.getTableId();
                OlapTable table = (OlapTable)db.getTableNullable(tableId);
                LoadLoadingTask task = new LoadLoadingTask(db, table, this.brokerDesc, brokerFileGroups, this.getDeadlineMs(), this.getExecMemLimit(), this.isStrictMode(), this.transactionId, this, this.getTimeZone(), this.getTimeout(), this.getLoadParallelism(), this.getSendBatchParallelism(), this.getMaxFilterRatio() <= 0.0, this.enableProfile ? this.jobProfile : null, this.isSingleTabletLoadPerSink());
                UUID uuid = UUID.randomUUID();
                TUniqueId loadId = new TUniqueId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                task.init(loadId, attachment.getFileStatusByTable(aggKey), attachment.getFileNumByTable(aggKey), this.getUserInfo());
                this.idToTasks.put(task.getSignature(), task);
                newLoadingTasks.add(task);
                TransactionState txnState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(this.dbId, this.transactionId);
                if (txnState == null) {
                    throw new UserException("txn does not exist: " + this.transactionId);
                }
                txnState.addTableIndexes(table);
            }
        }
        finally {
            MetaLockUtils.readUnlockTables(tableList);
        }
        for (LoadTask loadTask : newLoadingTasks) {
            Catalog.getCurrentCatalog().getLoadingLoadTaskScheduler().submit(loadTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLoadingTaskFinished(BrokerLoadingTaskAttachment attachment) {
        this.writeLock();
        try {
            if (this.isTxnDone()) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("state", (Object)this.state).add("error_msg", "this task will be ignored when job is: " + (Object)((Object)this.state)).build());
                return;
            }
            if (this.finishedTaskIds.contains(attachment.getTaskId())) {
                LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("task_id", attachment.getTaskId()).add("error_msg", "this is a duplicated callback of loading task").build());
                return;
            }
            this.finishedTaskIds.add(attachment.getTaskId());
            this.updateLoadingStatus(attachment);
            if (this.finishedTaskIds.size() != this.idToTasks.size()) {
                return;
            }
        }
        finally {
            this.writeUnlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(new LogBuilder(LogKey.LOAD_JOB, this.id).add("commit_infos", Joiner.on((String)",").join((Iterable)this.commitInfos)).build());
        }
        if (!this.checkDataQuality()) {
            this.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.ETL_QUALITY_UNSATISFIED, "quality not good enough to cancel"), true, true);
            return;
        }
        Database db = null;
        List<Table> tableList = null;
        try {
            db = this.getDb();
            tableList = db.getTablesOnIdOrderOrThrowException(Lists.newArrayList(this.fileGroupAggInfo.getAllTableIds()));
            MetaLockUtils.writeLockTablesOrMetaException(tableList);
        }
        catch (MetaNotFoundException e) {
            LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("database_id", this.dbId).add("error_msg", "db has been deleted when job is loading").build(), (Throwable)e);
            this.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL, e.getMessage()), true, true);
            return;
        }
        try {
            LOG.info(new LogBuilder(LogKey.LOAD_JOB, this.id).add("txn_id", this.transactionId).add("msg", "Load job try to commit txn").build());
            MetricRepo.COUNTER_LOAD_FINISHED.increase(1L);
            Catalog.getCurrentGlobalTransactionMgr().commitTransaction(this.dbId, tableList, this.transactionId, this.commitInfos, new LoadJobFinalOperation(this.id, this.loadingStatus, this.progress, this.loadStartTimestamp, this.finishTimestamp, this.state, this.failMsg));
        }
        catch (UserException e) {
            LOG.warn(new LogBuilder(LogKey.LOAD_JOB, this.id).add("database_id", this.dbId).add("error_msg", "Failed to commit txn with error:" + e.getMessage()).build(), (Throwable)e);
            this.cancelJobWithoutCheck(new FailMsg(FailMsg.CancelType.LOAD_RUN_FAIL, e.getMessage()), true, true);
        }
        finally {
            MetaLockUtils.writeUnlockTables(tableList);
        }
    }

    private void writeProfile() {
        if (!this.enableProfile) {
            return;
        }
        RuntimeProfile summaryProfile = new RuntimeProfile("Summary");
        summaryProfile.addInfoString("Query ID", String.valueOf(this.id));
        summaryProfile.addInfoString("Start Time", TimeUtils.longToTimeString(this.createTimestamp));
        summaryProfile.addInfoString("End Time", TimeUtils.longToTimeString(this.finishTimestamp));
        summaryProfile.addInfoString("Total", DebugUtil.getPrettyStringMs(this.finishTimestamp - this.createTimestamp));
        summaryProfile.addInfoString("Query Type", "Load");
        summaryProfile.addInfoString("Query State", "N/A");
        summaryProfile.addInfoString("User", "N/A");
        summaryProfile.addInfoString("Default Db", "N/A");
        summaryProfile.addInfoString("Sql Statement", "N/A");
        summaryProfile.addInfoString("Is Cached", "N/A");
        this.jobProfile.addFirstChild(summaryProfile);
        this.jobProfile.computeTimeInChildProfile();
        ProfileManager.getInstance().pushProfile(this.jobProfile);
    }

    private void updateLoadingStatus(BrokerLoadingTaskAttachment attachment) {
        this.loadingStatus.replaceCounter("dpp.abnorm.ALL", this.increaseCounter("dpp.abnorm.ALL", attachment.getCounter("dpp.abnorm.ALL")));
        this.loadingStatus.replaceCounter("dpp.norm.ALL", this.increaseCounter("dpp.norm.ALL", attachment.getCounter("dpp.norm.ALL")));
        this.loadingStatus.replaceCounter("unselected.rows", this.increaseCounter("unselected.rows", attachment.getCounter("unselected.rows")));
        if (attachment.getTrackingUrl() != null) {
            this.loadingStatus.setTrackingUrl(attachment.getTrackingUrl());
        }
        this.commitInfos.addAll(attachment.getCommitInfoList());
        this.errorTabletInfos.addAll(attachment.getErrorTabletInfos());
        this.progress = (int)((double)this.finishedTaskIds.size() / (double)this.idToTasks.size() * 100.0);
        if (this.progress == 100) {
            this.progress = 99;
        }
    }

    @Override
    public void updateProgress(Long beId, TUniqueId loadId, TUniqueId fragmentId, long scannedRows, long scannedBytes, boolean isDone) {
        super.updateProgress(beId, loadId, fragmentId, scannedRows, scannedBytes, isDone);
        this.progress = (int)((double)this.loadStatistic.getLoadBytes() / (double)this.loadStatistic.totalFileSizeB * 100.0);
        if (this.progress >= 100) {
            this.progress = 99;
        }
    }

    private String increaseCounter(String key, String deltaValue) {
        long value = 0L;
        if (this.loadingStatus.getCounters().containsKey(key)) {
            value = Long.valueOf(this.loadingStatus.getCounters().get(key));
        }
        if (deltaValue != null) {
            value += Long.valueOf(deltaValue).longValue();
        }
        return String.valueOf(value);
    }

    @Override
    public void afterVisible(TransactionState txnState, boolean txnOperated) {
        super.afterVisible(txnState, txnOperated);
        this.writeProfile();
    }
}

