/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class TabletLoadInfo
implements Writable {
    private String filePath;
    private long fileSize;
    private Set<Long> sentReplicas;

    public TabletLoadInfo() {
        this("", -1L);
    }

    public TabletLoadInfo(String filePath, long fileSize) {
        this.filePath = filePath;
        this.fileSize = fileSize;
        this.sentReplicas = new HashSet<Long>();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean addSentReplica(long replicaId) {
        this.sentReplicas.add(replicaId);
        return true;
    }

    public boolean isReplicaSent(long replicaId) {
        return this.sentReplicas.contains(replicaId);
    }

    public void write(DataOutput out) throws IOException {
        if (this.filePath == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.filePath);
            out.writeLong(this.fileSize);
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.filePath = Text.readString((DataInput)in).intern();
            this.fileSize = in.readLong();
        } else {
            this.filePath = null;
            this.fileSize = -1L;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TabletLoadInfo)) {
            return false;
        }
        TabletLoadInfo info = (TabletLoadInfo)obj;
        if (this.sentReplicas != info.sentReplicas) {
            if (this.sentReplicas == null || info.sentReplicas == null) {
                return false;
            }
            if (this.sentReplicas.size() != info.sentReplicas.size()) {
                return false;
            }
            for (long id : this.sentReplicas) {
                if (info.sentReplicas.contains(id)) continue;
                return false;
            }
        }
        if (this.filePath != info.filePath && (this.filePath == null || info.filePath == null)) {
            return false;
        }
        return this.filePath.equals(info.filePath);
    }

    public int hashCode() {
        int ret = this.filePath.length();
        return ret;
    }
}

