/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.PartitionLoadInfo;

public class TableLoadInfo
implements Writable {
    private Map<Long, PartitionLoadInfo> idToPartitionLoadInfo;
    private Map<Long, Integer> indexIdToSchemaHash;

    public TableLoadInfo() {
        this(new HashMap<Long, PartitionLoadInfo>());
    }

    public TableLoadInfo(Map<Long, PartitionLoadInfo> idToPartitionLoadInfo) {
        this.idToPartitionLoadInfo = idToPartitionLoadInfo;
        this.indexIdToSchemaHash = Maps.newHashMap();
    }

    public boolean containsIndex(long indexId) {
        return this.indexIdToSchemaHash.containsKey(indexId);
    }

    public Map<Long, PartitionLoadInfo> getIdToPartitionLoadInfo() {
        return this.idToPartitionLoadInfo;
    }

    public PartitionLoadInfo getPartitionLoadInfo(long partitionId) {
        return this.idToPartitionLoadInfo.get(partitionId);
    }

    public void addIndexSchemaHash(long indexId, int schemaHash) {
        this.indexIdToSchemaHash.put(indexId, schemaHash);
    }

    public void addAllSchemaHash(Map<Long, Integer> m) {
        this.indexIdToSchemaHash.putAll(m);
    }

    public int getIndexSchemaHash(long indexId) {
        if (this.indexIdToSchemaHash.containsKey(indexId)) {
            return this.indexIdToSchemaHash.get(indexId);
        }
        return -1;
    }

    public void write(DataOutput out) throws IOException {
        int count = this.idToPartitionLoadInfo.size();
        out.writeInt(count);
        for (Map.Entry<Long, PartitionLoadInfo> entry : this.idToPartitionLoadInfo.entrySet()) {
            out.writeLong(entry.getKey());
            entry.getValue().write(out);
        }
        count = this.indexIdToSchemaHash.size();
        out.writeInt(count);
        for (Map.Entry<Long, Object> entry : this.indexIdToSchemaHash.entrySet()) {
            out.writeLong(entry.getKey());
            out.writeInt((Integer)entry.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        long key;
        int i;
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            key = in.readLong();
            PartitionLoadInfo value = new PartitionLoadInfo();
            value.readFields(in);
            this.idToPartitionLoadInfo.put(key, value);
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            key = in.readLong();
            int value = in.readInt();
            this.indexIdToSchemaHash.put(key, value);
        }
    }

    public int hashCode() {
        return this.idToPartitionLoadInfo.size() ^ this.indexIdToSchemaHash.size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TableLoadInfo)) {
            return false;
        }
        TableLoadInfo tableLoadInfo = (TableLoadInfo)obj;
        if (this.idToPartitionLoadInfo != tableLoadInfo.idToPartitionLoadInfo) {
            if (this.idToPartitionLoadInfo.size() != tableLoadInfo.idToPartitionLoadInfo.size()) {
                return false;
            }
            for (Map.Entry<Long, PartitionLoadInfo> entry : this.idToPartitionLoadInfo.entrySet()) {
                long key = entry.getKey();
                if (!tableLoadInfo.idToPartitionLoadInfo.containsKey(key)) {
                    return false;
                }
                if (entry.getValue().equals(tableLoadInfo.idToPartitionLoadInfo.get(key))) continue;
                return false;
            }
        }
        if (this.indexIdToSchemaHash != tableLoadInfo.indexIdToSchemaHash) {
            if (this.indexIdToSchemaHash.size() != tableLoadInfo.indexIdToSchemaHash.size()) {
                return false;
            }
            for (Map.Entry<Long, Object> entry : this.indexIdToSchemaHash.entrySet()) {
                if (!tableLoadInfo.indexIdToSchemaHash.containsKey(entry.getKey())) {
                    return false;
                }
                if (entry.getValue() == tableLoadInfo.indexIdToSchemaHash.get(entry.getKey())) continue;
                return false;
            }
        }
        return true;
    }
}

