/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.doris.analysis.ShowStreamLoadStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Config;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.StreamLoadRecord;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.plugin.AuditEvent;
import org.apache.doris.plugin.StreamLoadAuditEvent;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TStreamLoadRecord;
import org.apache.doris.thrift.TStreamLoadRecordResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamLoadRecordMgr
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(StreamLoadRecordMgr.class);
    Queue<StreamLoadItem> streamLoadRecordHeap = new PriorityQueue<StreamLoadItem>(new StreamLoadComparator());
    private Map<Long, Map<String, StreamLoadRecord>> dbIdToLabelToStreamLoadRecord = Maps.newConcurrentMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public StreamLoadRecordMgr(String name, long intervalMs) {
        super(name, intervalMs);
    }

    public void addStreamLoadRecord(long dbId, String label, StreamLoadRecord streamLoadRecord) {
        Map<String, StreamLoadRecord> labelToStreamLoadRecord;
        StreamLoadItem record;
        this.writeLock();
        block0: while (this.isQueueFull()) {
            record = this.streamLoadRecordHeap.poll();
            if (record == null) continue;
            String de_label = record.getLabel();
            long de_dbId = record.getDbId();
            Map<String, StreamLoadRecord> labelToStreamLoadRecord2 = this.dbIdToLabelToStreamLoadRecord.get(de_dbId);
            Iterator<Map.Entry<String, StreamLoadRecord>> iter_record = labelToStreamLoadRecord2.entrySet().iterator();
            while (iter_record.hasNext()) {
                String labelInMap = iter_record.next().getKey();
                if (!labelInMap.equals(de_label)) continue;
                iter_record.remove();
                continue block0;
            }
        }
        record = new StreamLoadItem(label, dbId, streamLoadRecord.getFinishTime());
        this.streamLoadRecordHeap.offer(record);
        if (!this.dbIdToLabelToStreamLoadRecord.containsKey(dbId)) {
            this.dbIdToLabelToStreamLoadRecord.put(dbId, new ConcurrentHashMap());
        }
        if (!(labelToStreamLoadRecord = this.dbIdToLabelToStreamLoadRecord.get(dbId)).containsKey(label)) {
            labelToStreamLoadRecord.put(label, streamLoadRecord);
        }
        this.writeUnlock();
    }

    public List<StreamLoadItem> getStreamLoadRecords() {
        return new ArrayList<StreamLoadItem>(this.streamLoadRecordHeap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Comparable>> getStreamLoadRecordByDb(long dbId, String label, boolean accurateMatch, ShowStreamLoadStmt.StreamLoadState state) {
        LinkedList<List<Comparable>> streamLoadRecords = new LinkedList<List<Comparable>>();
        this.readLock();
        try {
            if (!this.dbIdToLabelToStreamLoadRecord.containsKey(dbId)) {
                LinkedList<List<Comparable>> linkedList = streamLoadRecords;
                return linkedList;
            }
            ArrayList streamLoadRecordList = Lists.newArrayList();
            Map<String, StreamLoadRecord> labelToStreamLoadRecord = this.dbIdToLabelToStreamLoadRecord.get(dbId);
            if (Strings.isNullOrEmpty((String)label)) {
                streamLoadRecordList.addAll(labelToStreamLoadRecord.values().stream().collect(Collectors.toList()));
            } else if (accurateMatch) {
                if (!labelToStreamLoadRecord.containsKey(label)) {
                    LinkedList<List<Comparable>> linkedList = streamLoadRecords;
                    return linkedList;
                }
                streamLoadRecordList.add(labelToStreamLoadRecord.get(label));
            } else {
                for (Map.Entry<String, StreamLoadRecord> entry : labelToStreamLoadRecord.entrySet()) {
                    if (!entry.getKey().contains(label)) continue;
                    streamLoadRecordList.add(entry.getValue());
                }
            }
            for (StreamLoadRecord streamLoadRecord : streamLoadRecordList) {
                try {
                    if (state != null && !String.valueOf((Object)state).equalsIgnoreCase(streamLoadRecord.getStatus())) continue;
                    streamLoadRecords.add(streamLoadRecord.getStreamLoadInfo());
                }
                catch (Exception e) {}
            }
            LinkedList<List<Comparable>> linkedList = streamLoadRecords;
            return linkedList;
        }
        finally {
            this.readUnlock();
        }
    }

    public void clearStreamLoadRecord() {
        this.writeLock();
        if (this.streamLoadRecordHeap.size() > 0 || this.dbIdToLabelToStreamLoadRecord.size() > 0) {
            this.streamLoadRecordHeap.clear();
            this.dbIdToLabelToStreamLoadRecord.clear();
        }
        this.writeUnlock();
    }

    public boolean isQueueFull() {
        return this.streamLoadRecordHeap.size() >= Config.max_stream_load_record_size;
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runAfterCatalogReady() {
        ImmutableMap<Long, Backend> backends = Catalog.getCurrentSystemInfo().getIdToBackend();
        long start = System.currentTimeMillis();
        int pullRecordSize = 0;
        HashMap beIdToLastStreamLoad = Maps.newHashMap();
        for (Backend backend : backends.values()) {
            BackendService.Client client = null;
            TNetworkAddress address = null;
            boolean ok = false;
            try {
                address = new TNetworkAddress(backend.getHost(), backend.getBePort());
                client = ClientPool.backendPool.borrowObject(address);
                TStreamLoadRecordResult result = client.getStreamLoadRecord(backend.getLastStreamLoadTime());
                Map streamLoadRecordBatch = result.getStreamLoadRecord();
                pullRecordSize += streamLoadRecordBatch.size();
                long lastStreamLoadTime = -1L;
                for (Map.Entry entry : streamLoadRecordBatch.entrySet()) {
                    TStreamLoadRecord streamLoadItem = (TStreamLoadRecord)entry.getValue();
                    String startTime = TimeUtils.longToTimeString(streamLoadItem.getStartTime(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                    String finishTime = TimeUtils.longToTimeString(streamLoadItem.getFinishTime(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("receive stream load record info from backend: {}. label: {}, db: {}, tbl: {}, user: {}, user_ip: {}, status: {}, message: {}, error_url: {}, total_rows: {}, loaded_rows: {}, filtered_rows: {}, unselected_rows: {}, load_bytes: {}, start_time: {}, finish_time: {}.", new Object[]{backend.getHost(), streamLoadItem.getLabel(), streamLoadItem.getDb(), streamLoadItem.getTbl(), streamLoadItem.getUser(), streamLoadItem.getUserIp(), streamLoadItem.getStatus(), streamLoadItem.getMessage(), streamLoadItem.getUrl(), streamLoadItem.getTotalRows(), streamLoadItem.getLoadedRows(), streamLoadItem.getFilteredRows(), streamLoadItem.getUnselectedRows(), streamLoadItem.getLoadBytes(), startTime, finishTime});
                    }
                    AuditEvent auditEvent = new StreamLoadAuditEvent.AuditEventBuilder().setEventType(AuditEvent.EventType.STREAM_LOAD_FINISH).setLabel(streamLoadItem.getLabel()).setDb(streamLoadItem.getDb()).setTable(streamLoadItem.getTbl()).setUser(streamLoadItem.getUser()).setClientIp(streamLoadItem.getUserIp()).setStatus(streamLoadItem.getStatus()).setMessage(streamLoadItem.getMessage()).setUrl(streamLoadItem.getUrl()).setTotalRows(streamLoadItem.getTotalRows()).setLoadedRows(streamLoadItem.getLoadedRows()).setFilteredRows(streamLoadItem.getFilteredRows()).setUnselectedRows(streamLoadItem.getUnselectedRows()).setLoadBytes(streamLoadItem.getLoadBytes()).setStartTime(startTime).setFinishTime(finishTime).build();
                    Catalog.getCurrentCatalog().getAuditEventProcessor().handleAuditEvent(auditEvent);
                    if (((TStreamLoadRecord)entry.getValue()).getFinishTime() > lastStreamLoadTime) {
                        lastStreamLoadTime = ((TStreamLoadRecord)entry.getValue()).getFinishTime();
                    }
                    if (Config.disable_show_stream_load) continue;
                    StreamLoadRecord streamLoadRecord = new StreamLoadRecord(streamLoadItem.getLabel(), streamLoadItem.getDb(), streamLoadItem.getTbl(), streamLoadItem.getUser(), streamLoadItem.getUserIp(), streamLoadItem.getStatus(), streamLoadItem.getMessage(), streamLoadItem.getUrl(), String.valueOf(streamLoadItem.getTotalRows()), String.valueOf(streamLoadItem.getLoadedRows()), String.valueOf(streamLoadItem.getFilteredRows()), String.valueOf(streamLoadItem.getUnselectedRows()), String.valueOf(streamLoadItem.getLoadBytes()), startTime, finishTime);
                    String cluster = streamLoadItem.getCluster();
                    if (Strings.isNullOrEmpty((String)cluster)) {
                        cluster = "default_cluster";
                    }
                    String fullDbName = ClusterNamespace.getFullName(cluster, streamLoadItem.getDb());
                    Database db = Catalog.getCurrentCatalog().getDbNullable(fullDbName);
                    if (db == null) {
                        String dbName = fullDbName;
                        if (Strings.isNullOrEmpty((String)streamLoadItem.getCluster())) {
                            dbName = streamLoadItem.getDb();
                        }
                        throw new UserException("unknown database, database=" + dbName);
                    }
                    long dbId = db.getId();
                    Catalog.getCurrentCatalog().getStreamLoadRecordMgr().addStreamLoadRecord(dbId, streamLoadItem.getLabel(), streamLoadRecord);
                }
                if (streamLoadRecordBatch.size() > 0) {
                    backend.setLastStreamLoadTime(lastStreamLoadTime);
                    beIdToLastStreamLoad.put(backend.getId(), lastStreamLoadTime);
                } else {
                    beIdToLastStreamLoad.put(backend.getId(), backend.getLastStreamLoadTime());
                }
                ok = true;
                if (ok) {
                    ClientPool.backendPool.returnObject(address, client);
                    continue;
                }
                ClientPool.backendPool.invalidateObject(address, client);
            }
            catch (Exception e) {
                try {
                    LOG.warn("task exec error. backend[{}]", (Object)backend.getId(), (Object)e);
                    if (ok) {
                        ClientPool.backendPool.returnObject(address, client);
                        continue;
                    }
                    ClientPool.backendPool.invalidateObject(address, client);
                }
                catch (Throwable throwable) {
                    if (ok) {
                        ClientPool.backendPool.returnObject(address, client);
                    } else {
                        ClientPool.backendPool.invalidateObject(address, client);
                    }
                    throw throwable;
                }
            }
        }
        LOG.info("finished to pull stream load records of all backends. record size: {}, cost: {} ms", (Object)pullRecordSize, (Object)(System.currentTimeMillis() - start));
        if (pullRecordSize > 0) {
            FetchStreamLoadRecord fetchStreamLoadRecord = new FetchStreamLoadRecord(beIdToLastStreamLoad);
            Catalog.getCurrentCatalog().getEditLog().logFetchStreamLoadRecord(fetchStreamLoadRecord);
        }
        if (Config.disable_show_stream_load) {
            Catalog.getCurrentCatalog().getStreamLoadRecordMgr().clearStreamLoadRecord();
        }
    }

    public void replayFetchStreamLoadRecord(FetchStreamLoadRecord fetchStreamLoadRecord) {
        ImmutableMap<Long, Backend> backends = Catalog.getCurrentSystemInfo().getIdToBackend();
        Map<Long, Long> beIdToLastStreamLoad = fetchStreamLoadRecord.getBeIdToLastStreamLoad();
        for (Backend backend : backends.values()) {
            if (!beIdToLastStreamLoad.containsKey(backend.getId())) continue;
            long lastStreamLoadTime = beIdToLastStreamLoad.get(backend.getId());
            LOG.info("Replay stream load bdbje. backend: {}, last stream load time: {}", (Object)backend.getHost(), (Object)lastStreamLoadTime);
            backend.setLastStreamLoadTime(lastStreamLoadTime);
        }
    }

    public static class FetchStreamLoadRecord
    implements Writable {
        @SerializedName(value="beIdToLastStreamLoad")
        private Map<Long, Long> beIdToLastStreamLoad;

        public FetchStreamLoadRecord(Map<Long, Long> beIdToLastStreamLoad) {
            this.beIdToLastStreamLoad = beIdToLastStreamLoad;
        }

        public void setBeIdToLastStreamLoad(Map<Long, Long> beIdToLastStreamLoad) {
            this.beIdToLastStreamLoad = beIdToLastStreamLoad;
        }

        public Map<Long, Long> getBeIdToLastStreamLoad() {
            return this.beIdToLastStreamLoad;
        }

        public void write(DataOutput out) throws IOException {
            String json = GsonUtils.GSON.toJson((Object)this);
            Text.writeString((DataOutput)out, (String)json);
        }

        public static FetchStreamLoadRecord read(DataInput in) throws IOException {
            String json = Text.readString((DataInput)in);
            return (FetchStreamLoadRecord)GsonUtils.GSON.fromJson(json, FetchStreamLoadRecord.class);
        }
    }

    class StreamLoadComparator
    implements Comparator<StreamLoadItem> {
        StreamLoadComparator() {
        }

        @Override
        public int compare(StreamLoadItem s1, StreamLoadItem s2) {
            return s1.getFinishTime().compareTo(s2.getFinishTime());
        }
    }

    public class StreamLoadItem {
        private String label;
        private long dbId;
        private String finishTime;

        public StreamLoadItem(String label, long dbId, String finishTime) {
            this.label = label;
            this.dbId = dbId;
            this.finishTime = finishTime;
        }

        public String getLabel() {
            return this.label;
        }

        public long getDbId() {
            return this.dbId;
        }

        public String getFinishTime() {
            return this.finishTime;
        }

        public List<String> getStatistics() {
            ArrayList row = Lists.newArrayList();
            row.add(this.label);
            row.add(String.valueOf(this.dbId));
            row.add(this.finishTime);
            return row;
        }
    }
}

