/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.Pair;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class Source
implements Writable {
    private static final String DEFAULT_COLUMN_SEPARATOR = "\t";
    private static final String DEFAULT_LINE_DELIMITER = "\n";
    private List<String> fileUrls;
    private List<String> columnNames;
    private String columnSeparator;
    private String lineDelimiter;
    private boolean isNegative;
    private Map<String, Pair<String, List<String>>> columnToFunction;

    public Source() {
        this.fileUrls = new ArrayList<String>();
        this.columnNames = new ArrayList<String>();
        this.columnSeparator = DEFAULT_COLUMN_SEPARATOR;
        this.lineDelimiter = DEFAULT_LINE_DELIMITER;
        this.columnToFunction = Maps.newHashMap();
    }

    public Source(List<String> fileUrls, List<String> columnNames, String columnSeprator, String lineDelimiter, boolean isNegative) {
        this.fileUrls = fileUrls;
        if (fileUrls == null) {
            this.fileUrls = new ArrayList<String>();
        }
        this.columnNames = columnNames;
        if (columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
        this.columnSeparator = columnSeprator;
        this.lineDelimiter = lineDelimiter;
        this.isNegative = isNegative;
        this.columnToFunction = Maps.newHashMap();
    }

    public Source(List<String> fileUrls) {
        this(fileUrls, null, DEFAULT_COLUMN_SEPARATOR, DEFAULT_LINE_DELIMITER, false);
    }

    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    public void setFileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    public Map<String, Pair<String, List<String>>> getColumnToFunction() {
        return this.columnToFunction;
    }

    public void setColumnToFunction(Map<String, Pair<String, List<String>>> columnToFunction) {
        this.columnToFunction = columnToFunction;
    }

    public void write(DataOutput out) throws IOException {
        int count = 0;
        if (this.fileUrls == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            count = this.fileUrls.size();
            out.writeInt(count);
            for (String string : this.fileUrls) {
                Text.writeString((DataOutput)out, (String)string);
            }
        }
        if (this.columnNames == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            count = this.columnNames.size();
            out.writeInt(count);
            for (String string : this.columnNames) {
                Text.writeString((DataOutput)out, (String)string);
            }
        }
        Text.writeString((DataOutput)out, (String)this.columnSeparator);
        Text.writeString((DataOutput)out, (String)this.lineDelimiter);
        out.writeBoolean(this.isNegative);
        if (this.columnToFunction == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            count = this.columnToFunction.size();
            out.writeInt(count);
            for (Map.Entry entry : this.columnToFunction.entrySet()) {
                Text.writeString((DataOutput)out, (String)((String)entry.getKey()));
                Pair functionPair = (Pair)entry.getValue();
                Text.writeString((DataOutput)out, (String)((String)functionPair.first));
                count = ((List)functionPair.second).size();
                out.writeInt(count);
                for (String arg : (List)functionPair.second) {
                    if (arg == null) {
                        out.writeBoolean(false);
                        continue;
                    }
                    out.writeBoolean(true);
                    Text.writeString((DataOutput)out, (String)arg);
                }
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        int count = 0;
        if (in.readBoolean()) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                this.fileUrls.add(Text.readString((DataInput)in).intern());
            }
        }
        if (in.readBoolean()) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                this.columnNames.add(Text.readString((DataInput)in).intern());
            }
        }
        this.columnSeparator = Text.readString((DataInput)in).intern();
        this.lineDelimiter = Text.readString((DataInput)in).intern();
        this.isNegative = in.readBoolean();
        if (in.readBoolean()) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                String column = Text.readString((DataInput)in).intern();
                String functionName = Text.readString((DataInput)in).intern();
                int argsNum = in.readInt();
                ArrayList args = Lists.newArrayList();
                for (int j = 0; j < argsNum; ++j) {
                    if (!in.readBoolean()) continue;
                    args.add(Text.readString((DataInput)in));
                }
                this.columnToFunction.put(column, new Pair<String, ArrayList>(functionName, args));
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source source = (Source)obj;
        if (this.fileUrls != source.fileUrls) {
            if (this.fileUrls == null || source.fileUrls == null) {
                return false;
            }
            if (this.fileUrls.size() != source.fileUrls.size()) {
                return false;
            }
            for (String string : this.fileUrls) {
                if (source.fileUrls.contains(string)) continue;
                return false;
            }
        }
        if (this.columnNames != source.columnNames) {
            if (this.columnNames == null || source.columnNames == null) {
                return false;
            }
            if (this.columnNames.size() != source.columnNames.size()) {
                return false;
            }
            for (String string : this.columnNames) {
                if (source.columnNames.contains(string)) continue;
                return false;
            }
        }
        if (this.columnToFunction != source.columnToFunction) {
            if (this.columnToFunction == null || source.columnToFunction == null) {
                return false;
            }
            if (this.columnToFunction.size() != source.columnToFunction.size()) {
                return false;
            }
            for (Map.Entry entry : this.columnToFunction.entrySet()) {
                String column = (String)entry.getKey();
                if (!source.columnToFunction.containsKey(column)) {
                    return false;
                }
                if (((Pair)entry.getValue()).equals(source.columnToFunction.get(column))) continue;
                return false;
            }
        }
        return this.columnSeparator.equals(source.columnSeparator) && this.lineDelimiter.equals(source.lineDelimiter) && this.isNegative == source.isNegative;
    }

    public int hashCode() {
        if (this.fileUrls == null || this.columnNames == null) {
            return -1;
        }
        int ret = this.fileUrls.size() ^ this.columnNames.size() ^ this.columnToFunction.size();
        ret ^= this.columnSeparator.length();
        return ret ^= this.lineDelimiter.length();
    }
}

