/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ImportColumnsStmt;
import org.apache.doris.analysis.ImportWhereStmt;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Separator;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.load.loadv2.LoadTask;

public class RoutineLoadDesc {
    private final Separator columnSeparator;
    private final Separator lineDelimiter;
    private final ImportColumnsStmt columnsInfo;
    private final ImportWhereStmt precedingFilter;
    private final ImportWhereStmt wherePredicate;
    private final Expr deleteCondition;
    private LoadTask.MergeType mergeType;
    private final PartitionNames partitionNames;
    private final String sequenceColName;

    public RoutineLoadDesc(Separator columnSeparator, Separator lineDelimiter, ImportColumnsStmt columnsInfo, ImportWhereStmt precedingFilter, ImportWhereStmt wherePredicate, PartitionNames partitionNames, Expr deleteCondition, LoadTask.MergeType mergeType, String sequenceColName) {
        this.columnSeparator = columnSeparator;
        this.lineDelimiter = lineDelimiter;
        this.columnsInfo = columnsInfo;
        this.precedingFilter = precedingFilter;
        this.wherePredicate = wherePredicate;
        this.partitionNames = partitionNames;
        this.deleteCondition = deleteCondition;
        this.mergeType = mergeType;
        this.sequenceColName = sequenceColName;
    }

    public Separator getColumnSeparator() {
        return this.columnSeparator;
    }

    public Separator getLineDelimiter() {
        return this.lineDelimiter;
    }

    public ImportColumnsStmt getColumnsInfo() {
        return this.columnsInfo;
    }

    public ImportWhereStmt getPrecedingFilter() {
        return this.precedingFilter;
    }

    public ImportWhereStmt getWherePredicate() {
        return this.wherePredicate;
    }

    public LoadTask.MergeType getMergeType() {
        return this.mergeType;
    }

    public PartitionNames getPartitionNames() {
        return this.partitionNames;
    }

    public Expr getDeleteCondition() {
        return this.deleteCondition;
    }

    public String getSequenceColName() {
        return this.sequenceColName;
    }

    public boolean hasSequenceCol() {
        return !Strings.isNullOrEmpty((String)this.sequenceColName);
    }

    public void analyze(Analyzer analyzer) throws UserException {
        if (this.mergeType != LoadTask.MergeType.MERGE && this.deleteCondition != null) {
            throw new AnalysisException("not support DELETE ON clause when merge type is not MERGE.");
        }
        if (this.mergeType == LoadTask.MergeType.MERGE && this.deleteCondition == null) {
            throw new AnalysisException("Excepted DELETE ON clause when merge type is MERGE.");
        }
    }
}

