/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.Source;

public class PartitionLoadInfo
implements Writable {
    private long version = -1L;
    private List<Source> sources;
    private boolean needLoad;

    public PartitionLoadInfo() {
        this(new ArrayList<Source>());
    }

    public PartitionLoadInfo(List<Source> sources) {
        this.sources = sources;
        this.needLoad = true;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public boolean isNeedLoad() {
        return this.needLoad;
    }

    public void setNeedLoad(boolean needLoad) {
        this.needLoad = needLoad;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeLong(0L);
        int count = 0;
        if (this.sources == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            count = this.sources.size();
            out.writeInt(count);
            for (int i = 0; i < count; ++i) {
                this.sources.get(i).write(out);
            }
        }
        out.writeBoolean(this.needLoad);
    }

    public void readFields(DataInput in) throws IOException {
        this.version = in.readLong();
        in.readLong();
        int count = 0;
        if (in.readBoolean()) {
            count = in.readInt();
            for (int i = 0; i < count; ++i) {
                Source source = new Source();
                source.readFields(in);
                this.sources.add(source);
            }
        }
        this.needLoad = in.readBoolean();
    }

    public String toString() {
        return "PartitionLoadInfo{version=" + this.version + ", needLoad=" + this.needLoad + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PartitionLoadInfo)) {
            return false;
        }
        PartitionLoadInfo info = (PartitionLoadInfo)obj;
        if (this.sources != info.sources) {
            if (this.sources == null || info.sources == null) {
                return false;
            }
            if (this.sources.size() != info.sources.size()) {
                return false;
            }
            for (Source source : this.sources) {
                if (info.sources.contains(source)) continue;
                return false;
            }
        }
        return this.version == info.version && this.needLoad == info.needLoad;
    }

    public int hashCode() {
        int ret = (int)this.version;
        return ret ^= this.sources.size();
    }
}

